/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.alipay;

import cn.felord.payment.PayException;
import cn.felord.payment.alipay.AliPayProperties;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.file.IOUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConditionalOnProperty(prefix="ali.pay", name={"v1.app-id"})
@EnableConfigurationProperties(value={AliPayProperties.class})
public class AliPayConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AliPayConfiguration.class);

    @Bean
    public AlipayClient alipayClient(AliPayProperties aliPayProperties) throws AlipayApiException {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        AliPayProperties.V1 v1 = aliPayProperties.getV1();
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        propertyMapper.from(v1::getServerUrl).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setServerUrl(arg_0));
        propertyMapper.from(v1::getAppId).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setAppId(arg_0));
        propertyMapper.from(v1::getAppPrivateKeyPath).as(this::appRSAPrivateKey).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setPrivateKey(arg_0));
        propertyMapper.from(v1::getFormat).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setFormat(arg_0));
        propertyMapper.from(v1::getCharset).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setCharset(arg_0));
        propertyMapper.from(v1::getSignType).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setSignType(arg_0));
        propertyMapper.from(v1::getAppCertPublicKeyPath).as(this::getContentFromClassPath).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setCertContent(arg_0));
        propertyMapper.from(v1::getAlipayPublicCertPath).as(this::getContentFromClassPath).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setAlipayPublicCertContent(arg_0));
        propertyMapper.from(v1::getAlipayRootCertPath).as(this::getContentFromClassPath).to(arg_0 -> ((CertAlipayRequest)certAlipayRequest).setRootCertContent(arg_0));
        return new DefaultAlipayClient(certAlipayRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContentFromClassPath(String classPath) {
        ClassPathResource resource = new ClassPathResource(classPath);
        try (InputStreamReader in = new InputStreamReader(resource.getInputStream());){
            String string = IOUtils.toString((Reader)in);
            return string;
        }
        catch (IOException e) {
            log.error("ali pay root cert is invalid ,{}", (Object)e.getMessage());
            throw new PayException("ali pay root cert path is invalid");
        }
    }

    /*
     * Exception decompiling
     */
    private String appRSAPrivateKey(String classPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

