/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.validation.executable;

import cn.featherfly.validation.executable.ExecutableValidator;
import cn.featherfly.validation.internal.InternalUtils;
import cn.featherfly.validation.metadata.JakartaConstraintViolation;
import jakarta.validation.ConstraintViolation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JakartaExecutableValidator
implements ExecutableValidator {
    private final jakarta.validation.executable.ExecutableValidator executableValidator;
    private final Function<String, ? extends RuntimeException> exceptionConstractor;

    public JakartaExecutableValidator(jakarta.validation.executable.ExecutableValidator executableValidator, Function<String, ? extends RuntimeException> exceptionConstractor) {
        this.executableValidator = executableValidator;
        this.exceptionConstractor = exceptionConstractor;
    }

    public <T> Set<cn.featherfly.validation.metadata.ConstraintViolation<T>> validateParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        return this.executableValidator.validateParameters(object, method, parameterValues, (Class[])groups).stream().map(cv -> new JakartaConstraintViolation(cv)).collect(Collectors.toSet());
    }

    public <T> Set<cn.featherfly.validation.metadata.ConstraintViolation<T>> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        return this.executableValidator.validateReturnValue(object, method, returnValue, (Class[])groups).stream().map(cv -> new JakartaConstraintViolation(cv)).collect(Collectors.toSet());
    }

    public <T> Set<cn.featherfly.validation.metadata.ConstraintViolation<T>> validateConstructorParameters(Constructor<? extends T> constructor, Object[] parameterValues, Class<?> ... groups) {
        Set set = this.executableValidator.validateConstructorParameters(constructor, parameterValues, (Class[])groups);
        return set.stream().map(cv -> new JakartaConstraintViolation(cv)).collect(Collectors.toSet());
    }

    public <T> Set<cn.featherfly.validation.metadata.ConstraintViolation<T>> validateConstructorReturnValue(Constructor<? extends T> constructor, T createdObject, Class<?> ... groups) {
        Set set = this.executableValidator.validateConstructorReturnValue(constructor, createdObject, (Class[])groups);
        return set.stream().map(cv -> new JakartaConstraintViolation(cv)).collect(Collectors.toSet());
    }

    public <T> void validateParametersThrow(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        Set cvs = this.executableValidator.validateParameters(object, method, parameterValues, (Class[])groups);
        if (cvs.isEmpty()) {
            return;
        }
        throw this.exceptionConstractor.apply(this.message(cvs, this.getClassName(object), method));
    }

    public <T> Object validateReturnValueThrow(T object, Method method, Object returnValue, Class<?> ... groups) {
        Set cvs = this.executableValidator.validateReturnValue(object, method, returnValue, (Class[])groups);
        if (cvs.isEmpty()) {
            return returnValue;
        }
        throw this.exceptionConstractor.apply(this.message(cvs, this.getClassName(object), method));
    }

    public <T> void validateConstructorParametersThrow(Constructor<? extends T> constructor, Object[] parameterValues, Class<?> ... groups) {
        Set cvs = this.executableValidator.validateConstructorParameters(constructor, parameterValues, (Class[])groups);
        if (cvs.isEmpty()) {
            return;
        }
        throw this.exceptionConstractor.apply(this.message(cvs, constructor.getDeclaringClass().getName(), constructor));
    }

    public <T> Object validateConstructorReturnValueThrow(Constructor<? extends T> constructor, T createdObject, Class<?> ... groups) {
        Set cvs = this.executableValidator.validateConstructorReturnValue(constructor, createdObject, (Class[])groups);
        if (cvs.isEmpty()) {
            return createdObject;
        }
        throw this.exceptionConstractor.apply(this.message(cvs, createdObject.getClass().getName(), constructor));
    }

    private String getClassName(Object object) {
        return object instanceof Class ? ((Class)object).getName() : object.getClass().getName();
    }

    private <T> String message(Set<ConstraintViolation<T>> cvs, String className, Executable executable) {
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        StringBuilder errorMessage = new StringBuilder();
        if (executable instanceof Method) {
            errorMessage.append(className).append(".").append(InternalUtils.getDescp((Executable)executable));
        } else {
            errorMessage.append(InternalUtils.getDescp((Executable)executable));
        }
        for (ConstraintViolation<T> constraintViolation : cvs) {
            if (executable instanceof Method) {
                names.add((CallSite)((Object)(" " + constraintViolation.getPropertyPath().toString().substring(executable.getName().length() + 1) + constraintViolation.getMessage() + ",")));
                continue;
            }
            names.add((CallSite)((Object)(" " + constraintViolation.getPropertyPath().toString().substring(executable.getDeclaringClass().getSimpleName().length() + 1) + constraintViolation.getMessage() + ",")));
        }
        names.sort(String::compareTo);
        for (String string : names) {
            errorMessage.append(string);
        }
        errorMessage.deleteCharAt(errorMessage.length() - 1);
        return errorMessage.toString();
    }
}

