/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.validation;

import cn.featherfly.validation.Validator;
import cn.featherfly.validation.executable.ExecutableValidator;
import cn.featherfly.validation.executable.JakartaExecutableValidator;
import cn.featherfly.validation.metadata.ConstraintViolation;
import cn.featherfly.validation.metadata.JakartaConstraintViolation;
import jakarta.validation.Constraint;
import jakarta.validation.metadata.BeanDescriptor;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JakartaValidator
implements Validator {
    private final jakarta.validation.Validator validator;
    private final Function<String, ? extends RuntimeException> exceptionConstractor;

    public JakartaValidator(jakarta.validation.Validator validator, Function<String, ? extends RuntimeException> exceptionConstracto) {
        this.validator = validator;
        this.exceptionConstractor = exceptionConstracto;
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.validator.validate(object, (Class[])groups).stream().map(cv -> new JakartaConstraintViolation(cv)).collect(Collectors.toSet());
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.validator.validateProperty(object, propertyName, (Class[])groups).stream().map(cv -> new JakartaConstraintViolation(cv)).collect(Collectors.toSet());
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.validator.validateValue(beanType, propertyName, value, (Class[])groups).stream().map(cv -> new JakartaConstraintViolation(cv)).collect(Collectors.toSet());
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.validator.unwrap(type);
    }

    public ExecutableValidator forExecutables() {
        return new JakartaExecutableValidator(this.validator.forExecutables(), this.exceptionConstractor);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.validator.getConstraintsForClass(clazz);
    }

    public <A extends Annotation> boolean isConstraint(Class<A> constraintType) {
        return constraintType.getAnnotation(Constraint.class) != null;
    }
}

