/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.permission;

import cn.featherfly.permission.PermissionActor;
import cn.featherfly.permission.Privilege;
import cn.featherfly.permission.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleRole
implements Role {
    private String code;
    private String name;
    private String descp;
    private Map<String, Privilege> ownPrivilegeMap = new HashMap<String, Privilege>();
    private Map<String, Privilege> readablePrivilegeMap = new HashMap<String, Privilege>();
    private Map<String, Privilege> authorizablePrivilegeMap = new HashMap<String, Privilege>();
    private Map<String, PermissionActor> actorMap = new HashMap<String, PermissionActor>();

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescp() {
        return this.descp;
    }

    public void setDescp(String descp) {
        this.descp = descp;
    }

    @Override
    public boolean hasPrivilege(Privilege privilege) {
        return this.ownPrivilegeMap.containsKey(privilege.getCode());
    }

    @Override
    public List<Privilege> getOwnPrivileges() {
        return new ArrayList<Privilege>(this.ownPrivilegeMap.values());
    }

    public SimpleRole addOwnPrivilege(Privilege privilege) {
        this.ownPrivilegeMap.put(privilege.getCode(), privilege);
        return this;
    }

    public SimpleRole addOwnPrivilege(Privilege ... privileges) {
        for (Privilege privilege : privileges) {
            this.ownPrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    public SimpleRole addOwnPrivilege(Collection<Privilege> privileges) {
        for (Privilege privilege : privileges) {
            this.ownPrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    @Override
    public List<Privilege> getReadblePrivileges() {
        return new ArrayList<Privilege>(this.readablePrivilegeMap.values());
    }

    public SimpleRole addReadblePrivilege(Privilege privilege) {
        this.readablePrivilegeMap.put(privilege.getCode(), privilege);
        return this;
    }

    public SimpleRole addReadblePrivilege(Privilege ... privileges) {
        for (Privilege privilege : privileges) {
            this.readablePrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    public SimpleRole addReadblePrivilege(Collection<Privilege> privileges) {
        for (Privilege privilege : privileges) {
            this.readablePrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    @Override
    public List<Privilege> getAuthorizablePrivileges() {
        return new ArrayList<Privilege>(this.authorizablePrivilegeMap.values());
    }

    public SimpleRole addAuthorizablePrivilege(Privilege privilege) {
        this.authorizablePrivilegeMap.put(privilege.getCode(), privilege);
        return this;
    }

    public SimpleRole addAuthorizablePrivilege(Privilege ... privileges) {
        for (Privilege privilege : privileges) {
            this.authorizablePrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    public SimpleRole addAuthorizablePrivilege(Collection<Privilege> privileges) {
        for (Privilege privilege : privileges) {
            this.authorizablePrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    @Override
    public List<PermissionActor> getActors() {
        return new ArrayList<PermissionActor>(this.actorMap.values());
    }

    public SimpleRole addActor(PermissionActor actor) {
        this.actorMap.put(actor.getId(), actor);
        return this;
    }

    public SimpleRole addActor(PermissionActor ... actors) {
        for (PermissionActor actor : actors) {
            this.actorMap.put(actor.getId(), actor);
        }
        return this;
    }

    public SimpleRole addActor(Collection<PermissionActor> actors) {
        for (PermissionActor actor : actors) {
            this.actorMap.put(actor.getId(), actor);
        }
        return this;
    }
}

