/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.permission;

import cn.featherfly.permission.PermissionActor;
import cn.featherfly.permission.Privilege;
import cn.featherfly.permission.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimplePermissionActor
implements PermissionActor {
    private String id;
    private String name;
    private String descp;
    private boolean available;
    private PermissionActor.ActorType type;
    private Map<String, Privilege> ownPrivilegeMap = new HashMap<String, Privilege>();
    private Map<String, Privilege> readablePrivilegeMap = new HashMap<String, Privilege>();
    private Map<String, Privilege> authorizablePrivilegeMap = new HashMap<String, Privilege>();
    private Map<String, Role> roleMap = new HashMap<String, Role>();

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescp() {
        return this.descp;
    }

    public void setDescp(String descp) {
        this.descp = descp;
    }

    @Override
    public PermissionActor.ActorType getType() {
        return this.type;
    }

    public void setType(PermissionActor.ActorType type) {
        this.type = type;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public boolean hasPrivilege(Privilege privilege) {
        return this.ownPrivilegeMap.containsKey(privilege.getCode());
    }

    @Override
    public List<Privilege> getOwnPrivileges() {
        return new ArrayList<Privilege>(this.ownPrivilegeMap.values());
    }

    public SimplePermissionActor addOwnPrivilege(Privilege privilege) {
        this.ownPrivilegeMap.put(privilege.getCode(), privilege);
        return this;
    }

    public SimplePermissionActor addOwnPrivilege(Privilege ... privileges) {
        for (Privilege privilege : privileges) {
            this.ownPrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    public SimplePermissionActor addOwnPrivilege(Collection<Privilege> privileges) {
        for (Privilege privilege : privileges) {
            this.ownPrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    @Override
    public List<Privilege> getReadblePrivileges() {
        return new ArrayList<Privilege>(this.readablePrivilegeMap.values());
    }

    public SimplePermissionActor addReadblePrivilege(Privilege privilege) {
        this.readablePrivilegeMap.put(privilege.getCode(), privilege);
        return this;
    }

    public SimplePermissionActor addReadblePrivilege(Privilege ... privileges) {
        for (Privilege privilege : privileges) {
            this.readablePrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    public SimplePermissionActor addReadblePrivilege(Collection<Privilege> privileges) {
        for (Privilege privilege : privileges) {
            this.readablePrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    @Override
    public List<Privilege> getAuthorizablePrivileges() {
        return new ArrayList<Privilege>(this.authorizablePrivilegeMap.values());
    }

    public SimplePermissionActor addAuthorizablePrivilege(Privilege privilege) {
        this.authorizablePrivilegeMap.put(privilege.getCode(), privilege);
        return this;
    }

    public SimplePermissionActor addAuthorizablePrivilege(Privilege ... privileges) {
        for (Privilege privilege : privileges) {
            this.authorizablePrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    public SimplePermissionActor addAuthorizablePrivilege(Collection<Privilege> privileges) {
        for (Privilege privilege : privileges) {
            this.authorizablePrivilegeMap.put(privilege.getCode(), privilege);
        }
        return this;
    }

    @Override
    public boolean hasRole(Role role) {
        return this.roleMap.containsKey(role.getCode());
    }

    @Override
    public List<Role> getRoles() {
        return new ArrayList<Role>(this.roleMap.values());
    }

    public SimplePermissionActor addRole(Role role) {
        this.roleMap.put(role.getCode(), role);
        return this;
    }

    public SimplePermissionActor addRole(Role ... roles) {
        for (Role role : roles) {
            this.roleMap.put(role.getCode(), role);
        }
        return this;
    }

    public SimplePermissionActor addRole(Collection<Role> roles) {
        for (Role role : roles) {
            this.roleMap.put(role.getCode(), role);
        }
        return this;
    }
}

