/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl.freemarker.directive;

import cn.featherfly.common.lang.Str;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.tpl.TplException;
import cn.featherfly.hammer.tpl.directive.LogicDirective;
import cn.featherfly.hammer.tpl.freemarker.FreemarkerDirective;
import cn.featherfly.hammer.tpl.supports.WhereConditionParams;
import freemarker.core.Environment;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class LogicDirectiveModel
implements FreemarkerDirective,
LogicDirective {
    private static final String BETWEEN = "between";
    private static final Pattern CONDITION_PATTERN = Pattern.compile("(\\w*\\.?[\\[`'\"]?\\w+[\\]`'\"]?) *(([=><]|<>|!=|>=|<=|!>|!<| like | in | is ) *(:\\w+|\\?)|(between) +(:\\w+|\\?) *(and) *(:\\w+|\\?))", 2);

    protected LogicDirectiveModel() {
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Boolean ifParam = null;
        String nameParam = null;
        String transverterParam = null;
        boolean force = false;
        WhereConditionParams conditionParamsManager = (WhereConditionParams)env.getCustomAttribute("__ConditionParamsManager__");
        if (conditionParamsManager == null) {
            throw new TplException(this.getLogicWorld() + " directive must be within the where directive");
        }
        Set entrySet = params.entrySet();
        for (Map.Entry ent : entrySet) {
            String paramName = (String)ent.getKey();
            TemplateModel paramValue = (TemplateModel)ent.getValue();
            if (paramName.equals("if")) {
                if (!(paramValue instanceof TemplateBooleanModel)) {
                    throw new TplException("The \"if\" parameter must be a boolean.");
                }
                ifParam = ((TemplateBooleanModel)paramValue).getAsBoolean();
                continue;
            }
            if (paramName.equals("name")) {
                if (!(paramValue instanceof TemplateScalarModel)) {
                    throw new TplException("The \"name\" parameter must be a String.");
                }
                nameParam = ((TemplateScalarModel)paramValue).getAsString();
                continue;
            }
            if (paramName.equals("transverter")) {
                if (!(paramValue instanceof TemplateScalarModel)) {
                    throw new TplException("The \"transverter\" parameter must be a String.");
                }
                transverterParam = ((TemplateScalarModel)paramValue).getAsString();
                continue;
            }
            if (paramName.equals("force")) {
                if (!(paramValue instanceof TemplateBooleanModel)) {
                    throw new TplException("The \"force\" parameter must be a boolean.");
                }
                force = ((TemplateBooleanModel)paramValue).getAsBoolean();
                continue;
            }
            throw new TplException("Unsupported parameter: " + paramName);
        }
        Writer out = env.getOut();
        if (body != null) {
            String condition;
            if (ifParam == null) {
                boolean needAppendLogicWorld = conditionParamsManager.isNeedAppendLogicWorld();
                conditionParamsManager.startGroup();
                StringWriter stringWriter = new StringWriter();
                body.render((Writer)stringWriter);
                condition = stringWriter.toString().trim();
                if (condition.length() > 0) {
                    String result = "";
                    result = needAppendLogicWorld ? " " + this.getLogicWorld() + " ( " + condition + " )" : " ( " + condition + " )";
                    out.write(result);
                }
                conditionParamsManager.endGroup();
            } else {
                String name = nameParam;
                if (ifParam.booleanValue()) {
                    boolean needAppendLogicWorld = force || conditionParamsManager.isNeedAppendLogicWorld();
                    condition = this.getContent(body);
                    name = this.getParamName(name, condition, conditionParamsManager);
                    for (String n : this.getParamNames(name)) {
                        WhereConditionParams.Param param = null;
                        param = Str.isNotBlank((String)transverterParam) ? new WhereConditionParams.Param(n.trim(), transverterParam.trim()) : new WhereConditionParams.Param(n.trim());
                        conditionParamsManager.addParam(param);
                    }
                    if (needAppendLogicWorld) {
                        condition = " " + this.getLogicWorld() + " " + condition;
                    }
                    out.write(condition);
                } else {
                    conditionParamsManager.addFilterParamNames(this.getParamNames(name, conditionParamsManager, body));
                    out.write("");
                }
            }
        }
    }

    private String getContent(TemplateDirectiveBody body) throws TemplateException, IOException {
        StringWriter stringWriter = new StringWriter();
        body.render((Writer)stringWriter);
        return stringWriter.toString().trim();
    }

    private String[] getParamNames(String name) {
        if (name.contains(",")) {
            return name.split(",");
        }
        return new String[]{name};
    }

    private String[] getParamNames(String name, WhereConditionParams conditionParamsManager, TemplateDirectiveBody body) throws TemplateException, IOException {
        return this.getParamNames(this.getParamName(name, conditionParamsManager, body));
    }

    private String getParamName(String name, WhereConditionParams conditionParamsManager, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.getParamName(name, this.getContent(body), conditionParamsManager);
        }
        return name;
    }

    private String getParamName(String name, String condition, WhereConditionParams conditionParamsManager) {
        if (StringUtils.isBlank((CharSequence)name) && condition.length() > 0) {
            Matcher m = null;
            m = CONDITION_PATTERN.matcher(condition);
            if (!m.matches()) {
                throw new IllegalArgumentException("[" + condition + "] \u67e5\u8be2\u6761\u4ef6\u65e0\u6cd5\u83b7\u53d6\u6761\u4ef6\u540d\u79f0\uff0c\u8bf7\u76f4\u63a5\u5728\u6307\u4ee4\u4e0a\u8bbe\u7f6e\u53c2\u6570\u540d\u79f0<@and name=\"paramName\">");
            }
            String paramType = null;
            boolean betweenAnd = false;
            if (BETWEEN.equalsIgnoreCase(m.group(5))) {
                paramType = m.group(6);
                betweenAnd = true;
            } else {
                paramType = m.group(4);
            }
            if ("?".equals(paramType)) {
                if (conditionParamsManager.getParamNamed() != null && conditionParamsManager.getParamNamed().booleanValue()) {
                    throw new SqldbHammerException("\u4e0d\u80fdname = ? \u548c name = :name\u6df7\u5408\u4e00\u8d77\u7528");
                }
                conditionParamsManager.setParamNamed(Boolean.valueOf(false));
                name = m.group(1);
                if (StringUtils.isBlank((CharSequence)name) || betweenAnd) {
                    throw new IllegalArgumentException("[" + condition + "] \u67e5\u8be2\u6761\u4ef6\u65e0\u6cd5\u83b7\u53d6\u6761\u4ef6\u540d\u79f0\uff0c\u8bf7\u76f4\u63a5\u5728\u6307\u4ee4\u4e0a\u8bbe\u7f6e\u53c2\u6570\u540d\u79f0<@and name=\"paramName\">\u6216\u8005<@and name=\"paramName1,paramName2\">");
                }
            } else if (paramType.startsWith(":")) {
                if (conditionParamsManager.getParamNamed() != null && !conditionParamsManager.getParamNamed().booleanValue()) {
                    throw new SqldbHammerException("\u4e0d\u80fdname = ? \u548c name = :name\u6df7\u5408\u4e00\u8d77\u7528");
                }
                conditionParamsManager.setParamNamed(Boolean.valueOf(true));
                name = paramType.substring(1);
                if (betweenAnd) {
                    name = name + "," + m.group(8).substring(1);
                }
            }
        }
        return name;
    }

    protected abstract String getLogicWorld();
}

