/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl.freemarker.directive;

import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplExecuteConfig;
import cn.featherfly.hammer.tpl.TplExecuteId;
import cn.featherfly.hammer.tpl.directive.IncludeDirective;
import cn.featherfly.hammer.tpl.freemarker.FreemarkerDirective;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;

public class IncludeDirectiveModel
extends IncludeDirective
implements FreemarkerDirective {
    public IncludeDirectiveModel(TplConfigFactory tplConfigFactory) {
        super(tplConfigFactory);
    }

    public void execute(Environment environment, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String includeTemplateName = null;
        String name = this.getName(params);
        String namespace = this.getNamespace(params);
        if (Lang.isNotEmpty((String)namespace)) {
            includeTemplateName = this.tplConfigFactory.getTemplateConfig().getTplExecuteIdParser().format(name, namespace);
            this.setIncluded(this.tplConfigFactory.getConfig(includeTemplateName), this.tplConfigFactory.getTemplateConfig().getTplExecuteIdParser().parse(environment.getCurrentNamespace().getTemplate().getName()));
        } else {
            TplExecuteId executeId = this.tplConfigFactory.getTemplateConfig().getTplExecuteIdParser().parse(environment.getCurrentNamespace().getTemplate().getName());
            TplExecuteConfig includeConfig = this.tplConfigFactory.getConfig(this.tplConfigFactory.getTemplateConfig().getTplExecuteIdParser().format(name, executeId.getNamespace()));
            includeTemplateName = includeConfig.getExecuteId();
            this.setIncluded(includeConfig, executeId);
        }
        environment.include(environment.getTemplateForInclusion(includeTemplateName, this.tplConfigFactory.getTemplateConfig().getCharset().name(), true));
    }

    private void setIncluded(TplExecuteConfig includeConfig, TplExecuteId tplExecuteId) {
        TplExecuteConfig config;
        if (Lang.isNotEmpty((Object[])includeConfig.getParams()) && !(config = this.tplConfigFactory.getConfig(tplExecuteId)).isIncluded()) {
            LinkedHashSet ps = new LinkedHashSet();
            CollectionUtils.addAll(ps, (Object[])config.getParams());
            CollectionUtils.addAll(ps, (Object[])includeConfig.getParams());
            config.setParams((TplExecuteConfig.Param[])CollectionUtils.toArray(ps, TplExecuteConfig.Param.class));
            config.setIncluded(true);
        }
    }

    private String getName(Map<String, TemplateModel> params) throws TemplateModelException {
        return this.getStringValue("include", params, "name", false);
    }

    private String getNamespace(Map<String, TemplateModel> params) throws TemplateModelException {
        return this.getStringValue("include", params, "namespace", true);
    }
}

