/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.exception.NotImplementedException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.RowIterable;
import cn.featherfly.common.repository.mapper.RowMapper;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.common.tuple.Tuple3;
import cn.featherfly.common.tuple.Tuple4;
import cn.featherfly.common.tuple.Tuple5;
import cn.featherfly.common.tuple.Tuple6;
import cn.featherfly.common.tuple.Tuples;
import cn.featherfly.hammer.config.HammerConfig;
import cn.featherfly.hammer.config.cache.QueryPageResult;
import cn.featherfly.hammer.config.tpl.TemplateConfig;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateProcessEnv;
import cn.featherfly.hammer.sqldb.tpl.freemarker.directive.WhereDirectiveModel;
import cn.featherfly.hammer.tpl.TemplateDirectives;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplException;
import cn.featherfly.hammer.tpl.TplExecuteConfig;
import cn.featherfly.hammer.tpl.TplExecuteId;
import cn.featherfly.hammer.tpl.TplExecutor;
import cn.featherfly.hammer.tpl.Transverter;
import cn.featherfly.hammer.tpl.TransverterManager;
import cn.featherfly.hammer.tpl.directive.TemplateDirective;
import cn.featherfly.hammer.tpl.method.TemplateMethod;
import cn.featherfly.hammer.tpl.supports.ConditionParamsManager;
import cn.featherfly.hammer.tpl.supports.PropertiesMappingManager;
import cn.featherfly.hammer.tpl.supports.WhereConditionParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTplExecutor
implements TplExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TplConfigFactory configFactory;
    private Jdbc jdbc;
    private JdbcMappingFactory mappingFactory;
    private SqlDbTemplateEngine<TemplateDirective, TemplateMethod> templateEngine;
    private SqlPageFactory sqlPageFactory;
    private TransverterManager transverterManager;
    private final HammerConfig hammerConfig;

    public SqlTplExecutor(@Nonnull HammerConfig hammerConfig, @Nonnull TplConfigFactory configFactory, @Nonnull SqlDbTemplateEngine templateEngine, @Nonnull Jdbc jdbc, @Nonnull JdbcMappingFactory mappingFactory, SqlPageFactory sqlPageFactory, TransverterManager transverterManager) {
        this.hammerConfig = hammerConfig;
        this.configFactory = configFactory;
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.templateEngine = templateEngine;
        this.sqlPageFactory = sqlPageFactory;
        this.transverterManager = transverterManager;
    }

    public int execute(String tplExecuteId, Map<String, Serializable> params) {
        return this.execute(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public int execute(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> queryExecution = this.getQueryExecution(tplExecuteId, params, Integer.class);
        String sql = (String)queryExecution.get0();
        ConditionParamsManager manager = (ConditionParamsManager)queryExecution.get2();
        return this.jdbc.update(sql, this.getEffectiveParamMap(params, manager));
    }

    public Map<String, Serializable> single(String tplExecuteId, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public Map<String, Serializable> single(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple3.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, this.getEffectiveParamMap(params, manager));
    }

    public <E> E single(String tplExecuteId, Class<E> entityType, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType, params);
    }

    public <E> E single(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType, this.getEffectiveParamMap(params, manager));
    }

    public <T> T single(TplExecuteId tplExecuteId, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        throw new NotImplementedException();
    }

    public <R1, R2> Tuple2<R1, R2> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, params);
    }

    public <R1, R2> Tuple2<R1, R2> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> Tuple2<R1, R2> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, prefixes, params);
    }

    public <R1, R2> Tuple2<R1, R2> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + "."), (Object)(propManager.getValue(5).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + "."), (Object)(propManager.getValue(5).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.single(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public Map<String, Serializable> unique(String tplExecuteId, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public Map<String, Serializable> unique(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, this.getEffectiveParamMap(params, manager));
    }

    public <E> E unique(String tplExecuteId, Class<E> entityType, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType, params);
    }

    public <T> T unique(TplExecuteId execution, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        throw new NotImplementedException();
    }

    public <E> E unique(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> Tuple2<R1, R2> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, params);
    }

    public <R1, R2> Tuple2<R1, R2> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> Tuple2<R1, R2> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, prefixes, params);
    }

    public <R1, R2> Tuple2<R1, R2> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + "."), (Object)(propManager.getValue(5).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + "."), (Object)(propManager.getValue(5).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> unique(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.unique(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> unique(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryUnique(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public List<Map<String, Serializable>> list(String tplExecuteId, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public List<Map<String, Serializable>> list(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, this.getEffectiveParamMap(params, manager));
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType, params);
    }

    public <T> List<T> list(TplExecuteId execution, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        throw new NotImplementedException();
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType, this.getEffectiveParamMap(params, manager));
    }

    public List<Map<String, Serializable>> list(String tplExecuteId, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params, offset, limit);
    }

    public <T> List<T> list(TplExecuteId execution, RowMapper<T> rowMapper, Map<String, Serializable> params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public List<Map<String, Serializable>> list(TplExecuteId tplExecuteId, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, params, offset, limit).get0();
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType, params, offset, limit);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType, params, offset, limit).get0();
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, params);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, null, params, offset, limit).get0();
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, prefixes, params);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, params, offset, limit);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, null, params, offset, limit).get0();
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + "."), (Object)(propManager.getValue(5) + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + "."), (Object)(propManager.getValue(5) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.list(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryList(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit).get0();
    }

    public RowIterable<Map<String, Serializable>> each(String tplExecuteId, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public RowIterable<Map<String, Serializable>> each(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, this.getEffectiveParamMap(params, manager));
    }

    public <E> RowIterable<E> each(String tplExecuteId, Class<E> entityType, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType, params);
    }

    public <E> RowIterable<E> each(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType, this.getEffectiveParamMap(params, manager));
    }

    public <T> RowIterable<T> each(String tplExecuteId, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        throw new NotImplementedException();
    }

    public <T> RowIterable<T> each(TplExecuteId execution, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        throw new NotImplementedException();
    }

    public <T> RowIterable<T> each(String tplExecuteId, RowMapper<T> rowMapper, Map<String, Serializable> params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T> RowIterable<T> each(TplExecuteId execution, RowMapper<T> rowMapper, Map<String, Serializable> params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public RowIterable<Map<String, Serializable>> each(String tplExecuteId, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params, offset, limit);
    }

    public RowIterable<Map<String, Serializable>> each(TplExecuteId tplExecuteId, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, params, offset, limit).get0();
    }

    public <E> RowIterable<E> each(String tplExecuteId, Class<E> entityType, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType, params, offset, limit);
    }

    public <E> RowIterable<E> each(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType, params, offset, limit).get0();
    }

    public <R1, R2> RowIterable<Tuple2<R1, R2>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, params);
    }

    public <R1, R2> RowIterable<Tuple2<R1, R2>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> RowIterable<Tuple2<R1, R2>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> RowIterable<Tuple2<R1, R2>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, null, params, offset, limit).get0();
    }

    public <R1, R2> RowIterable<Tuple2<R1, R2>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, prefixes, params);
    }

    public <R1, R2> RowIterable<Tuple2<R1, R2>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> RowIterable<Tuple2<R1, R2>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2> RowIterable<Tuple2<R1, R2>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3> RowIterable<Tuple3<R1, R2, R3>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> RowIterable<Tuple3<R1, R2, R3>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> RowIterable<Tuple3<R1, R2, R3>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, params, offset, limit);
    }

    public <R1, R2, R3> RowIterable<Tuple3<R1, R2, R3>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, entityType3, null, params, offset, limit).get0();
    }

    public <R1, R2, R3> RowIterable<Tuple3<R1, R2, R3>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> RowIterable<Tuple3<R1, R2, R3>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> RowIterable<Tuple3<R1, R2, R3>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> RowIterable<Tuple3<R1, R2, R3>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4> RowIterable<Tuple4<R1, R2, R3, R4>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> RowIterable<Tuple4<R1, R2, R3, R4>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> RowIterable<Tuple4<R1, R2, R3, R4>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> RowIterable<Tuple4<R1, R2, R3, R4>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, entityType3, entityType4, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4> RowIterable<Tuple4<R1, R2, R3, R4>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> RowIterable<Tuple4<R1, R2, R3, R4>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> RowIterable<Tuple4<R1, R2, R3, R4>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> RowIterable<Tuple4<R1, R2, R3, R4>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5> RowIterable<Tuple5<R1, R2, R3, R4, R5>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> RowIterable<Tuple5<R1, R2, R3, R4, R5>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> RowIterable<Tuple5<R1, R2, R3, R4, R5>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> RowIterable<Tuple5<R1, R2, R3, R4, R5>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5> RowIterable<Tuple5<R1, R2, R3, R4, R5>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> RowIterable<Tuple5<R1, R2, R3, R4, R5>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> RowIterable<Tuple5<R1, R2, R3, R4, R5>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> RowIterable<Tuple5<R1, R2, R3, R4, R5>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5, R6> RowIterable<Tuple6<R1, R2, R3, R4, R5, R6>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> RowIterable<Tuple6<R1, R2, R3, R4, R5, R6>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> RowIterable<Tuple6<R1, R2, R3, R4, R5, R6>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + "."), (Object)(propManager.getValue(5) + ".")), this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + "."), (Object)(propManager.getValue(5) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> RowIterable<Tuple6<R1, R2, R3, R4, R5, R6>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5, R6> RowIterable<Tuple6<R1, R2, R3, R4, R5, R6>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> RowIterable<Tuple6<R1, R2, R3, R4, R5, R6>> each(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.each(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> RowIterable<Tuple6<R1, R2, R3, R4, R5, R6>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryEach(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> RowIterable<Tuple6<R1, R2, R3, R4, R5, R6>> each(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return (RowIterable)this.findEach(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit).get0();
    }

    public PaginationResults<Map<String, Serializable>> pagination(String tplExecuteId, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params, offset, limit);
    }

    public PaginationResults<Map<String, Serializable>> pagination(TplExecuteId tplExecuteId, Map<String, Serializable> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Map<String, Serializable>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> listTuple = this.findList(tplExecuteId, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(this.count((String)listTuple.get1(), (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2()));
        return pagination;
    }

    public <E> PaginationResults<E> pagination(String tplExecuteId, Class<E> entityType, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType, params, offset, limit);
    }

    public <E> PaginationResults<E> pagination(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple6<List<E>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>, Optional<QueryPageResult>> listTuple = this.findList(tplExecuteId, entityType, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(this.count((String)listTuple.get1(), (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2(), ((Optional)listTuple.get5()).orElse(null)));
        return pagination;
    }

    public <T> PaginationResults<T> pagination(TplExecuteId execution, RowMapper<T> rowMapper, Map<String, Serializable> params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, (Tuple2<String, String>)((Tuple2)null), params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple2<R1, R2>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(this.count((String)listTuple.get1(), (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2()));
        return pagination;
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)((Tuple3)null), params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple3<R1, R2, R3>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(this.count((String)listTuple.get1(), (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2()));
        return pagination;
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)((Tuple4)null), params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple4<R1, R2, R3, R4>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(this.count((String)listTuple.get1(), (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2()));
        return pagination;
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)((Tuple5)null), params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple5<R1, R2, R3, R4, R5>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(this.count((String)listTuple.get1(), (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2()));
        return pagination;
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)((Tuple6)null), params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple6<R1, R2, R3, R4, R5, R6>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(this.count((String)listTuple.get1(), (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2()));
        return pagination;
    }

    public <E> E value(String tplExecuteId, Map<String, Serializable> params) {
        return this.value(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public <E> E value(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        return (E)this.value(tplExecuteId, Object.class, params);
    }

    public <E> E value(String tplExecuteId, Class<E> valueType, Map<String, Serializable> params) {
        return this.value(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), valueType, params);
    }

    public <E> E value(TplExecuteId tplExecuteId, Class<E> valueType, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, valueType);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            return this.jdbc.queryValue(sql, valueType, this.getEffectiveParamArray(params, manager, config));
        }
        return this.jdbc.queryValue(sql, valueType, this.getEffectiveParamMap(params, manager));
    }

    public boolean bool(String tplExecuteId, Map<String, Serializable> params) {
        return this.bool(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public boolean bool(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, Integer.TYPE);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryBool(sql, this.getEffectiveParamMap(params, manager));
    }

    public int intValue(String tplExecuteId, Map<String, Serializable> params) {
        return this.intValue(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public int intValue(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, Integer.TYPE);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryInt(sql, this.getEffectiveParamMap(params, manager));
    }

    public long longValue(String tplExecuteId, Map<String, Serializable> params) {
        return this.longValue(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public long longValue(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, Long.TYPE);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryLong(sql, this.getEffectiveParamMap(params, manager));
    }

    public double doubleValue(String tplExecuteId, Map<String, Serializable> params) {
        return this.doubleValue(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(tplExecuteId), params);
    }

    public double doubleValue(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, Double.TYPE);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryDouble(sql, this.getEffectiveParamMap(params, manager));
    }

    private void setCountTemplate(TplExecuteConfig config) {
        if (Lang.isEmpty((String)config.getCount()) && this.hammerConfig.getTemplateConfig().getCountSqlConverteStrategy() == TemplateConfig.CountSqlConverteStrategy.USE_EXCEPTION && this.hammerConfig.getTemplateConfig().getCountSqlConvertor() != null) {
            config.setCount((String)this.hammerConfig.getTemplateConfig().getCountSqlConvertor().apply(config.getContent()));
            this.templateEngine.putTemplate(config.getCountExecuteId(), config.getCount());
        }
    }

    private Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> getQueryExecution(TplExecuteId tplExecuteId, Serializable[] params, Class<?> ... resultTypes) {
        TplExecuteConfig config = this.configFactory.getConfig(tplExecuteId);
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.NAME) {
            throw new TplException("ParamsFormat is set to INDEX in the template. MAP cannot be used to pass parameters");
        }
        this.setCountTemplate(config);
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        for (int i = 0; i < params.length; ++i) {
            if (config.getInParamIndexs().contains(i)) {
                String name = (String)this.hammerConfig.getTemplateConfig().getParamIndexToName().apply(i);
                paramMap.put((String)this.hammerConfig.getTemplateConfig().getInParamPlaceholderName().apply(name), (Serializable)((Object)SqlUtils.convertInParamsPlaceholder((Object)params[i])));
                paramMap.put(name, params[i]);
                continue;
            }
            paramMap.put((String)this.hammerConfig.getTemplateConfig().getParamIndexToName().apply(i), params[i]);
        }
        Tuple3<String, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getExecution(tplExecuteId.getId(), config.getContent(), paramMap, resultTypes);
        this.logger.debug("tplExecuteId -> {} \nexecuteQuerySql -> {} \nqueryTemplate -> {}", new Object[]{tplExecuteId, tuple3.get0(), config.getContent()});
        return Tuples.of((Object)tuple3.get0(), (Object)config, (Object)tuple3.get1(), (Object)tuple3.get2());
    }

    private Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> getQueryExecution(TplExecuteId tplExecuteId, Map<String, Serializable> params, Class<?> ... resultTypes) {
        TplExecuteConfig config = this.configFactory.getConfig(tplExecuteId);
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX && (config.getParams() == null || config.getParamNames() == null)) {
            throw new TplException("ParamsFormat is set to INDEX in the template and (paramNames|params) is empty, MAP cannot be used to pass parameters");
        }
        this.setCountTemplate(config);
        for (String inParamName : config.getInParamNames()) {
            Serializable value = params.get(inParamName);
            if (value == null) continue;
            params.put((String)this.hammerConfig.getTemplateConfig().getInParamPlaceholderName().apply(inParamName), (Serializable)((Object)SqlUtils.convertInParamsPlaceholder((Object)value)));
        }
        Tuple3<String, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getExecution(tplExecuteId.getId(), config.getContent(), params, resultTypes);
        this.logger.debug("tplExecuteId -> {} \nexecuteQuerySql -> {} \nqueryTemplate -> {}", new Object[]{tplExecuteId, tuple3.get0(), config.getContent()});
        return Tuples.of((Object)tuple3.get0(), (Object)config, (Object)tuple3.get1(), (Object)tuple3.get2());
    }

    private Tuple2<String, ConditionParamsManager> getCountExecution(Map<String, Serializable> params, TplExecuteConfig config) {
        String templateName = config.getExecuteId() + ".count";
        Tuple3<String, ConditionParamsManager, PropertiesMappingManager> result = this.getExecution(templateName, config.getCount(), params, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.logger.debug("tplExecuteId -> {}  \nexecuteCountSql -> {}  \ncountTemplate -> {}", new Object[]{config.getExecuteId(), result.get0(), config.getCount()});
        return Tuples.of((Object)result.get0(), (Object)result.get1());
    }

    private Tuple3<String, ConditionParamsManager, PropertiesMappingManager> getExecution(String templateName, String sql, Map<String, Serializable> params, Class<?> ... resultTypes) {
        this.logger.debug("execute template name : {}", (Object)templateName);
        PropertiesMappingManager propertiesMappingManager = new PropertiesMappingManager();
        HashMap<String, Serializable> root = new HashMap<String, Serializable>();
        root.putAll(params);
        SqlDbTemplateProcessEnv<TemplateDirective, TemplateMethod> templateProcessEnv = this.createTemplateProcessEnv(propertiesMappingManager, resultTypes);
        TemplateDirectives<TemplateDirective> directives = templateProcessEnv.createDirectives();
        WhereDirectiveModel whereDirective = (WhereDirectiveModel)directives.getWhereDirective();
        String result = this.templateEngine.process(templateName, sql, params, directives, templateProcessEnv.createMethods());
        return Tuples.of((Object)result, (Object)whereDirective.getConditionParamsManagers(), (Object)propertiesMappingManager);
    }

    private SqlDbTemplateProcessEnv<TemplateDirective, TemplateMethod> createTemplateProcessEnv(PropertiesMappingManager propertiesMappingManager, Class<?> ... resultTypes) {
        SqlDbTemplateProcessEnv env = (SqlDbTemplateProcessEnv)this.templateEngine.createTemplateProcessEnv();
        env.setConfigFactory(this.configFactory);
        env.setDialect(this.jdbc.getDialect());
        env.setTemplateConfig(this.hammerConfig.getTemplateConfig());
        env.setPropertiesMappingManager(propertiesMappingManager);
        env.setMappingFactory(this.mappingFactory);
        env.setResultTypes(resultTypes);
        return env;
    }

    private Tuple5<List<Map<String, Serializable>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findList(TplExecuteId tplExecuteId, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        List<Map<String, Serializable>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            SqlPageFactory.SqlPageQuery<Serializable[]> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamArray(params, manager, config));
            list = this.jdbc.queryList(sqlPageQuery.getSql(), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        list = this.jdbc.queryList(sqlPageQuery.getSql(), sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E> Tuple6<List<E>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>, Optional<QueryPageResult>> findList(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType);
        List<Object> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple3.get1();
        Map<String, Serializable> key = null;
        QueryPageResult queryPageResult = null;
        Cache queryPageResultCache = this.hammerConfig.getCacheConfig().getQueryPageResultCache();
        if (this.hammerConfig.getTemplateConfig().getQueryConfig().isCachePageResults() && queryPageResultCache != null) {
            key = this.getKey(sql, params);
            queryPageResult = (QueryPageResult)queryPageResultCache.get(key);
            list = this.getCacheList(queryPageResult, offset);
        }
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            SqlPageFactory.SqlPageQuery<Serializable[]> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamArray(params, manager, config));
            if (list == null) {
                list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType, sqlPageQuery.getParams());
                queryPageResult = this.setCacheList((Cache<Object, QueryPageResult>)queryPageResultCache, list, queryPageResult, offset);
            }
            return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, this.getEffectiveParamMap(params, manager), Optional.ofNullable(queryPageResult));
        }
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (list == null) {
            list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType, sqlPageQuery.getParams());
            queryPageResult = this.setCacheList((Cache<Object, QueryPageResult>)queryPageResultCache, list, queryPageResult, offset);
        }
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, sqlPageQuery.getParams(), Optional.ofNullable(queryPageResult));
    }

    private <R> List<R> getCacheList(QueryPageResult queryPageResult, int offset) {
        if (this.hammerConfig.getTemplateConfig().getQueryConfig().isCachePageResults() && queryPageResult != null) {
            return queryPageResult.getPageList(offset);
        }
        return null;
    }

    private <R> QueryPageResult setCacheList(Cache<Object, QueryPageResult> queryPageResultCache, List<R> list, QueryPageResult queryPageResult, int offset) {
        if (queryPageResultCache != null && this.hammerConfig.getTemplateConfig().getQueryConfig().isCachePageResults()) {
            queryPageResult = (QueryPageResult)Lang.ifNull((Object)queryPageResult, (Object)new QueryPageResult());
            queryPageResult.addPageList(offset, list);
        }
        return queryPageResult;
    }

    private <E1, E2> Tuple5<List<Tuple2<E1, E2>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple2<E1, E2>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2, E3> Tuple5<List<Tuple3<E1, E2, E3>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple3<E1, E2, E3>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2, E3, E4> Tuple5<List<Tuple4<E1, E2, E3, E4>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple4<E1, E2, E3, E4>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2, E3, E4, E5> Tuple5<List<Tuple5<E1, E2, E3, E4, E5>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Class<E5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple5<E1, E2, E3, E4, E5>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2, E3, E4, E5, E6> Tuple5<List<Tuple6<E1, E2, E3, E4, E5, E6>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Class<E5> entityType5, Class<E6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple6<E1, E2, E3, E4, E5, E6>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + "."), (Object)(propManager.getValue(5).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryList(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private Map<String, Serializable> getKey(String sql, Map<String, Serializable> params) {
        HashMap<String, Serializable> key = new HashMap<String, Serializable>(params.size() + 1);
        key.put("$@#SQL#$@", (Serializable)((Object)sql));
        key.putAll(params);
        return key;
    }

    private long count(String sql, Map<String, Serializable> effectiveParams, ConditionParamsManager ConditionParamsManagers, TplExecuteConfig config) {
        return this.count(sql, effectiveParams, ConditionParamsManagers, config, null);
    }

    private long count(String sql, Map<String, Serializable> effectiveParams, ConditionParamsManager conditionParamsManager, TplExecuteConfig config, QueryPageResult queryPageResult) {
        Long total = null;
        Map<String, Serializable> key = null;
        Cache queryPageResultCache = this.hammerConfig.getCacheConfig().getQueryPageResultCache();
        if (this.hammerConfig.getTemplateConfig().getQueryConfig().isCachePageCount() && queryPageResultCache != null) {
            key = this.getKey(sql, effectiveParams);
            if (queryPageResult == null) {
                queryPageResult = (QueryPageResult)queryPageResultCache.get(key);
            }
            if (queryPageResult != null) {
                total = queryPageResult.getTotal();
            }
            if (total != null) {
                this.logger.debug("pagination count result [{}] found in cache", (Object)total);
                return total;
            }
        }
        String countSql = null;
        ConditionParamsManager manager = null;
        if (Lang.isEmpty((String)config.getCount())) {
            countSql = SqlUtils.convertSelectToCount((String)sql);
            manager = conditionParamsManager;
        } else {
            Tuple2<String, ConditionParamsManager> countTuple = this.getCountExecution(effectiveParams, config);
            countSql = (String)countTuple.get0();
            manager = (ConditionParamsManager)countTuple.get1();
        }
        total = config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX ? Long.valueOf(this.jdbc.queryLong(countSql, this.getEffectiveParamArray(effectiveParams, manager, config))) : Long.valueOf(this.jdbc.queryLong(countSql, effectiveParams));
        if (this.hammerConfig.getTemplateConfig().getQueryConfig().isCachePageCount() && queryPageResultCache != null) {
            if (queryPageResult != null) {
                queryPageResult.setTotal(total);
            } else {
                queryPageResult = new QueryPageResult(total);
            }
        }
        if (queryPageResult != null && queryPageResultCache != null) {
            queryPageResultCache.put(key, (Object)queryPageResult);
        }
        return total;
    }

    private Serializable[] getEffectiveParamArray(Serializable[] params, ConditionParamsManager manager) {
        ArrayList paramList = new ArrayList(params.length);
        for (int i = 0; i < params.length; ++i) {
            if (manager.filterParamIndex(i)) continue;
            Lang.eachObj((Object)params[i], o -> paramList.add(o));
        }
        return paramList.toArray(new Serializable[paramList.size()]);
    }

    private Serializable[] getEffectiveParamArray(Map<String, Serializable> params, ConditionParamsManager manager, TplExecuteConfig config) {
        return (Serializable[])Arrays.stream(config.getParams()).filter(p -> !manager.filterParamName(p.getName())).map(p -> this.transvert(p.getName(), (Serializable)params.get(p.getName()), manager)).toArray(Serializable[]::new);
    }

    private Map<String, Serializable> getEffectiveParamMap(Map<String, Serializable> params, ConditionParamsManager manager) {
        return params.entrySet().stream().filter(t -> !manager.filterParamName((String)t.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.transvert((String)e.getKey(), (Serializable)e.getValue(), manager)));
    }

    private Serializable transvert(WhereConditionParams.Param param, Serializable value, ConditionParamsManager manager) {
        if (param != null && Lang.isNotEmpty((String)param.getTransverter())) {
            Transverter transverter = this.transverterManager.getExist(param.getTransverter());
            return transverter.transvert(param.getTransverter(), value);
        }
        return value;
    }

    private Serializable transvert(String name, Serializable value, ConditionParamsManager manager) {
        return this.transvert(manager.getParam(name), value, manager);
    }

    public SqlPageFactory getSqlPageFactory() {
        return this.sqlPageFactory;
    }

    public int execute(TplExecuteId tplExecuteId, Serializable ... params) {
        throw new NotImplementedException();
    }

    public boolean bool(TplExecuteId tplExecuteId, Serializable ... params) {
        throw new NotImplementedException();
    }

    public int intValue(TplExecuteId tplExecuteId, Serializable ... params) {
        throw new NotImplementedException();
    }

    public long longValue(TplExecuteId tplExecuteId, Serializable ... params) {
        throw new NotImplementedException();
    }

    public double doubleValue(TplExecuteId tplExecuteId, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <V> V value(TplExecuteId execution, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <V> V value(TplExecuteId tplExecuteId, Class<V> valueType, Serializable ... params) {
        throw new NotImplementedException();
    }

    public Map<String, Serializable> single(TplExecuteId tplExecuteId, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T> T single(TplExecuteId tplExecuteId, Class<T> mapType, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2> Tuple2<T1, T2> single(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3> Tuple3<T1, T2, T3> single(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> single(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> single(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> single(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public Map<String, Serializable> unique(TplExecuteId tplExecuteId, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T> T unique(TplExecuteId tplExecuteId, Class<T> mapType, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2> Tuple2<T1, T2> unique(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3> Tuple3<T1, T2, T3> unique(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> unique(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> unique(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> unique(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public List<Map<String, Serializable>> list(TplExecuteId tplExecuteId, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T> List<T> list(TplExecuteId tplExecuteId, Class<T> mapType, Serializable ... params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, mapType);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryList(sql, mapType, this.getEffectiveParamArray(params, manager));
    }

    public List<Map<String, Serializable>> list(TplExecuteId tplExecuteId, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T> List<T> list(TplExecuteId tplExecuteId, Class<T> mapType, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2> List<Tuple2<T1, T2>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2> List<Tuple2<T1, T2>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4> List<Tuple4<T1, T2, T3, T4>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4> List<Tuple4<T1, T2, T3, T4>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5> List<Tuple5<T1, T2, T3, T4, T5>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5> List<Tuple5<T1, T2, T3, T4, T5>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5, T6> List<Tuple6<T1, T2, T3, T4, T5, T6>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5, T6> List<Tuple6<T1, T2, T3, T4, T5, T6>> list(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public PaginationResults<Map<String, Serializable>> pagination(TplExecuteId tplExecuteId, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T> PaginationResults<T> pagination(TplExecuteId tplExecuteId, Class<T> mapType, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2> PaginationResults<Tuple2<T1, T2>> pagination(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3> PaginationResults<Tuple3<T1, T2, T3>> pagination(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4> PaginationResults<Tuple4<T1, T2, T3, T4>> pagination(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5> PaginationResults<Tuple5<T1, T2, T3, T4, T5>> pagination(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5, T6> PaginationResults<Tuple6<T1, T2, T3, T4, T5, T6>> pagination(TplExecuteId tplExecuteId, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T> T single(TplExecuteId execution, RowMapper<T> rowMapper, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T> T unique(TplExecuteId execution, RowMapper<T> rowMapper, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T> List<T> list(TplExecuteId execution, RowMapper<T> rowMapper, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T> List<T> list(TplExecuteId execution, RowMapper<T> rowMapper, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T> PaginationResults<T> pagination(TplExecuteId execution, RowMapper<T> rowMapper, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public RowIterable<Map<String, Serializable>> each(TplExecuteId execution, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T> RowIterable<T> each(TplExecuteId execution, Class<T> mappingType, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T> RowIterable<T> each(TplExecuteId execution, RowMapper<T> rowMapper, Serializable ... params) {
        throw new NotImplementedException();
    }

    public RowIterable<Map<String, Serializable>> each(TplExecuteId execution, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T> RowIterable<T> each(TplExecuteId execution, Class<T> mappingType, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T> RowIterable<T> each(TplExecuteId execution, RowMapper<T> rowMapper, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2> RowIterable<Tuple2<T1, T2>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Tuple2<String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2> RowIterable<Tuple2<T1, T2>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Tuple2<String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3> RowIterable<Tuple3<T1, T2, T3>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Tuple3<String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3> RowIterable<Tuple3<T1, T2, T3>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Tuple3<String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4> RowIterable<Tuple4<T1, T2, T3, T4>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Tuple4<String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4> RowIterable<Tuple4<T1, T2, T3, T4>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Tuple4<String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5> RowIterable<Tuple5<T1, T2, T3, T4, T5>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Tuple5<String, String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5> RowIterable<Tuple5<T1, T2, T3, T4, T5>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Tuple5<String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5, T6> RowIterable<Tuple6<T1, T2, T3, T4, T5, T6>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Class<T6> mappingType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable ... params) {
        throw new NotImplementedException();
    }

    public <T1, T2, T3, T4, T5, T6> RowIterable<Tuple6<T1, T2, T3, T4, T5, T6>> each(TplExecuteId execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Class<T6> mappingType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        throw new NotImplementedException();
    }

    private Tuple5<RowIterable<Map<String, Serializable>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findEach(TplExecuteId tplExecuteId, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        RowIterable<Map<String, Serializable>> iterable = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple4.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            SqlPageFactory.SqlPageQuery<Serializable[]> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamArray(params, manager, config));
            iterable = this.jdbc.queryEach(sqlPageQuery.getSql(), sqlPageQuery.getParams());
            return Tuples.of(iterable, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        iterable = this.jdbc.queryEach(sqlPageQuery.getSql(), sqlPageQuery.getParams());
        return Tuples.of(iterable, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E> Tuple5<RowIterable<E>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findEach(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType);
        RowIterable<E> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        TplExecuteConfig config = (TplExecuteConfig)tuple3.get1();
        if (config.getParamsFormat() == TplExecuteConfig.ParamsFormat.INDEX) {
            SqlPageFactory.SqlPageQuery<Serializable[]> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamArray(params, manager, config));
            list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType, sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2> Tuple5<RowIterable<Tuple2<E1, E2>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findEach(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        RowIterable<Tuple2<E1, E2>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2, E3> Tuple5<RowIterable<Tuple3<E1, E2, E3>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findEach(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        RowIterable<Tuple3<E1, E2, E3>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2, E3, E4> Tuple5<RowIterable<Tuple4<E1, E2, E3, E4>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findEach(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        RowIterable<Tuple4<E1, E2, E3, E4>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2, E3, E4, E5> Tuple5<RowIterable<Tuple5<E1, E2, E3, E4, E5>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findEach(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Class<E5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        RowIterable<Tuple5<E1, E2, E3, E4, E5>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        list = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }

    private <E1, E2, E3, E4, E5, E6> Tuple5<RowIterable<Tuple6<E1, E2, E3, E4, E5, E6>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Serializable>> findEach(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Class<E5> entityType5, Class<E6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        RowIterable<Tuple6<E1, E2, E3, E4, E5, E6>> iterable = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
            iterable = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + "."), (Object)(propManager.getValue(5).getAlias() + ".")), sqlPageQuery.getParams());
            return Tuples.of(iterable, (Object)sql, (Object)tuple4.get1(), (Object)manager, this.getEffectiveParamMap(params, manager));
        }
        iterable = this.jdbc.queryEach(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, sqlPageQuery.getParams());
        return Tuples.of(iterable, (Object)sql, (Object)tuple4.get1(), (Object)manager, sqlPageQuery.getParams());
    }
}

