/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.hammer.tpl.AbstractTemplateProcessEnv;
import cn.featherfly.hammer.tpl.TemplateDirectives;
import cn.featherfly.hammer.tpl.TemplateMethods;
import cn.featherfly.hammer.tpl.directive.PropertiesMappingDirective;
import cn.featherfly.hammer.tpl.directive.TemplateDirective;
import cn.featherfly.hammer.tpl.method.TemplateMethod;

public abstract class SqlDbTemplateProcessEnv<D extends TemplateDirective, M extends TemplateMethod>
extends AbstractTemplateProcessEnv<D, M> {
    protected JdbcMappingFactory mappingFactory;
    protected Dialect dialect;
    protected final boolean shared;

    public SqlDbTemplateProcessEnv(boolean shared) {
        this.shared = shared;
    }

    public void setMappingFactory(JdbcMappingFactory mappingFactory) {
        this.mappingFactory = mappingFactory;
        this.setDialect(mappingFactory.getDialect());
    }

    public JdbcMappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public TemplateDirectives<D> createDirectives() {
        TemplateDirectives directives = new TemplateDirectives();
        if (this.shared) {
            directives.addWrapDirective((Object)this.createWrapDirective());
            directives.addStringReplaceDirective((Object)this.createStringReplaceDirective());
            directives.addTemplateIncludeDirective((Object)this.createIncludeDirective());
            directives.addDirective("sql", (Object)this.createIncludeDirective());
        } else {
            directives.addWhereDirective((Object)this.createWhereDirective());
            directives.addAndDirective((Object)this.createAndDirective());
            directives.addOrDirective((Object)this.createOrDirective());
            directives.addPropertiesDirective((Object)this.createPropertiesDirective());
            TemplateDirective directive = this.createPropertiesDirective();
            if (directive instanceof PropertiesMappingDirective) {
                PropertiesMappingDirective p = (PropertiesMappingDirective)directive;
                p.setParamName("table");
                directives.addDirective("columns", (Object)directive);
            }
        }
        return directives;
    }

    public TemplateMethods<M> createMethods() {
        TemplateMethods methods = new TemplateMethods();
        if (this.shared) {
            methods.addWrapMethode((Object)this.createWrapMethode());
            methods.addStringReplaceMethode((Object)this.createStringReplaceMethode());
        }
        return methods;
    }
}

