/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.sql.dml;

import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.model.ColumnElement;
import cn.featherfly.common.db.builder.model.CompositeConditionColumnElement;
import cn.featherfly.common.db.builder.model.ConditionColumnElement;
import cn.featherfly.common.db.builder.model.SqlElement;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.operator.ComparisonOperator;
import cn.featherfly.common.repository.AliasRepository;
import cn.featherfly.common.repository.Field;
import cn.featherfly.common.repository.RepositoryAwareField;
import cn.featherfly.common.repository.builder.BuilderException;
import cn.featherfly.common.repository.builder.BuilderExceptionCode;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.ParamedExpression;
import java.util.function.Predicate;

public class SqlConditionExpressionBuilder
implements ParamedExpression,
SqlBuilder {
    private ConditionColumnElement conditionColumnElement;

    public SqlConditionExpressionBuilder(Dialect dialect, ColumnElement name, Object value, ComparisonOperator comparisonOperator, String queryAlias, Predicate<?> ignoreStrategy) {
        this(dialect, name, value, comparisonOperator, ComparisonOperator.MatchStrategy.AUTO, queryAlias, ignoreStrategy);
    }

    public SqlConditionExpressionBuilder(Dialect dialect, ColumnElement name, Object value, ComparisonOperator comparisonOperator, ComparisonOperator.MatchStrategy matchStrategy, String queryAlias, Predicate<?> ignoreStrategy) {
        this.init(dialect, name, value, comparisonOperator, matchStrategy, queryAlias, ignoreStrategy);
    }

    public SqlConditionExpressionBuilder(Dialect dialect, ColumnElement name, Object value, ComparisonOperator comparisonOperator, Predicate<?> ignoreStrategy) {
        this(dialect, name, value, comparisonOperator, null, ignoreStrategy);
    }

    public SqlConditionExpressionBuilder(Dialect dialect, String name, Object value, ComparisonOperator comparisonOperator, Predicate<?> ignoreStrategy) {
        this(dialect, name, value, comparisonOperator, null, ignoreStrategy);
    }

    public SqlConditionExpressionBuilder(Dialect dialect, String name, Object value, ComparisonOperator comparisonOperator, String queryAlias, Predicate<?> ignoreStrategy) {
        this(dialect, name, value, comparisonOperator, ComparisonOperator.MatchStrategy.AUTO, queryAlias, ignoreStrategy);
    }

    public SqlConditionExpressionBuilder(Dialect dialect, String name, Object value, ComparisonOperator comparisonOperator, ComparisonOperator.MatchStrategy matchStrategy, String queryAlias, Predicate<?> ignoreStrategy) {
        this.init(dialect, name, value, comparisonOperator, matchStrategy, queryAlias, ignoreStrategy);
    }

    private void init(Dialect dialect, String name, Object value, ComparisonOperator comparisonOperator, ComparisonOperator.MatchStrategy matchStrategy, String queryAlias, Predicate<?> ignoreStrategy) {
        if (comparisonOperator == null) {
            throw new BuilderException(BuilderExceptionCode.createQueryOperatorNullCode());
        }
        if (value instanceof RepositoryAwareField) {
            RepositoryAwareField f = (RepositoryAwareField)value;
            AliasRepository r = (AliasRepository)f.repository();
            ColumnElement se = new ColumnElement(dialect, r.alias(), f.name());
            this.conditionColumnElement = new ConditionColumnElement(dialect, queryAlias, name, (Object)se, comparisonOperator, matchStrategy, ignoreStrategy);
        } else if (value instanceof Field) {
            Field f = (Field)value;
            ColumnElement se = new ColumnElement(dialect, f.name());
            this.conditionColumnElement = new ConditionColumnElement(dialect, queryAlias, name, (Object)se, comparisonOperator, matchStrategy, ignoreStrategy);
        } else if (value instanceof Expression) {
            SqlElement se = () -> ((Expression)value).expression();
            this.conditionColumnElement = new ConditionColumnElement(dialect, queryAlias, name, (Object)se, comparisonOperator, matchStrategy, ignoreStrategy);
        } else {
            this.conditionColumnElement = new ConditionColumnElement(dialect, queryAlias, name, value, comparisonOperator, matchStrategy, ignoreStrategy);
        }
    }

    private void init(Dialect dialect, ColumnElement name, Object value, ComparisonOperator comparisonOperator, ComparisonOperator.MatchStrategy matchStrategy, String queryAlias, Predicate<?> ignoreStrategy) {
        if (comparisonOperator == null) {
            throw new BuilderException(BuilderExceptionCode.createQueryOperatorNullCode());
        }
        if (value instanceof RepositoryAwareField) {
            RepositoryAwareField f = (RepositoryAwareField)value;
            AliasRepository r = (AliasRepository)f.repository();
            ColumnElement se = new ColumnElement(dialect, r.alias(), f.name());
            this.conditionColumnElement = new CompositeConditionColumnElement(dialect, queryAlias, name, (Object)se, comparisonOperator, matchStrategy, ignoreStrategy);
        } else if (value instanceof Field) {
            Field f = (Field)value;
            ColumnElement se = new ColumnElement(dialect, f.name());
            this.conditionColumnElement = new CompositeConditionColumnElement(dialect, queryAlias, name, (Object)se, comparisonOperator, matchStrategy, ignoreStrategy);
        } else if (value instanceof Expression) {
            SqlElement se = () -> ((Expression)value).expression();
            this.conditionColumnElement = new CompositeConditionColumnElement(dialect, queryAlias, name, (Object)se, comparisonOperator, matchStrategy, ignoreStrategy);
        } else {
            this.conditionColumnElement = new CompositeConditionColumnElement(dialect, queryAlias, name, value, comparisonOperator, matchStrategy, ignoreStrategy);
        }
    }

    public static Builder field(String field) {
        return new Builder(field);
    }

    public static Builder field(ColumnElement field) {
        return new Builder(field);
    }

    public ConditionColumnElement getConditionColumnElement() {
        return this.conditionColumnElement;
    }

    public Object getParam() {
        return this.conditionColumnElement.getParam();
    }

    public String build() {
        return this.conditionColumnElement.toSql();
    }

    public String toString() {
        return this.build();
    }

    public String expression() {
        return this.build();
    }

    public static class Builder {
        private Dialect dialect;
        private String tableAlias;
        private Object field;
        private ComparisonOperator.MatchStrategy matchStrategy;
        private ComparisonOperator comparisonOperator;
        private Predicate<?> ignoreStrategy;
        private Object value;

        private Builder(String field) {
            this.field = field;
        }

        private Builder(ColumnElement field) {
            this.field = field;
        }

        public SqlConditionExpressionBuilder build() {
            if (this.field instanceof String) {
                return new SqlConditionExpressionBuilder(this.dialect, (String)this.field, this.value, this.comparisonOperator, this.matchStrategy, this.tableAlias, this.ignoreStrategy);
            }
            if (this.field instanceof ColumnElement) {
                return new SqlConditionExpressionBuilder(this.dialect, (ColumnElement)this.field, this.value, this.comparisonOperator, this.matchStrategy, this.tableAlias, this.ignoreStrategy);
            }
            throw new UnsupportedException("field type " + this.field.getClass().getName());
        }

        public Builder dialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder tableAlias(String tableAlias) {
            this.tableAlias = tableAlias;
            return this;
        }

        public Builder matchStrategy(ComparisonOperator.MatchStrategy matchStrategy) {
            this.matchStrategy = matchStrategy;
            return this;
        }

        public Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        public Builder ignoreStrategy(Predicate<?> ignoreStrategy) {
            this.ignoreStrategy = ignoreStrategy;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }
    }
}

