/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeysHolder;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractBatchExecuteOperate;
import java.io.Serializable;
import java.util.List;

public class UpsertOperate<T>
extends AbstractBatchExecuteOperate<T> {
    public UpsertOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    @Override
    protected boolean supportBatch() {
        return this.jdbc.getDialect().supportUpsertBatch();
    }

    @Override
    protected int doSqlExecuteBatch(List<T> entities) {
        List pks = this.classMapping.getPrimaryKeyPropertyMappings();
        Tuple2 tuple = ClassMappingUtils.getUpsertBatchSqlAndMappings((int)entities.size(), (JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        String sql = (String)tuple.get0();
        return this.jdbc.updateBatch(sql, entities.size(), this.createGeneratedKeysHolder(entities, pks), this.getBatchParameters(entities, (JdbcPropertyMapping[])tuple.get1()));
    }

    @Override
    public int execute(final T entity) {
        final List pks = this.classMapping.getPrimaryKeyPropertyMappings();
        if (pks.size() == 1) {
            return this.jdbc.update(this.sql, new GeneratedKeyHolder<Serializable>(){

                @Override
                public void acceptKey(Serializable key) {
                    if (BeanUtils.getProperty((Object)entity, (String)((JdbcPropertyMapping)pks.get(0)).getPropertyName()) == null) {
                        BeanUtils.setProperty((Object)entity, (String)((JdbcPropertyMapping)pks.get(0)).getPropertyName(), (Object)key);
                    }
                }

                @Override
                public Type<Serializable> getType() {
                    return BeanDescriptor.getBeanDescriptor((Class)UpsertOperate.this.classMapping.getType()).getBeanProperty(((JdbcPropertyMapping)pks.get(0)).getPropertyName());
                }
            }, this.getParameters(entity));
        }
        return this.jdbc.update(this.sql, this.getParameters(entity));
    }

    @Override
    protected int[] doJdbcExecuteBatch(List<T> entities) {
        List pks = this.classMapping.getPrimaryKeyPropertyMappings();
        Serializable[][] argsList = new Serializable[entities.size()][];
        Lang.each(entities, (e, i) -> {
            argsList[i] = this.getParameters(e);
        });
        int[] results = pks.size() == 1 ? this.jdbc.updateBatch(this.sql, this.createGeneratedKeysHolder(entities, pks), argsList) : this.jdbc.updateBatch(this.sql, argsList);
        return results;
    }

    @Override
    protected void initSql() {
        Tuple2 tuple = ClassMappingUtils.getUpsertSqlAndMappings((JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.logger.debug("sql: {}", (Object)this.sql);
        this.setParamsPropertyAndMappings((JdbcPropertyMapping[])tuple.get1());
    }

    private GeneratedKeysHolder<Serializable> createGeneratedKeysHolder(final List<T> entities, final List<JdbcPropertyMapping> pks) {
        return new GeneratedKeysHolder<Serializable>(){

            public void acceptKey(Serializable key, int row) {
                if (row < entities.size() && BeanUtils.getProperty(entities.get(row), (String)((JdbcPropertyMapping)pks.get(0)).getPropertyName()) == null) {
                    BeanUtils.setProperty(entities.get(row), (String)((JdbcPropertyMapping)pks.get(0)).getPropertyName(), (Object)key);
                }
            }

            @Override
            public Type<Serializable> getType() {
                return BeanDescriptor.getBeanDescriptor((Class)UpsertOperate.this.classMapping.getType()).getBeanProperty(((JdbcPropertyMapping)pks.get(0)).getPropertyName());
            }

            @Override
            public void acceptKey(List<Serializable> keys) {
                if (keys.size() == entities.size()) {
                    for (int i = 0; i < keys.size(); ++i) {
                        this.acceptKey(keys.get(i), i);
                    }
                } else {
                    UpsertOperate.this.logger.warn("entities.size[{}] != genereteKeys.size[{}], can not set generate key to entity object", (Object)entities.size(), (Object)keys.size());
                }
            }
        };
    }

    @Override
    protected void validate(T entity) {
    }

    @Override
    protected String getName() {
        return "insertOrUpdateById";
    }
}

