/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.FieldValueOperator;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.ResultSetConcurrency;
import cn.featherfly.common.db.metadata.ResultSetType;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.debug.UpdateDebugMessage;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.ExecuteFetchOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.GetOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.UpdateOperate;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class UpdateFetchOperate<T>
extends AbstractOperate<T>
implements ExecuteFetchOperate<T> {
    private boolean supportsResultSetUpdatable;
    private List<JdbcPropertyMapping> pkPms;
    private GetOperate<T> getOperate;
    private UpdateOperate<T> updateOperate;
    private Consumer<String> doLock;
    private Consumer<String> doUnLock;
    private boolean priorityUseDatabaseRowLock = true;

    public UpdateFetchOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata, GetOperate<T> getOperate, UpdateOperate<T> updateOperate, Consumer<String> doLock, Consumer<String> doUnLock) {
        this(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata, getOperate, updateOperate, doLock, doUnLock, true);
    }

    public UpdateFetchOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata, GetOperate<T> getOperate, UpdateOperate<T> updateOperate, Consumer<String> doLock, Consumer<String> doUnLock, boolean priorityUseDatabaseRowLock) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
        this.getOperate = getOperate;
        this.updateOperate = updateOperate;
        this.doLock = doLock;
        this.doUnLock = doUnLock;
        this.priorityUseDatabaseRowLock = priorityUseDatabaseRowLock;
    }

    private boolean initSupportsResultSetUpdatable() {
        this.supportsResultSetUpdatable = this.databaseMetadata.getFeatures().supportsResultSetConcurrency(ResultSetType.FORWARD_ONLY, ResultSetConcurrency.CONCUR_UPDATABLE);
        return this.supportsResultSetUpdatable;
    }

    @Override
    protected void initSql() {
        if (this.initSupportsResultSetUpdatable()) {
            this.sql = ClassMappingUtils.getSelectByPkSql((JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
            this.pkPms = this.classMapping.getPrimaryKeyPropertyMappings();
            this.logger.debug("sql: {}", (Object)this.sql);
        }
    }

    @Override
    public T execute(Serializable id, UnaryOperator<T> updateOperator, boolean lock) {
        if (this.supportsResultSetUpdatable) {
            this.getOperate.assertId(id);
            return this.executeResultSetUpdatable(lock, updateOperator, () -> this.getLockKey(id), id);
        }
        return (T)this.executeCustom(lock, updateOperator, () -> this.getLockKey(id), forUpdate -> this.getOperate.get(id, (boolean)forUpdate));
    }

    @Override
    public T execute(T entity, UnaryOperator<T> updateOperator, boolean lock) {
        if (this.supportsResultSetUpdatable) {
            return this.executeResultSetUpdatable(lock, updateOperator, () -> this.getLockKey(entity), this.getOperate.assertAndGetIds(entity));
        }
        return (T)this.executeCustom(lock, updateOperator, () -> this.getLockKey(entity), forUpdate -> this.getOperate.get(entity, (boolean)forUpdate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T executeCustom(boolean lock, UnaryOperator<T> updateOperator, Supplier<String> keySupplier, Function<Boolean, T> entitySupplier) {
        if (lock) {
            if (this.priorityUseDatabaseRowLock && this.databaseMetadata.getFeatures().supportsSelectForUpdate()) {
                return (T)this.executeCustom(updateOperator.apply(entitySupplier.apply(true)));
            }
            String key = keySupplier.get();
            try {
                this.doLock.accept(key);
                Object r = this.executeCustom(updateOperator.apply(entitySupplier.apply(false)));
                return (T)r;
            }
            finally {
                this.doUnLock.accept(key);
            }
        }
        return (T)this.executeCustom(updateOperator.apply(entitySupplier.apply(false)));
    }

    private T executeCustom(T result) {
        this.updateOperate.execute(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T executeResultSetUpdatable(boolean lock, UnaryOperator<T> updateOperator, Supplier<String> keySupplier, Serializable ... args) {
        if (lock) {
            if (this.priorityUseDatabaseRowLock && this.databaseMetadata.getFeatures().supportsSelectForUpdate()) {
                Tuple2<Object, Integer> result = this.jdbc.querySingleUpdate(this.sql + this.jdbc.getDialect().getKeyword(" for update"), this.getOperate::mapRow, (res, e) -> this.updateResultSet((ResultSet)res, (T)updateOperator.apply(e), (T)(this.fullUpdate() ? e : this.getOperate.mapRow((ResultSet)res, 1))), args);
                return (T)result.get0();
            }
            String key = keySupplier.get();
            try {
                this.doLock.accept(key);
                Object object = this.executeResultSetUpdatable(updateOperator, args).get0();
                return (T)object;
            }
            finally {
                this.doUnLock.accept(key);
            }
        }
        return (T)this.executeResultSetUpdatable(updateOperator, args).get0();
    }

    private Tuple2<T, Integer> executeResultSetUpdatable(UnaryOperator<T> updateOperator, Serializable ... args) {
        return this.jdbc.querySingleUpdate(this.sql, this.getOperate::mapRow, (res, e) -> this.updateResultSet((ResultSet)res, (T)updateOperator.apply(e), (T)(this.fullUpdate() ? e : this.getOperate.mapRow((ResultSet)res, 1))), args);
    }

    private int updateResultSet(ResultSet res, T updateEntity, T originalEntity) {
        int index = 1;
        UpdateDebugMessage updateDebugMessage = new UpdateDebugMessage(this.isDebug());
        for (JdbcPropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().isEmpty()) {
                index = this.updateValue(res, updateEntity, originalEntity, propertyMapping, index, updateDebugMessage);
                continue;
            }
            for (JdbcPropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                index = this.updateValue(res, updateEntity, originalEntity, subPropertyMapping, index, updateDebugMessage);
            }
        }
        if (this.isDebug()) {
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append("\n---------- Update " + this.classMapping.getType().getName() + " Start ----------\n").append(updateDebugMessage.toString()).append("---------- Update " + this.classMapping.getType().getName() + " End ----------\n");
            this.logger.debug(debugMessage.toString());
        }
        try {
            res.updateRow();
            return 1;
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    private int updateValue(ResultSet res, T mappedObject, T originalEntity, JdbcPropertyMapping propertyMapping, int index, UpdateDebugMessage updateDebugMessage) {
        Object value = BeanUtils.getProperty(mappedObject, (String)propertyMapping.getPropertyFullName());
        if (this.fullUpdate()) {
            updateDebugMessage.debug(m -> m.addPropertyUpdate(propertyMapping.getPropertyFullName(), propertyMapping.getRepositoryFieldName(), BeanUtils.getProperty((Object)originalEntity, (String)propertyMapping.getPropertyFullName()), value));
            JdbcUtils.setParameter((ResultSet)res, (int)index, (FieldValueOperator)FieldValueOperator.create((JdbcPropertyMapping)propertyMapping, (Object)value));
        } else {
            Object original = BeanUtils.getProperty(originalEntity, (String)propertyMapping.getPropertyFullName());
            if (!Lang.equals((Object)original, (Object)value)) {
                updateDebugMessage.debug(m -> m.addPropertyUpdate(propertyMapping.getPropertyFullName(), propertyMapping.getRepositoryFieldName(), original, value));
                JdbcUtils.setParameter((ResultSet)res, (int)index, (FieldValueOperator)FieldValueOperator.create((JdbcPropertyMapping)propertyMapping, (Object)value));
            }
        }
        return ++index;
    }

    private String getLockKey(Serializable id) {
        return this.classMapping.getRepositoryName().toLowerCase() + ":" + id;
    }

    private String getLockKey(T entity) {
        List<Serializable> ids = this.getOperate.getIds(entity);
        if (ids.size() == 1) {
            return this.getLockKey(ids.get(0));
        }
        StringBuilder key = new StringBuilder(this.classMapping.getRepositoryName().toLowerCase());
        key.append("[");
        for (JdbcPropertyMapping pkPm : this.pkPms) {
            key.append(pkPm.getRepositoryFieldName().toLowerCase()).append(',');
        }
        key.deleteCharAt(key.length() - 1);
        key.append("]:");
        for (Serializable id : ids) {
            key.append(id).append(',');
        }
        key.deleteCharAt(key.length() - 1);
        return key.toString();
    }

    private boolean fullUpdate() {
        return false;
    }

    @Override
    protected String getName() {
        return "updateFetch";
    }
}

