/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.PropertyAccessor;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.tuple.Tuple4;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.ExecuteOperate;

public class MergeOperate<T>
extends AbstractOperate<T>
implements ExecuteOperate<T> {
    private final PropertyAccessor<T> propertyAccessor;

    public MergeOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata, PropertyAccessor<T> propertyAccessor) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
        this.propertyAccessor = propertyAccessor;
    }

    @Override
    public int execute(T entity) {
        return this.execute(entity, false);
    }

    public int execute(T entity, boolean onlyNull) {
        Tuple4 tuple = ClassMappingUtils.getMergeSqlAndMappings(entity, (JdbcClassMapping)this.classMapping, (boolean)onlyNull, (Dialect)this.jdbc.getDialect(), this.propertyAccessor);
        if (((Boolean)tuple.get3()).booleanValue()) {
            throw this.idNullOrEmptyException(entity.getClass());
        }
        if ((Integer)tuple.get2() == 0) {
            return 0;
        }
        return this.jdbc.update((String)tuple.get0(), this.getParameters(entity, (JdbcPropertyMapping[])tuple.get1()));
    }

    @Override
    protected void initSql() {
    }

    @Override
    protected String getName() {
        return "mergeById";
    }
}

