/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.db.FieldValueOperator;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeysHolder;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractBatchExecuteOperate;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class InsertOperate<T>
extends AbstractBatchExecuteOperate<T> {
    public InsertOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    @Override
    protected int doSqlExecuteBatch(List<T> entities) {
        List pks = this.classMapping.getPrimaryKeyPropertyMappings();
        Tuple2 tuple = ClassMappingUtils.getInsertBatchSqlAndMappings((int)entities.size(), (JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        String sql = (String)tuple.get0();
        if (pks.size() == 1 && ((JdbcPropertyMapping)pks.get(0)).getPrimaryKey().isDatabaseGeneration()) {
            return this.jdbc.updateBatch(sql, entities.size(), this.createGeneratedKeysHolder(entities, pks), this.getBatchParameters(entities, (JdbcPropertyMapping[])tuple.get1()));
        }
        return this.jdbc.updateBatch(sql, entities.size(), this.getBatchParameters(entities, (JdbcPropertyMapping[])tuple.get1()));
    }

    @Override
    public int execute(final T entity) {
        final List pks = this.classMapping.getPrimaryKeyPropertyMappings();
        if (pks.size() == 1 && ((JdbcPropertyMapping)pks.get(0)).getPrimaryKey().getIdGenerator().isDatabaseGeneration()) {
            return this.jdbc.update(this.sql, new GeneratedKeyHolder<Serializable>(){

                @Override
                public void acceptKey(Serializable key) {
                    ((JdbcPropertyMapping)pks.get(0)).getSetter().accept(entity, key);
                }

                @Override
                public Type<Serializable> getType() {
                    return ((JdbcPropertyMapping)pks.get(0)).getProperty();
                }
            }, this.getParameters(entity));
        }
        return this.jdbc.update(this.sql, this.getParameters(entity));
    }

    @Override
    protected int[] doJdbcExecuteBatch(final List<T> entities) {
        List pks = this.classMapping.getPrimaryKeyPropertyMappings();
        GeneratedKeysHolder<Serializable> keyHolder = null;
        if (pks.size() == 1 && ((JdbcPropertyMapping)pks.get(0)).getPrimaryKey().isDatabaseGeneration()) {
            keyHolder = this.createGeneratedKeysHolder(entities, pks);
        }
        return this.jdbc.updateBatch(this.sql, keyHolder, () -> new Iterator<Serializable[]>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return entities.size() > this.index;
            }

            @Override
            public Serializable[] next() {
                return InsertOperate.this.getParameters(entities.get(this.index++));
            }
        });
    }

    @Override
    protected boolean supportBatch() {
        return this.jdbc.getDialect().supportInsertBatch();
    }

    @Override
    protected void initSql() {
        Tuple2 tuple = ClassMappingUtils.getInsertSqlAndMappings((JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.logger.debug("sql: {}", (Object)this.sql);
        this.setParamsPropertyAndMappings((JdbcPropertyMapping[])tuple.get1());
    }

    private GeneratedKeysHolder<Serializable> createGeneratedKeysHolder(final List<T> entities, final List<JdbcPropertyMapping> pks) {
        return new GeneratedKeysHolder<Serializable>(){

            public void acceptKey(Serializable key, int row) {
                ((JdbcPropertyMapping)pks.get(0)).getSetter().accept(entities.get(row), key);
            }

            @Override
            public Type<Serializable> getType() {
                return BeanDescriptor.getBeanDescriptor((Class)InsertOperate.this.classMapping.getType()).getBeanProperty(((JdbcPropertyMapping)pks.get(0)).getPropertyName());
            }

            @Override
            public void acceptKey(List<Serializable> keys) {
                for (int i = 0; i < keys.size(); ++i) {
                    this.acceptKey(keys.get(i), i);
                }
            }
        };
    }

    @Override
    protected Serializable[] getParameters(T entity) {
        return this.getParameters(entity, this.paramsPropertyAndMappings);
    }

    @Override
    protected Serializable[] getParameters(T entity, JdbcPropertyMapping[] mappings) {
        Serializable[] operators = new Serializable[mappings.length];
        int i = 0;
        for (JdbcPropertyMapping propertyMapping : mappings) {
            operators[i] = propertyMapping.getPrimaryKey() != null ? FieldValueOperator.create((JdbcPropertyMapping)propertyMapping, (Object)propertyMapping.getPrimaryKey().getIdGenerator().generate(entity, (PropertyMapping)propertyMapping)) : FieldValueOperator.create((JdbcPropertyMapping)propertyMapping, propertyMapping.getGetter().apply(entity));
            ++i;
        }
        return operators;
    }

    @Override
    protected Serializable[] getBatchParameters(List<T> entities, JdbcPropertyMapping[] propertyPositions) {
        Serializable[] params = new Serializable[propertyPositions.length * entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            T entity = entities.get(i);
            int columnNum = 0;
            for (JdbcPropertyMapping propertyMapping : propertyPositions) {
                params[i * propertyPositions.length + columnNum] = propertyMapping.getPrimaryKey() != null ? FieldValueOperator.create((JdbcPropertyMapping)propertyMapping, (Object)propertyMapping.getPrimaryKey().getIdGenerator().generate(entity, (PropertyMapping)propertyMapping)) : FieldValueOperator.create((JdbcPropertyMapping)propertyMapping, propertyMapping.getGetter().apply(entity));
                ++columnNum;
            }
        }
        return params;
    }

    @Override
    protected void validate(T entity) {
    }

    @Override
    protected String getName() {
        return "insert";
    }
}

