/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.PropertyAccessor;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Str;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractQueryOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.QueryOperate;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GetOperate<T>
extends AbstractQueryOperate<T>
implements QueryOperate<T> {
    public GetOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata, PropertyAccessor<T> propertyAccessor) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata, propertyAccessor);
    }

    public Serializable getId(T entity) {
        if (entity == null) {
            return null;
        }
        if (this.pkProperties.size() == 1) {
            return (Serializable)((JdbcPropertyMapping)this.pkProperties.get(0)).getGetter().apply(entity);
        }
        if (this.pkProperties.size() > 1) {
            throw new SqldbHammerException("multy id defined in entity [" + entity.getClass().getName() + "], you can invoke getIds(entity) method instead");
        }
        this.logger.debug("no id defined in entity {}", (Object)entity.getClass().getName());
        return null;
    }

    public List<Serializable> getIds(T entity) {
        if (entity == null) {
            return Collections.emptyList();
        }
        return this.pkProperties.stream().map(property -> (Serializable)property.getGetter().apply(entity)).collect(Collectors.toList());
    }

    @Override
    public T execute(Serializable id) {
        return (T)this.get((T)id);
    }

    public T get(Serializable id) {
        return (T)this.get((T)id, false);
    }

    public T get(Serializable id, boolean forUpdate) {
        this.assertId(id);
        if (forUpdate) {
            if (this.databaseMetadata.getFeatures().supportsSelectForUpdate()) {
                return this.jdbc.querySingle(this.sql + " for update", this::mapRow, id);
            }
            throw new SqldbHammerException(Str.format((String)"unsupport [select...for update] with database {} - {}", (Object[])new Object[]{this.databaseMetadata.getProductName(), this.databaseMetadata.getProductVersion()}));
        }
        return this.jdbc.querySingle(this.sql, this::mapRow, id);
    }

    public T get(T entity) {
        return this.get(entity, false);
    }

    public T get(T entity, boolean forUpdate) {
        if (forUpdate) {
            return this.jdbc.querySingle(this.sql + " for update", this::mapRow, this.assertAndGetIds(entity));
        }
        return this.jdbc.querySingle(this.sql, this::mapRow, this.assertAndGetIds(entity));
    }

    @Override
    protected void initSql() {
        this.sql = ClassMappingUtils.getSelectByPkSql((JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.paramsPropertyAndMappings = this.pkProperties.toArray(new JdbcPropertyMapping[this.pkProperties.size()]);
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    protected void assertId(Object id) {
        if (Lang.isEmpty((Object)id)) {
            throw new SqldbHammerException("#get.id.null");
        }
    }

    protected Serializable[] assertAndGetIds(T entity) {
        this.assertEntity(entity);
        List<Serializable> ids = this.getIds(entity);
        this.assertId(ids);
        return ids.toArray(new Serializable[ids.size()]);
    }

    @Override
    protected String getName() {
        return "getById";
    }
}

