/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractBatchExecuteOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.BatchExecuteOperate;
import java.io.Serializable;
import java.util.List;

public class DeleteOperate<T>
extends AbstractBatchExecuteOperate<T>
implements BatchExecuteOperate<T> {
    public DeleteOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    public int delete(Serializable id) {
        return this.jdbc.update(this.sql, id);
    }

    public int[] deleteBatch(Serializable ... ids) {
        return this.deleteBatch(ArrayUtils.toList((Object[])ids));
    }

    public <ID extends Serializable> int[] deleteBatch(List<ID> ids) {
        if (Lang.isEmpty(ids)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndMappings((int)ids.size(), (JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        return new int[]{this.jdbc.update((String)tuple.get0(), ids.toArray(new Serializable[ids.size()]))};
    }

    @Override
    protected void initSql() {
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndMappings((JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.logger.debug("sql: {}", (Object)this.sql);
        this.paramsPropertyAndMappings = this.pkProperties.toArray(new JdbcPropertyMapping[this.pkProperties.size()]);
    }

    @Override
    protected Serializable[] getBatchParameters(List<T> entities, JdbcPropertyMapping[] propertyPositions) {
        Serializable[] params = new Serializable[propertyPositions.length];
        int pkNum = propertyPositions.length / entities.size();
        int i = 0;
        Object entity = null;
        for (JdbcPropertyMapping propertyMapping : propertyPositions) {
            if (i % pkNum == 0) {
                entity = entities.get(i / pkNum);
            }
            params[i] = (Serializable)propertyMapping.getGetter().apply(entity);
            ++i;
        }
        return params;
    }

    @Override
    protected boolean supportBatch() {
        return true;
    }

    @Override
    protected int doSqlExecuteBatch(List<T> entities) {
        int bs = entities.size();
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndMappings((int)bs, (JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        return this.jdbc.updateBatch((String)tuple.get0(), bs, this.getBatchParameters(entities, (JdbcPropertyMapping[])tuple.get1()));
    }

    @Override
    protected int[] doJdbcExecuteBatch(List<T> entities) {
        Serializable[][] argsList = new Serializable[entities.size()][];
        Lang.each(entities, (e, i) -> {
            argsList[i] = this.getParameters(e);
        });
        return this.jdbc.updateBatch(this.sql, argsList);
    }

    @Override
    protected String getName() {
        return "deleteById";
    }
}

