/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.db.FieldValueOperator;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Str;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperate<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Jdbc jdbc;
    protected final JdbcClassMapping<T> classMapping;
    protected final SqlTypeMappingManager sqlTypeMappingManager;
    protected final DatabaseMetadata databaseMetadata;
    protected String sql;
    protected JdbcPropertyMapping[] paramsPropertyAndMappings;
    protected final List<JdbcPropertyMapping> pkProperties = new ArrayList<JdbcPropertyMapping>();

    protected AbstractOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        this.jdbc = jdbc;
        this.classMapping = classMapping;
        this.databaseMetadata = databaseMetadata;
        this.sqlTypeMappingManager = sqlTypeMappingManager;
        for (JdbcPropertyMapping pm : classMapping.getPrimaryKeyPropertyMappings()) {
            this.pkProperties.add(pm);
        }
        this.initSql();
    }

    public String getSql() {
        return this.sql;
    }

    protected abstract String getName();

    protected SqldbHammerException idNullOrEmptyException(Class<?> entityType) {
        return new SqldbHammerException(Str.format((String)"can not {} entity[{}], because id value is null or empty", (Object[])new Object[]{this.getName(), entityType.getSimpleName()}));
    }

    protected void setBatchParameters(List<T> entities, Tuple2<Function<T, Serializable>, JdbcPropertyMapping>[] paramsPropertyAndMappings, PreparedStatement prep, Consumer<Serializable[]> setArgs) {
        if (Lang.isEmpty(entities)) {
            return;
        }
        try {
            Serializable[] args = new Serializable[paramsPropertyAndMappings.length];
            for (T entity : entities) {
                for (int i = 0; i < paramsPropertyAndMappings.length; ++i) {
                    Tuple2<Function<T, Serializable>, JdbcPropertyMapping> paramMapping = paramsPropertyAndMappings[i];
                    Serializable value = (Serializable)((Function)paramMapping.get0()).apply(entity);
                    ((JdbcPropertyMapping)paramMapping.get1()).getJavaTypeSqlTypeOperator().set(prep, i + 1, (Object)value);
                    args[i] = value;
                }
                setArgs.accept(args);
                prep.addBatch();
            }
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    protected Serializable[] getParameters(T entity) {
        return this.getParameters(entity, this.paramsPropertyAndMappings);
    }

    protected Serializable[] getParameters(T entity, Tuple2<Function<T, Object>, JdbcPropertyMapping>[] paramsPropertyAndMappings) {
        Serializable[] operators = new Serializable[paramsPropertyAndMappings.length];
        int i = 0;
        for (Tuple2<Function<T, Object>, JdbcPropertyMapping> paramsPropertyAndMapping : paramsPropertyAndMappings) {
            operators[i] = FieldValueOperator.create((JdbcPropertyMapping)((JdbcPropertyMapping)paramsPropertyAndMapping.get1()), ((Function)paramsPropertyAndMapping.get0()).apply(entity));
            ++i;
        }
        return operators;
    }

    protected Serializable[] getParameters(T entity, JdbcPropertyMapping[] mappings) {
        Serializable[] operators = new Serializable[mappings.length];
        int i = 0;
        for (JdbcPropertyMapping mapping : mappings) {
            operators[i] = FieldValueOperator.create((JdbcPropertyMapping)mapping, mapping.getGetter().apply(entity));
            ++i;
        }
        return operators;
    }

    protected void setParamsPropertyAndMappings(JdbcPropertyMapping[] mappings) {
        this.paramsPropertyAndMappings = mappings;
    }

    protected abstract void initSql();

    protected void assertEntity(T entity) {
        if (entity == null) {
            throw new SqldbHammerException("#entity.null");
        }
    }

    protected boolean isDebug() {
        return this.logger.isDebugEnabled();
    }
}

