/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractExecuteOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.BatchExecuteOperate;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractBatchExecuteOperate<T>
extends AbstractExecuteOperate<T>
implements BatchExecuteOperate<T> {
    protected AbstractBatchExecuteOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    @Override
    public int[] executeBatch(List<T> entities, int batchSize) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        if (this.databaseMetadata.getFeatures().supportsBatchUpdates()) {
            return this.doJdbcExecuteBatch(entities, batchSize);
        }
        if (this.supportBatch()) {
            return this.doSqlExecuteBatch(entities, batchSize);
        }
        int[] results = new int[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            results[i] = this.execute(entities.get(i));
        }
        return results;
    }

    protected abstract boolean supportBatch();

    protected abstract int doSqlExecuteBatch(List<T> var1);

    protected int[] doSqlExecuteBatch(List<T> entities, int batchSize) {
        if (entities.size() <= batchSize) {
            return new int[]{this.doSqlExecuteBatch(entities)};
        }
        int times = entities.size() / batchSize;
        if (entities.size() % batchSize != 0) {
            ++times;
        }
        int[] results = new int[times];
        for (int i = 0; i < times; ++i) {
            int start;
            int end = (start = i * batchSize) + batchSize;
            results[i] = this.doSqlExecuteBatch(entities.subList(start, end > entities.size() ? entities.size() : end));
        }
        return results;
    }

    protected int[] doJdbcExecuteBatch(List<T> entities, int batchSize) {
        if (entities.size() <= batchSize) {
            return this.doJdbcExecuteBatch(entities);
        }
        int times = entities.size() / batchSize;
        if (entities.size() % batchSize != 0) {
            ++times;
        }
        int[] results = new int[entities.size()];
        for (int i = 0; i < times; ++i) {
            int start;
            int end = (start = i * batchSize) + batchSize;
            int[] rs = this.doJdbcExecuteBatch(entities.subList(start, end > entities.size() ? entities.size() : end));
            for (int j = 0; j < rs.length; ++j) {
                results[i * batchSize + j] = rs[j];
            }
        }
        return results;
    }

    protected abstract int[] doJdbcExecuteBatch(List<T> var1);

    protected Serializable[] getBatchParameters(List<T> entities, JdbcPropertyMapping[] propertyPositions) {
        Serializable[] params = new Serializable[propertyPositions.length * entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            T entity = entities.get(i);
            int columnNum = 0;
            for (JdbcPropertyMapping propertyMapping : propertyPositions) {
                params[i * propertyPositions.length + columnNum] = (Serializable)propertyMapping.getGetter().apply(entity);
                ++columnNum;
            }
        }
        return params;
    }
}

