/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.mapper;

import cn.featherfly.common.db.mapper.SqlResultSet;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.repository.mapper.ResultSet;
import cn.featherfly.common.repository.mapper.RowMapper;
import cn.featherfly.common.tuple.Tuple;
import cn.featherfly.common.tuple.Tuples;
import cn.featherfly.hammer.sqldb.jdbc.mapper.EntityRowMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleEntityRowMapper<T extends Tuple>
implements RowMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<EntityRowMapper<?>> rowMappers = new ArrayList();

    public TupleEntityRowMapper(EntityRowMapper<?> ... rowMappers) {
        CollectionUtils.addAll(this.rowMappers, (Object[])rowMappers);
    }

    public TupleEntityRowMapper(List<EntityRowMapper<?>> rowMappers) {
        CollectionUtils.addAll(this.rowMappers, rowMappers);
    }

    public T mapRow(ResultSet rs, int rowNumber) {
        if (rs instanceof SqlResultSet) {
            SqlResultSet sqlrs = (SqlResultSet)rs;
            return this.mapRow(sqlrs.getResultSet(), rowNumber);
        }
        return null;
    }

    public T mapRow(java.sql.ResultSet resultSet, int rowNumber) {
        Object[] results = new Object[this.rowMappers.size()];
        AtomicInteger column = new AtomicInteger(1);
        for (int i = 0; i < this.rowMappers.size(); ++i) {
            results[i] = this.rowMappers.get(i).mapRow(resultSet, rowNumber, column);
        }
        return (T)Tuples.ofArray((Object[])results);
    }
}

