/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.mapper;

import cn.featherfly.common.bean.Instantiator;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapper.SqlResultSet;
import cn.featherfly.common.db.mapping.JavaTypeSqlTypeOperator;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.repository.mapper.ResultSet;
import cn.featherfly.common.repository.mapper.RowMapper;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.hammer.sqldb.jdbc.debug.MappingDebugMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySetRowMapper<T>
implements RowMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<Tuple2<BiConsumer<T, Object>, JavaTypeSqlTypeOperator<Object>>> fetchProperties = new ArrayList<Tuple2<BiConsumer<T, Object>, JavaTypeSqlTypeOperator<Object>>>(0);
    private final Instantiator<T> instantiator;
    protected final JdbcClassMapping<T> classMapping;

    public PropertySetRowMapper(Instantiator<T> instantiator, Dialect dialect, JdbcClassMapping<T> classMapping, Tuple2<BiConsumer<T, Object>, JavaTypeSqlTypeOperator<Object>>[] fetchPropertys) {
        this.instantiator = instantiator;
        this.classMapping = classMapping;
        CollectionUtils.addAll(this.fetchProperties, (Object[])fetchPropertys);
    }

    public T mapRow(ResultSet rs, int rowNumber) {
        if (rs instanceof SqlResultSet) {
            SqlResultSet sqlrs = (SqlResultSet)rs;
            return this.mapRow(sqlrs.getResultSet(), rowNumber);
        }
        return null;
    }

    public T mapRow(java.sql.ResultSet resultSet, int rowNumber) {
        Object mappedObject = this.instantiator.instantiate();
        int index = 1;
        MappingDebugMessage mappingDebugMessage = this.logger.isDebugEnabled() ? new MappingDebugMessage(this.logger.isDebugEnabled()) : null;
        for (Tuple2<BiConsumer<T, Object>, JavaTypeSqlTypeOperator<Object>> tuple : this.fetchProperties) {
            Object value = ((JavaTypeSqlTypeOperator)tuple.get1()).get(resultSet, index);
            ((BiConsumer)tuple.get0()).accept(mappedObject, value);
            ++index;
        }
        if (this.logger.isDebugEnabled() && rowNumber == 0) {
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append("\n---------- Mapping " + this.classMapping.getType().getName() + " Start ----------\n").append(mappingDebugMessage.toString()).append("---------- Mapping " + this.classMapping.getType().getName() + " End ----------\n");
            this.logger.debug(debugMessage.toString());
        }
        return (T)mappedObject;
    }
}

