/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.mapper;

import cn.featherfly.common.bean.Property;
import cn.featherfly.common.bean.PropertyAccessor;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapper.SqlResultSet;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Asserts;
import cn.featherfly.common.repository.mapper.ResultSet;
import cn.featherfly.hammer.sqldb.jdbc.debug.MappingDebugMessage;
import cn.featherfly.hammer.sqldb.jdbc.mapper.AbstractBeanRowMapper;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyAccessorRowMapper<T>
extends AbstractBeanRowMapper<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyAccessorRowMapper.class);
    private final PropertyAccessor<T> propertyAccessor;
    private final SqlTypeMappingManager manager;
    private final Map<String, Property<T, Object>> namePropertyMap;
    private List<Property<T, Object>> properties;
    private List<JdbcPropertyMapping> propertyMappings;

    public PropertyAccessorRowMapper(@Nonnull PropertyAccessor<T> propertyAccessor, @Nonnull SqlTypeMappingManager manager) {
        this.propertyAccessor = propertyAccessor;
        this.manager = manager;
        this.namePropertyMap = new HashMap<String, Property<T, Object>>(propertyAccessor.getProperties().length);
        for (Property property : propertyAccessor.getProperties()) {
            this.namePropertyMap.put(property.getName(), property);
        }
    }

    public T mapRow(ResultSet res, int rowNum) {
        java.sql.ResultSet rs = null;
        if (!(res instanceof SqlResultSet)) {
            throw new JdbcException("ResultSet is not type of SqlResultSet");
        }
        SqlResultSet sqlrs = (SqlResultSet)res;
        rs = sqlrs.getResultSet();
        AssertIllegalArgument.isNotNull((Object)rs, (String)"java.sql.ResultSet");
        try {
            return this.mapRow(rs, rowNum);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    public T mapRow(java.sql.ResultSet rs, int rowNumber) throws SQLException {
        Object mappedObject = this.propertyAccessor.instantiate();
        Asserts.isTrue((mappedObject.getClass() != null ? 1 : 0) != 0, (String)"Mapped class was not specified");
        MappingDebugMessage mappingDebugMessage = new MappingDebugMessage(LOGGER.isDebugEnabled());
        boolean isEntity = this.isEntity(this.propertyAccessor.getType());
        if (rowNumber == 0) {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            if (isEntity) {
                this.propertyMappings = new ArrayList<JdbcPropertyMapping>();
            } else {
                this.properties = new ArrayList<Property<T, Object>>();
            }
            for (int index = 1; index <= columnCount; ++index) {
                String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index);
                String field = this.lowerCaseName(StringUtils.deleteWhitespace((String)column));
                Property<T, Object> property = this.namePropertyMap.get(field);
                if (property == null) {
                    LOGGER.debug("No property found int '{}' for column '{}' mapped to field '{}'", new Object[]{this.propertyAccessor.getType().getName(), column, field});
                    throw new JdbcException("\u8fd9\u91cc\u52a0\u5165\u672a\u5339\u914d\u4e0a\u7684\u7b56\u7565");
                }
                this.properties.add(property);
            }
            if (LOGGER.isDebugEnabled()) {
                StringBuilder debugMessage = new StringBuilder();
                debugMessage.append("\n---------- Map " + mappedObject.getClass().getName() + " Start ----------\n").append(mappingDebugMessage.toString()).append("---------- Map " + mappedObject.getClass().getName() + " End ----------");
                LOGGER.debug(debugMessage.toString());
            }
        }
        if (isEntity) {
            for (JdbcPropertyMapping propertyMapping : this.propertyMappings) {
                propertyMapping.getSetter().accept(mappedObject, (Serializable)propertyMapping.getJavaTypeSqlTypeOperator().get(rs, rowNumber));
            }
        } else {
            int index = 1;
            for (Property<T, Object> property : this.properties) {
                property.set(mappedObject, this.manager.get(rs, index, property));
                ++index;
            }
        }
        return (T)mappedObject;
    }
}

