/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.mapper;

import cn.featherfly.common.bean.Instantiator;
import cn.featherfly.common.bean.PropertyAccessor;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapper.SqlResultSet;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.repository.mapper.ResultSet;
import cn.featherfly.common.repository.mapper.RowMapper;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.common.tuple.Tuples;
import cn.featherfly.hammer.sqldb.jdbc.debug.MappingDebugMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRowMapper<T>
implements RowMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Tuple2<BiConsumer<T, Serializable>, JdbcPropertyMapping>> fetchProperties = new ArrayList<Tuple2<BiConsumer<T, Serializable>, JdbcPropertyMapping>>(0);
    private final Instantiator<T> instantiator;
    private final JdbcClassMapping<T> classMapping;

    public EntityRowMapper(PropertyAccessor<T> propertyAccessor, Dialect dialect, JdbcClassMapping<T> classMapping) {
        this.instantiator = propertyAccessor;
        this.classMapping = classMapping;
        for (JdbcPropertyMapping mapping : (JdbcPropertyMapping[])ClassMappingUtils.getSelectColumnsSqlAndMappings(classMapping, null, (Dialect)dialect).get1()) {
            if (mapping.getParent() != null) {
                this.fetchProperties.add(Tuples.of((obj, value) -> propertyAccessor.setPropertyValue(obj, mapping.getPropertyIndexes(), value), (Object)mapping));
                continue;
            }
            this.fetchProperties.add(Tuples.of((Object)mapping.getSetter(), (Object)mapping));
        }
    }

    public EntityRowMapper(Instantiator<T> instantiator, Dialect dialect, JdbcClassMapping<T> classMapping, Tuple2<BiConsumer<T, Serializable>, JdbcPropertyMapping>[] fetchPropertyMappings) {
        this.instantiator = instantiator;
        this.classMapping = classMapping;
        CollectionUtils.addAll(this.fetchProperties, (Object[])fetchPropertyMappings);
    }

    public EntityRowMapper(PropertyAccessor<T> propertyAccessor, Dialect dialect, JdbcClassMapping<T> classMapping, Collection<Tuple2<int[], JdbcPropertyMapping>> fetchPropertyMappings) {
        this.instantiator = propertyAccessor;
        this.classMapping = classMapping;
        for (Tuple2<int[], JdbcPropertyMapping> tuple : fetchPropertyMappings) {
            if (((int[])tuple.get0()).length == 1) {
                BiConsumer setter = ((JdbcPropertyMapping)tuple.get1()).getSetter();
                this.fetchProperties.add(Tuples.of((Object)setter, (Object)tuple.get1()));
                continue;
            }
            this.fetchProperties.add(Tuples.of((obj, value) -> propertyAccessor.setPropertyValue(obj, (int[])tuple.get0(), value), (Object)tuple.get1()));
        }
    }

    public T mapRow(ResultSet rs, int rowNumber) {
        if (rs instanceof SqlResultSet) {
            SqlResultSet sqlrs = (SqlResultSet)rs;
            return this.mapRow(sqlrs.getResultSet(), rowNumber);
        }
        return null;
    }

    public T mapRow(java.sql.ResultSet resultSet, int rowNumber) {
        return this.mapRow(resultSet, rowNumber, new AtomicInteger(1));
    }

    public T mapRow(java.sql.ResultSet resultSet, int rowNumber, AtomicInteger columnStart) {
        Object mappedObject = this.instantiator.instantiate();
        int columnIndex = columnStart.get();
        MappingDebugMessage mappingDebugMessage = this.logger.isDebugEnabled() ? new MappingDebugMessage(this.logger.isDebugEnabled()) : null;
        for (Tuple2 tuple : this.fetchProperties) {
            if (this.logger.isDebugEnabled() && rowNumber == 0) {
                mappingDebugMessage.debug(m -> m.addMapping(((JdbcPropertyMapping)tuple.get1()).getRepositoryFieldName(), ((JdbcPropertyMapping)tuple.get1()).getPropertyFullName(), ((JdbcPropertyMapping)tuple.get1()).getPropertyFullName(), ((JdbcPropertyMapping)tuple.get1()).getPropertyType().getName()));
            }
            Serializable value = (Serializable)((JdbcPropertyMapping)tuple.get1()).getJavaTypeSqlTypeOperator().get(resultSet, columnIndex);
            ((BiConsumer)tuple.get0()).accept(mappedObject, value);
            ++columnIndex;
        }
        columnStart.set(columnIndex);
        if (this.logger.isDebugEnabled() && rowNumber == 0) {
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append("\n---------- Mapping " + this.classMapping.getType().getName() + " Start at ResultSet column index[" + columnStart.get() + "] ----------\n").append(mappingDebugMessage.toString()).append("---------- Mapping " + this.classMapping.getType().getName() + " End  at ResultSet column index [" + (columnIndex - 1) + "]----------\n");
            this.logger.debug(debugMessage.toString());
        }
        return (T)mappedObject;
    }
}

