/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapper.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapper.ResultSet;
import cn.featherfly.common.repository.mapper.RowMapper;
import cn.featherfly.common.tuple.Tuple;
import cn.featherfly.common.tuple.Tuples;
import cn.featherfly.hammer.sqldb.jdbc.NestedBeanPropertyRowMapper;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleNestedBeanPropertyRowMapper<T extends Tuple>
implements RowMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<NestedBeanPropertyRowMapper<?>> rowMappers;
    private List<Class<?>> mappedClasses;
    private boolean checkFullyPopulated;
    private SqlTypeMappingManager manager;

    public TupleNestedBeanPropertyRowMapper(List<Class<?>> mappedClasses, SqlTypeMappingManager manager) {
        this(mappedClasses, null, manager);
    }

    public TupleNestedBeanPropertyRowMapper(List<Class<?>> mappedClasses, Tuple prefixes, SqlTypeMappingManager manager) {
        this(mappedClasses, prefixes, manager, false);
    }

    public TupleNestedBeanPropertyRowMapper(List<Class<?>> mappedClasses, Tuple prefixes, SqlTypeMappingManager manager, boolean checkFullyPopulated) {
        this.rowMappers = new ArrayList(mappedClasses.size());
        if (prefixes != null) {
            Lang.each(mappedClasses, (mappedClass, index) -> this.rowMappers.add(new NestedBeanPropertyRowMapper(mappedClass, manager, (String)prefixes.get(index), checkFullyPopulated)));
        } else {
            this.mappedClasses = mappedClasses;
            this.checkFullyPopulated = checkFullyPopulated;
            this.manager = manager;
        }
    }

    public T mapRow(ResultSet res, int rowNum) {
        ArrayList results = new ArrayList();
        if (this.rowMappers.size() > 0) {
            for (NestedBeanPropertyRowMapper<?> rowMapper : this.rowMappers) {
                results.add(rowMapper.mapRow(res, rowNum));
            }
            return (T)Tuples.ofArray((Object[])results.toArray());
        }
        java.sql.ResultSet rs = null;
        if (!(res instanceof SqlResultSet)) {
            throw new JdbcException("ResultSet is not type of SqlResultSet");
        }
        SqlResultSet sqlrs = (SqlResultSet)res;
        rs = sqlrs.getResultSet();
        AssertIllegalArgument.isNotNull((Object)rs, (String)"java.sql.ResultSet");
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
            for (int index2 = 1; index2 <= columnCount; ++index2) {
                String fieldName = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index2, (boolean)true);
                String[] names = fieldName.split("\\.");
                if (names.length <= 1) continue;
                prefixes.add(names[0]);
            }
            if (prefixes.isEmpty()) {
                throw new JdbcException("prefixes is empty");
            }
            Lang.each(prefixes, (prefix, index) -> this.rowMappers.add(new NestedBeanPropertyRowMapper(this.mappedClasses.get(index), this.manager, prefix + ".", this.checkFullyPopulated)));
            return this.mapRow(res, rowNum);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }
}

