/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapper.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Str;
import cn.featherfly.common.repository.mapper.ResultSet;
import cn.featherfly.common.repository.mapper.RowMapper;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public class SingleColumnRowMapper<T>
implements RowMapper<T> {
    private Class<?> requiredType;
    private SqlTypeMappingManager manager;
    private String prefix;
    private int matchIndex = 1;

    public SingleColumnRowMapper(Class<T> requiredType, SqlTypeMappingManager manager) {
        this(requiredType, manager, null);
    }

    public SingleColumnRowMapper(@Nonnull Class<T> requiredType, @Nonnull SqlTypeMappingManager manager, String prefix) {
        AssertIllegalArgument.isNotNull(requiredType, (String)"requiredType");
        AssertIllegalArgument.isNotNull((Object)manager, (String)"sqlTypeMappingManager");
        this.setRequiredType(requiredType);
        this.manager = manager;
        this.prefix = prefix;
    }

    public void setRequiredType(Class<T> requiredType) {
        this.requiredType = ClassUtils.getPrimitiveWrapped(requiredType);
    }

    public T mapRow(ResultSet res, int rowNum) {
        java.sql.ResultSet rs = null;
        if (!(res instanceof SqlResultSet)) {
            throw new JdbcException("ResultSet is not type of SqlResultSet");
        }
        SqlResultSet sqlrs = (SqlResultSet)res;
        rs = sqlrs.getResultSet();
        AssertIllegalArgument.isNotNull((Object)rs, (String)"java.sql.ResultSet");
        try {
            return this.mapRow(rs, rowNum);
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    public T mapRow(java.sql.ResultSet rs, int rowNum) throws SQLException {
        if (rowNum == 0) {
            this.check(rs);
            this.setType(rs);
        }
        return (T)this.manager.get(rs, this.matchIndex, this.requiredType);
    }

    private void check(java.sql.ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        if (this.prefix == null) {
            int nrOfColumns = rsmd.getColumnCount();
            if (nrOfColumns != 1) {
                throw new JdbcException("Incorrect column count: expected 1, actual " + nrOfColumns);
            }
            this.matchIndex = 1;
        } else {
            int columnCount = rsmd.getColumnCount();
            String matchFiled = null;
            for (int index = 1; index <= columnCount; ++index) {
                String fieldName = JdbcUtils.getColumnName((java.sql.ResultSet)rs, (int)index);
                if (!fieldName.startsWith(this.prefix)) continue;
                if (matchFiled != null) {
                    throw new JdbcException(Str.format((String)"there is more than one column name [{0},{1}] with prefix {2}", (Object[])new Object[]{matchFiled, fieldName, this.prefix}));
                }
                matchFiled = fieldName;
                this.matchIndex = index;
            }
            if (this.matchIndex == -1) {
                throw new JdbcException("there is no column name with prefix " + this.prefix);
            }
        }
    }

    private void setType(java.sql.ResultSet rs) {
        Class type;
        if (this.requiredType == Object.class && (type = this.manager.getJavaType(JdbcUtils.getResultSetType((java.sql.ResultSet)rs, (int)this.matchIndex))) != null) {
            this.requiredType = type;
        }
    }
}

