/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.NamedParamSql;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeysHolder;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface JdbcUpdate {
    default public int update(String sql, Serializable ... args) {
        return this.update(sql, (GeneratedKeyHolder)null, args);
    }

    default public int update(String sql, Map<String, Serializable> args) {
        return this.update(sql, null, args);
    }

    default public int update(NamedParamSql sql, Map<String, Serializable> args) {
        Execution execution = sql.getExecution(args);
        return this.update(execution.getExecution(), execution.getParams());
    }

    public <T extends Serializable> int update(String var1, GeneratedKeyHolder<T> var2, Serializable ... var3);

    public <T extends Serializable> int update(String var1, GeneratedKeyHolder<T> var2, Map<String, Serializable> var3);

    default public <T extends Serializable> int update(NamedParamSql sql, GeneratedKeyHolder<T> generatedKeyHolder, Map<String, Serializable> args) {
        Execution execution = sql.getExecution(args);
        return this.update(execution.getExecution(), generatedKeyHolder, execution.getParams());
    }

    default public int[] updateBatch(String sql, Serializable[] ... argsArray) {
        return this.updateBatch(sql, (GeneratedKeysHolder)null, argsArray);
    }

    default public int[] updateBatch(String sql, List<Serializable[]> argsList) {
        return this.updateBatch(sql, (GeneratedKeysHolder)null, argsList);
    }

    public <T extends Serializable> int[] updateBatch(String var1, GeneratedKeysHolder<T> var2, Serializable[] ... var3);

    default public <T extends Serializable> int[] updateBatch(String sql, GeneratedKeysHolder<T> generatedKeyHolder, List<Serializable[]> argsList) {
        return this.updateBatch(sql, generatedKeyHolder, (Serializable[][])argsList.toArray((T[])new Serializable[argsList.size()][]));
    }

    default public int[] updateBatch(String sql, Iterable<Serializable[]> argsIter) {
        return this.updateBatch(sql, (GeneratedKeysHolder)null, argsIter);
    }

    public <T extends Serializable> int[] updateBatch(String var1, GeneratedKeysHolder<T> var2, Iterable<Serializable[]> var3);

    default public int[] updateBatch(String sql, BiConsumer<PreparedStatement, Consumer<Serializable[]>> setArgs) {
        return this.updateBatch(sql, (GeneratedKeysHolder)null, setArgs);
    }

    public <T extends Serializable> int[] updateBatch(String var1, GeneratedKeysHolder<T> var2, BiConsumer<PreparedStatement, Consumer<Serializable[]>> var3);

    default public int[] updateBatch(String sql, Map<String, Serializable>[] batchArgs) {
        return this.updateBatch(sql, null, batchArgs);
    }

    public <T extends Serializable> int[] updateBatch(String var1, GeneratedKeysHolder<T> var2, Map<String, Serializable>[] var3);

    default public int updateBatch(String sql, int batchSize, Serializable ... args) {
        return this.updateBatch(sql, batchSize, (GeneratedKeysHolder)null, args);
    }

    default public int updateBatch(String sql, int batchSize, Map<String, Serializable> args) {
        return this.updateBatch(sql, batchSize, null, args);
    }

    public <T extends Serializable> int updateBatch(String var1, int var2, GeneratedKeysHolder<T> var3, Map<String, Serializable> var4);

    public <T extends Serializable> int updateBatch(String var1, int var2, GeneratedKeysHolder<T> var3, Serializable ... var4);
}

