/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapper.SqlResultSet;
import cn.featherfly.common.repository.RowIterable;
import cn.featherfly.common.repository.mapper.ResultSet;
import cn.featherfly.common.repository.mapper.RowMapper;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class JdbcRowIterable<T>
implements RowIterable<T> {
    @Nonnull
    private SqlResultSet res;
    @Nonnull
    private RowMapper<T> mapper;

    public JdbcRowIterable(SqlResultSet res, RowMapper<T> mapper) {
        this.res = res;
        this.mapper = mapper;
    }

    public Iterator<T> iterator() {
        return new MapRowLazyIterator(this.res, this.mapper);
    }

    public void close() throws JdbcException {
        try {
            java.sql.ResultSet resultSet = this.res.getResultSet();
            if (!resultSet.isClosed()) {
                Statement stat = resultSet.getStatement();
                resultSet.close();
                if (stat != null && !stat.isClosed()) {
                    stat.close();
                }
            }
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    private static class MapRowLazyIterator<T>
    implements Iterator<T> {
        @Nonnull
        private SqlResultSet res;
        @Nonnull
        private RowMapper<T> mapper;
        private int index;
        private boolean forward;
        private boolean hasNext;

        private MapRowLazyIterator(SqlResultSet res, RowMapper<T> mapper) {
            this.res = res;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            if (this.res == null) {
                return false;
            }
            if (this.forward) {
                return this.hasNext;
            }
            try {
                this.forward = true;
                this.hasNext = this.res.getResultSet().next();
                return this.hasNext;
            }
            catch (SQLException e) {
                throw new JdbcException((Throwable)e);
            }
        }

        @Override
        public T next() {
            if (this.res == null) {
                throw new NoSuchElementException();
            }
            if (!this.forward) {
                this.hasNext();
            }
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.forward = false;
            return (T)this.mapper.mapRow((ResultSet)this.res, this.index++);
        }
    }
}

