/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapper.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.repository.MulitiQuery;
import cn.featherfly.common.repository.mapper.RowMapper;
import cn.featherfly.hammer.sqldb.jdbc.MapRowMapper;
import cn.featherfly.hammer.sqldb.jdbc.RowMapperResultSetExtractor;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class JdbcProcedureMulitiQuery
implements MulitiQuery {
    private int index = 0;
    private boolean forward;
    private boolean hasNext;
    private SqlTypeMappingManager manager;
    private Statement stat;
    private Function<Class<?>, RowMapper<?>> getTypeMapper;
    private Function<List<?>, ?> postHandler;

    public JdbcProcedureMulitiQuery(Statement stat, SqlTypeMappingManager manager, Function<Class<?>, RowMapper<?>> getTypeMapper, Function<List<?>, ?> postHandler) {
        this.stat = stat;
        this.manager = manager;
        this.getTypeMapper = getTypeMapper;
        this.postHandler = postHandler;
    }

    public List<Map<String, Serializable>> next() {
        return this.next(new MapRowMapper(this.manager));
    }

    public <E> List<E> next(Class<E> elementType) {
        return this.next(this.getTypeMapper.apply(elementType));
    }

    public <E> List<E> next(RowMapper<E> mapper) {
        RowMapperResultSetExtractor<E> extractor = new RowMapperResultSetExtractor<E>(mapper);
        ResultSet res = this.nextResultSet();
        List list = extractor.extract(new SqlResultSet(res));
        JdbcUtils.close((ResultSet)res);
        return (List)this.postHandler.apply(list);
    }

    private ResultSet nextResultSet() {
        try {
            if (this.index == 0) {
                ++this.index;
                return this.stat.getResultSet();
            }
            if (!this.forward) {
                this.hasNext();
            }
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.forward = false;
            ++this.index;
            return this.stat.getResultSet();
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasNext() {
        if (this.index == 0) {
            return true;
        }
        if (this.forward) {
            return this.hasNext;
        }
        try {
            this.hasNext = this.stat.getMoreResults();
            this.forward = true;
            return this.hasNext;
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }

    public void close() throws JdbcException {
        try {
            if (!this.stat.isClosed()) {
                this.stat.close();
            }
        }
        catch (SQLException e) {
            throw new JdbcException((Throwable)e);
        }
    }
}

