/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.bean.PropertyAccessorFactory;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.JdbcFactory;
import cn.featherfly.hammer.sqldb.jdbc.JdbcImpl;
import cn.featherfly.hammer.sqldb.jdbc.JdbcSession;
import java.sql.Connection;
import javax.sql.DataSource;

public class JdbcFactoryImpl
implements JdbcFactory {
    protected final Dialect dialect;
    protected final SqlTypeMappingManager sqlTypeMappingManager;
    protected final DatabaseMetadata metadata;
    protected final PropertyAccessorFactory propertyAccessorFactory;

    public JdbcFactoryImpl(Dialect dialect, DatabaseMetadata metadata, SqlTypeMappingManager sqlTypeMappingManager, PropertyAccessorFactory propertyAccessorFactory) {
        this.dialect = dialect;
        this.metadata = metadata;
        this.sqlTypeMappingManager = sqlTypeMappingManager;
        this.propertyAccessorFactory = propertyAccessorFactory;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public SqlTypeMappingManager getSqlTypeMappingManager() {
        return this.sqlTypeMappingManager;
    }

    @Override
    public Jdbc create(Connection connection) {
        return new JdbcImpl(connection, this.dialect, this.metadata, this.sqlTypeMappingManager, this.propertyAccessorFactory);
    }

    @Override
    public JdbcSession createSession(DataSource dataSource) {
        return this.createSession(JdbcUtils.getConnection((DataSource)dataSource));
    }

    @Override
    public JdbcSession createSession(Connection connection) {
        return new JdbcImpl(connection, this.dialect, this.metadata, this.sqlTypeMappingManager, this.propertyAccessorFactory);
    }
}

