/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.bean.PropertyAccessorFactory;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.repository.ExecutionExecutorEx;
import cn.featherfly.common.repository.RowIterable;
import cn.featherfly.common.repository.mapper.RowMapper;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.common.tuple.Tuple3;
import cn.featherfly.common.tuple.Tuple4;
import cn.featherfly.common.tuple.Tuple5;
import cn.featherfly.common.tuple.Tuple6;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.NestedBeanPropertyRowMapper;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class JdbcExecutor
implements ExecutionExecutorEx<String> {
    private final Jdbc jdbc;
    private final SqlPageFactory sqlPageFactory;
    private final PropertyAccessorFactory propertyAccessorFactory;

    public JdbcExecutor(Jdbc jdbc, PropertyAccessorFactory propertyAccessorFactory, SqlPageFactory sqlPageFactory) {
        this.jdbc = jdbc;
        this.propertyAccessorFactory = propertyAccessorFactory;
        this.sqlPageFactory = sqlPageFactory;
    }

    private <T> NestedBeanPropertyRowMapper<T> beanMapper(Class<T> element) {
        return new NestedBeanPropertyRowMapper(this.propertyAccessorFactory.create(element), this.jdbc.getSqlTypeMappingManager());
    }

    public int execute(String execution, Map<String, Serializable> params) {
        return this.jdbc.update(execution, params);
    }

    public boolean bool(String execution, Map<String, Serializable> params) {
        return this.jdbc.queryBool(execution, params);
    }

    public int intValue(String execution, Map<String, Serializable> params) {
        return this.jdbc.queryInt(execution, params);
    }

    public long longValue(String execution, Map<String, Serializable> params) {
        return this.jdbc.queryLong(execution, params);
    }

    public double doubleValue(String execution, Map<String, Serializable> params) {
        return this.jdbc.queryDouble(execution, params);
    }

    public <V> V value(String execution, Map<String, Serializable> params) {
        return (V)this.jdbc.queryValue(execution, params);
    }

    public <V> V value(String execution, Class<V> valueType, Map<String, Serializable> params) {
        return this.jdbc.queryValue(execution, valueType, params);
    }

    public Map<String, Serializable> single(String execution, Map<String, Serializable> params) {
        return this.jdbc.querySingle(execution, params);
    }

    public <T> T single(String execution, Class<T> mapType, Map<String, Serializable> params) {
        return this.jdbc.querySingle(execution, mapType, params);
    }

    public <T> T single(String execution, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        return this.jdbc.querySingle(execution, rowMapper, params);
    }

    public <T1, T2> Tuple2<T1, T2> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, prefixes, params);
    }

    public <T1, T2, T3> Tuple3<T1, T2, T3> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, mapType3, prefixes, params);
    }

    public <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, mapType3, mapType4, prefixes, params);
    }

    public <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, params);
    }

    public <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, params);
    }

    public Map<String, Serializable> unique(String execution, Map<String, Serializable> params) {
        return this.jdbc.queryUnique(execution, params);
    }

    public <T> T unique(String execution, Class<T> mapType, Map<String, Serializable> params) {
        return this.jdbc.queryUnique(execution, mapType, params);
    }

    public <T> T unique(String execution, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        return this.jdbc.queryUnique(execution, rowMapper, params);
    }

    public <T1, T2> Tuple2<T1, T2> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, prefixes, params);
    }

    public <T1, T2, T3> Tuple3<T1, T2, T3> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, mapType3, prefixes, params);
    }

    public <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, mapType3, mapType4, prefixes, params);
    }

    public <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, params);
    }

    public <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, params);
    }

    public List<Map<String, Serializable>> list(String execution, Map<String, Serializable> params) {
        return this.jdbc.queryList(execution, params);
    }

    public List<Map<String, Serializable>> list(String execution, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), pageQuery.getParams());
    }

    public <T> List<T> list(String execution, Class<T> mapType, Map<String, Serializable> params) {
        return this.jdbc.queryList(execution, mapType, params);
    }

    public <T> List<T> list(String execution, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        return this.jdbc.queryList(execution, rowMapper, params);
    }

    public <T> List<T> list(String execution, Class<T> mapType, Map<String, Serializable> params, int offset, int limit) {
        return this.list(execution, this.beanMapper(mapType), params, offset, limit);
    }

    public <T> List<T> list(String execution, RowMapper<T> rowMapper, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), rowMapper, pageQuery.getParams());
    }

    public <T1, T2> List<Tuple2<T1, T2>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, prefixes, params);
    }

    public <T1, T2> List<Tuple2<T1, T2>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, mapType3, prefixes, params);
    }

    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4> List<Tuple4<T1, T2, T3, T4>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, mapType3, mapType4, prefixes, params);
    }

    public <T1, T2, T3, T4> List<Tuple4<T1, T2, T3, T4>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4, T5> List<Tuple5<T1, T2, T3, T4, T5>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, params);
    }

    public <T1, T2, T3, T4, T5> List<Tuple5<T1, T2, T3, T4, T5>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4, T5, T6> List<Tuple6<T1, T2, T3, T4, T5, T6>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, params);
    }

    public <T1, T2, T3, T4, T5, T6> List<Tuple6<T1, T2, T3, T4, T5, T6>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, pageQuery.getParams());
    }

    public PaginationResults<Map<String, Serializable>> pagination(String execution, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Map<String, Serializable>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T> PaginationResults<T> pagination(String execution, Class<T> mapType, Map<String, Serializable> params, int offset, int limit) {
        return this.pagination(execution, this.beanMapper(mapType), params, offset, limit);
    }

    public <T> PaginationResults<T> pagination(String execution, RowMapper<T> rowMapper, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<T> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), rowMapper, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2> PaginationResults<Tuple2<T1, T2>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple2<T1, T2>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2, T3> PaginationResults<Tuple3<T1, T2, T3>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple3<T1, T2, T3>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2, T3, T4> PaginationResults<Tuple4<T1, T2, T3, T4>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple4<T1, T2, T3, T4>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2, T3, T4, T5> PaginationResults<Tuple5<T1, T2, T3, T4, T5>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple5<T1, T2, T3, T4, T5>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2, T3, T4, T5, T6> PaginationResults<Tuple6<T1, T2, T3, T4, T5, T6>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple6<T1, T2, T3, T4, T5, T6>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public int execute(String execution, Serializable ... params) {
        return this.jdbc.update(execution, params);
    }

    public boolean bool(String execution, Serializable ... params) {
        return this.jdbc.queryBool(execution, params);
    }

    public int intValue(String execution, Serializable ... params) {
        return this.jdbc.queryInt(execution, params);
    }

    public long longValue(String execution, Serializable ... params) {
        return this.jdbc.queryLong(execution, params);
    }

    public double doubleValue(String execution, Serializable ... params) {
        return this.jdbc.queryLong(execution, params);
    }

    public <V> V value(String execution, Serializable ... params) {
        return (V)this.jdbc.queryValue(execution, params);
    }

    public <V> V value(String execution, Class<V> valueType, Serializable ... params) {
        return this.jdbc.queryValue(execution, valueType, params);
    }

    public Map<String, Serializable> single(String execution, Serializable ... params) {
        return this.jdbc.querySingle(execution, params);
    }

    public <T> T single(String execution, Class<T> mapType, Serializable ... params) {
        return this.jdbc.querySingle(execution, mapType, params);
    }

    public <T> T single(String execution, RowMapper<T> rowMapper, Serializable ... params) {
        return this.jdbc.querySingle(execution, rowMapper, params);
    }

    public <T1, T2> Tuple2<T1, T2> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable ... params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, prefixes, params);
    }

    public <T1, T2, T3> Tuple3<T1, T2, T3> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, mapType3, prefixes, params);
    }

    public <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, mapType3, mapType4, prefixes, params);
    }

    public <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, params);
    }

    public <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> single(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.querySingle(execution, mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, params);
    }

    public Map<String, Serializable> unique(String execution, Serializable ... params) {
        return this.jdbc.queryUnique(execution, params);
    }

    public <T> T unique(String execution, Class<T> mapType, Serializable ... params) {
        return this.jdbc.queryUnique(execution, mapType, params);
    }

    public <T> T unique(String execution, RowMapper<T> rowMapper, Serializable ... params) {
        return this.jdbc.queryUnique(execution, rowMapper, params);
    }

    public <T1, T2> Tuple2<T1, T2> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, prefixes, params);
    }

    public <T1, T2, T3> Tuple3<T1, T2, T3> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, mapType3, prefixes, params);
    }

    public <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, mapType3, mapType4, prefixes, params);
    }

    public <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, params);
    }

    public <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> unique(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryUnique(execution, mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, params);
    }

    public List<Map<String, Serializable>> list(String execution, Serializable ... params) {
        return this.jdbc.queryList(execution, params);
    }

    public List<Map<String, Serializable>> list(String execution, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), pageQuery.getParams());
    }

    public <T> List<T> list(String execution, Class<T> mapType, Serializable ... params) {
        return this.jdbc.queryList(execution, mapType, params);
    }

    public <T> List<T> list(String execution, RowMapper<T> rowMapper, Serializable ... params) {
        return this.jdbc.queryList(execution, rowMapper, params);
    }

    public <T> List<T> list(String execution, Class<T> mapType, Serializable[] params, int offset, int limit) {
        return this.list(execution, this.beanMapper(mapType), params, offset, limit);
    }

    public <T> List<T> list(String execution, RowMapper<T> rowMapper, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), rowMapper, pageQuery.getParams());
    }

    public <T1, T2> List<Tuple2<T1, T2>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, prefixes, params);
    }

    public <T1, T2> List<Tuple2<T1, T2>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, mapType3, prefixes, params);
    }

    public <T1, T2, T3> List<Tuple3<T1, T2, T3>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4> List<Tuple4<T1, T2, T3, T4>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, mapType3, mapType4, prefixes, params);
    }

    public <T1, T2, T3, T4> List<Tuple4<T1, T2, T3, T4>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4, T5> List<Tuple5<T1, T2, T3, T4, T5>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, params);
    }

    public <T1, T2, T3, T4, T5> List<Tuple5<T1, T2, T3, T4, T5>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4, T5, T6> List<Tuple6<T1, T2, T3, T4, T5, T6>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryList(execution, mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, params);
    }

    public <T1, T2, T3, T4, T5, T6> List<Tuple6<T1, T2, T3, T4, T5, T6>> list(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, pageQuery.getParams());
    }

    public RowIterable<Map<String, Serializable>> each(String execution, Map<String, Serializable> params) {
        return this.jdbc.queryEach(execution, params);
    }

    public <T> RowIterable<T> each(String execution, Class<T> mappingType, Map<String, Serializable> params) {
        return this.jdbc.queryEach(execution, mappingType, params);
    }

    public <T> RowIterable<T> each(String execution, RowMapper<T> rowMapper, Map<String, Serializable> params) {
        return this.jdbc.queryEach(execution, rowMapper, params);
    }

    public RowIterable<Map<String, Serializable>> each(String execution, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), pageQuery.getParams());
    }

    public <T> RowIterable<T> each(String execution, Class<T> mappingType, Map<String, Serializable> params, int offset, int limit) {
        return this.each(execution, this.beanMapper(mappingType), params, offset, limit);
    }

    public <T> RowIterable<T> each(String execution, RowMapper<T> rowMapper, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), rowMapper, pageQuery.getParams());
    }

    public <T1, T2> RowIterable<Tuple2<T1, T2>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Tuple2<String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, params);
    }

    public <T1, T2> RowIterable<Tuple2<T1, T2>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Tuple2<String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3> RowIterable<Tuple3<T1, T2, T3>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, mappingType3, prefixes, params);
    }

    public <T1, T2, T3> RowIterable<Tuple3<T1, T2, T3>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Tuple3<String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, mappingType3, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4> RowIterable<Tuple4<T1, T2, T3, T4>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, mappingType3, mappingType4, prefixes, params);
    }

    public <T1, T2, T3, T4> RowIterable<Tuple4<T1, T2, T3, T4>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Tuple4<String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, mappingType3, mappingType4, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4, T5> RowIterable<Tuple5<T1, T2, T3, T4, T5>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, mappingType3, mappingType4, mappingType5, prefixes, params);
    }

    public <T1, T2, T3, T4, T5> RowIterable<Tuple5<T1, T2, T3, T4, T5>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, mappingType3, mappingType4, mappingType5, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4, T5, T6> RowIterable<Tuple6<T1, T2, T3, T4, T5, T6>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Class<T6> mappingType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, mappingType3, mappingType4, mappingType5, mappingType6, prefixes, params);
    }

    public <T1, T2, T3, T4, T5, T6> RowIterable<Tuple6<T1, T2, T3, T4, T5, T6>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Class<T6> mappingType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Serializable> params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Map<String, Serializable>> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, mappingType3, mappingType4, mappingType5, mappingType6, prefixes, pageQuery.getParams());
    }

    public RowIterable<Map<String, Serializable>> each(String execution, Serializable ... params) {
        return this.jdbc.queryEach(execution, params);
    }

    public <T> RowIterable<T> each(String execution, Class<T> mappingType, Serializable ... params) {
        return this.jdbc.queryEach(execution, mappingType, params);
    }

    public <T> RowIterable<T> each(String execution, RowMapper<T> rowMapper, Serializable ... params) {
        return this.jdbc.queryEach(execution, rowMapper, params);
    }

    public RowIterable<Map<String, Serializable>> each(String execution, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), pageQuery.getParams());
    }

    public <T> RowIterable<T> each(String execution, Class<T> mappingType, Serializable[] params, int offset, int limit) {
        return this.each(execution, this.beanMapper(mappingType), params, offset, limit);
    }

    public <T> RowIterable<T> each(String execution, RowMapper<T> rowMapper, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), rowMapper, pageQuery.getParams());
    }

    public <T1, T2> RowIterable<Tuple2<T1, T2>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Tuple2<String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, prefixes, params);
    }

    public <T1, T2> RowIterable<Tuple2<T1, T2>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Tuple2<String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3> RowIterable<Tuple3<T1, T2, T3>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Tuple3<String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, mappingType3, prefixes, params);
    }

    public <T1, T2, T3> RowIterable<Tuple3<T1, T2, T3>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Tuple3<String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, mappingType3, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4> RowIterable<Tuple4<T1, T2, T3, T4>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Tuple4<String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, mappingType3, mappingType4, prefixes, params);
    }

    public <T1, T2, T3, T4> RowIterable<Tuple4<T1, T2, T3, T4>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Tuple4<String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, mappingType3, mappingType4, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4, T5> RowIterable<Tuple5<T1, T2, T3, T4, T5>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Tuple5<String, String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, mappingType3, mappingType4, mappingType5, prefixes, params);
    }

    public <T1, T2, T3, T4, T5> RowIterable<Tuple5<T1, T2, T3, T4, T5>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Tuple5<String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, mappingType3, mappingType4, mappingType5, prefixes, pageQuery.getParams());
    }

    public <T1, T2, T3, T4, T5, T6> RowIterable<Tuple6<T1, T2, T3, T4, T5, T6>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Class<T6> mappingType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable ... params) {
        return this.jdbc.queryEach(execution, mappingType1, mappingType2, mappingType3, mappingType4, mappingType5, mappingType6, prefixes, params);
    }

    public <T1, T2, T3, T4, T5, T6> RowIterable<Tuple6<T1, T2, T3, T4, T5, T6>> each(String execution, Class<T1> mappingType1, Class<T2> mappingType2, Class<T3> mappingType3, Class<T4> mappingType4, Class<T5> mappingType5, Class<T6> mappingType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageQuery(execution, params, offset, limit);
        return this.jdbc.queryEach(pageQuery.getSql(), mappingType1, mappingType2, mappingType3, mappingType4, mappingType5, mappingType6, prefixes, pageQuery.getParams());
    }

    public PaginationResults<Map<String, Serializable>> pagination(String execution, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Map<String, Serializable>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T> PaginationResults<T> pagination(String execution, Class<T> mapType, Serializable[] params, int offset, int limit) {
        return this.pagination(execution, this.beanMapper(mapType), params, offset, limit);
    }

    public <T> PaginationResults<T> pagination(String execution, RowMapper<T> rowMapper, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<T> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), rowMapper, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2> PaginationResults<Tuple2<T1, T2>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Tuple2<String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple2<T1, T2>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2, T3> PaginationResults<Tuple3<T1, T2, T3>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Tuple3<String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple3<T1, T2, T3>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2, T3, T4> PaginationResults<Tuple4<T1, T2, T3, T4>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Tuple4<String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple4<T1, T2, T3, T4>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2, T3, T4, T5> PaginationResults<Tuple5<T1, T2, T3, T4, T5>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Tuple5<String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple5<T1, T2, T3, T4, T5>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, mapType5, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    public <T1, T2, T3, T4, T5, T6> PaginationResults<Tuple6<T1, T2, T3, T4, T5, T6>> pagination(String execution, Class<T1> mapType1, Class<T2> mapType2, Class<T3> mapType3, Class<T4> mapType4, Class<T5> mapType5, Class<T6> mapType6, Tuple6<String, String, String, String, String, String> prefixes, Serializable[] params, int offset, int limit) {
        SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), execution, offset, limit, params);
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        List<Tuple6<T1, T2, T3, T4, T5, T6>> list = null;
        list = this.jdbc.queryList(pageQuery.getSql(), mapType1, mapType2, mapType3, mapType4, mapType5, mapType6, prefixes, pageQuery.getParams());
        pagination.setPageResults(list);
        String countSql = SqlUtils.convertSelectToCount((String)execution);
        int total = this.jdbc.queryInt(countSql, params);
        pagination.setTotal((long)total);
        return pagination;
    }

    private SqlPageFactory.SqlPageQuery<Map<String, Serializable>> sqlPageQuery(String sql, Map<String, Serializable> params, int offset, int limit) {
        return this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, params);
    }

    private SqlPageFactory.SqlPageQuery<Serializable[]> sqlPageQuery(String sql, Serializable[] params, int offset, int limit) {
        return this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, params);
    }

    public Jdbc getJdbc() {
        return this.jdbc;
    }

    public SqlPageFactory getSqlPageFactory() {
        return this.sqlPageFactory;
    }
}

