/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc;

import cn.featherfly.common.bean.PropertyAccessorFactory;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import cn.featherfly.hammer.sqldb.jdbc.JdbcProcedure;
import cn.featherfly.hammer.sqldb.jdbc.JdbcQuery;
import cn.featherfly.hammer.sqldb.jdbc.JdbcQueryProcessSingle;
import cn.featherfly.hammer.sqldb.jdbc.JdbcUpdate;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public interface Jdbc
extends JdbcQuery,
JdbcProcedure,
JdbcUpdate,
JdbcQueryProcessSingle {
    public Dialect getDialect();

    public SqlTypeMappingManager getSqlTypeMappingManager();

    public PropertyAccessorFactory getPropertyAccessorFactory();

    default public int insert(String tableName, String[] columnNames, Serializable ... args) {
        return this.insert(tableName, columnNames, (GeneratedKeyHolder<T>)null, args);
    }

    public <T extends Serializable> int insert(String var1, String[] var2, GeneratedKeyHolder<T> var3, Serializable ... var4);

    default public int insert(String tableName, Map<String, Serializable> columnParams) {
        return this.insert(tableName, columnParams, null);
    }

    default public <T extends Serializable> int insert(String tableName, Map<String, Serializable> columnParams, GeneratedKeyHolder<T> keyHolder) {
        int i = 0;
        String[] columns = new String[columnParams.size()];
        Serializable[] params = new Serializable[columnParams.size()];
        for (Map.Entry<String, Serializable> entry : columnParams.entrySet()) {
            columns[i] = entry.getKey();
            params[i] = entry.getValue();
            ++i;
        }
        return this.insert(tableName, columns, keyHolder, params);
    }

    default public int insertBatch(String tableName, String[] columnNames, Serializable ... args) {
        if (args.length % columnNames.length != 0) {
            throw new JdbcException("batch size is not explicit (args.length % columnNames.length != 0)");
        }
        return this.insertBatch(tableName, columnNames, args.length / columnNames.length, args);
    }

    default public int insertBatch(String tableName, List<Map<String, Serializable>> columnParams) {
        if (Lang.isEmpty(columnParams)) {
            return 0;
        }
        int columnLen = columnParams.get(0).size();
        int paramLen = columnLen * columnParams.size();
        String[] columns = new String[columnLen];
        Serializable[] params = new Serializable[paramLen];
        Lang.each(columnParams.get(0).entrySet(), (entry, index) -> {
            columns[index] = (String)entry.getKey();
        });
        int i = 0;
        for (Map<String, Serializable> cp : columnParams) {
            for (Map.Entry<String, Serializable> entry2 : cp.entrySet()) {
                params[i] = entry2.getValue();
                ++i;
            }
        }
        return this.insertBatch(tableName, columns, columnParams.size(), params);
    }

    public int insertBatch(String var1, String[] var2, int var3, Serializable ... var4);

    default public int upsert(String tableName, String[] columnNames, String uniqueColumn, Serializable ... args) {
        return this.upsert(tableName, columnNames, new String[]{uniqueColumn}, args);
    }

    public int upsert(String var1, String[] var2, String[] var3, Serializable ... var4);

    default public int upsert(String tableName, String uniqueColumn, Map<String, Serializable> params) {
        return this.upsert(tableName, new String[]{uniqueColumn}, params);
    }

    default public int upsert(String tableName, String[] uniqueColumns, Map<String, Serializable> params) {
        Serializable[] ps = new Serializable[params.size()];
        String[] columnNames = new String[params.size()];
        int i = 0;
        for (Map.Entry<String, Serializable> e : params.entrySet()) {
            columnNames[i] = e.getKey();
            ps[i] = e.getValue();
            ++i;
        }
        return this.upsert(tableName, columnNames, uniqueColumns, ps);
    }
}

