/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.repository.query;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.hammer.HammerException;
import cn.featherfly.hammer.expression.condition.ConditionExpression;
import cn.featherfly.hammer.expression.query.QueryConditionLimit;
import cn.featherfly.hammer.expression.query.QueryCountExecutor;
import cn.featherfly.hammer.expression.query.WhereExpression;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlRelation;
import cn.featherfly.hammer.sqldb.dsl.repository.query.RepositorySqlQueryValueExpression;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;

public abstract class AbstractRepositorySqlQueryBase<C extends ConditionExpression, Q>
implements QueryCountExecutor,
QueryConditionLimit<Q>,
WhereExpression<C> {
    protected final RepositorySqlQueryRelation queryRelation;
    protected final int index;
    protected final SqlPageFactory sqlPageFactory;
    protected String idName;
    protected Limit limit;

    protected AbstractRepositorySqlQueryBase(int index, RepositorySqlQueryRelation queryRelation, SqlPageFactory sqlPageFactory) {
        this.index = index;
        this.queryRelation = queryRelation;
        this.sqlPageFactory = sqlPageFactory;
        this.setIdName();
    }

    public void setIdName() {
        Table tableMetadata;
        RepositorySqlRelation.RepositoryRelation relation = this.queryRelation.getRepositoryRelation(this.index);
        if (relation != null && (tableMetadata = this.queryRelation.getMetadata().getTable(relation.getRepository())).getPrimaryColumns().size() == 1) {
            this.idName = ((Column)tableMetadata.getPrimaryColumns().get(0)).getName();
        }
    }

    protected AbstractRepositorySqlQueryBase(AbstractRepositorySqlQueryBase<?, ?> repositorySqlQueryFetch) {
        this.queryRelation = repositorySqlQueryFetch.queryRelation;
        this.index = repositorySqlQueryFetch.index;
        this.sqlPageFactory = repositorySqlQueryFetch.sqlPageFactory;
        this.idName = repositorySqlQueryFetch.idName;
        this.limit = repositorySqlQueryFetch.limit;
    }

    protected String getIdName() {
        if (Lang.isEmpty((String)this.idName)) {
            throw new HammerException("primary key column name is null");
        }
        return this.idName;
    }

    public long count() {
        return new RepositorySqlQueryValueExpression(this.queryRelation, this.sqlPageFactory).count();
    }

    public Q limit(Limit limit) {
        this.limit = limit;
        return (Q)this;
    }
}

