/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.repository.query;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.builder.dml.SqlSortBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectBasicBuilder;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.operator.AggregateFunction;
import cn.featherfly.common.repository.builder.dml.SortBuilder;
import cn.featherfly.common.repository.mapper.RowMapper;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.common.tuple.Tuple1;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.common.tuple.Tuples;
import cn.featherfly.hammer.config.dsl.QueryConditionConfig;
import cn.featherfly.hammer.dsl.repository.query.RepositoryQueryValueConditionsGroup;
import cn.featherfly.hammer.dsl.repository.query.RepositoryQueryValueConditionsGroupLogic;
import cn.featherfly.hammer.expression.query.QueryValueLimitExecutor;
import cn.featherfly.hammer.expression.repository.query.RepositoryQueryValueSortExpression;
import cn.featherfly.hammer.expression.repository.query.RepositoryQueryValueSortedExpression;
import cn.featherfly.hammer.sqldb.dsl.repository.AbstractMulitiRepositorySqlConditionsGroupExpressionBase;
import cn.featherfly.hammer.sqldb.dsl.repository.RepositorySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.repository.query.AbstractMulitiRepositorySqlQueryConditionsGroupExpression;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractMulitiRepositorySqlQueryValueConditionsGroupExpression
extends AbstractMulitiRepositorySqlConditionsGroupExpressionBase<RepositoryQueryValueConditionsGroup, RepositoryQueryValueConditionsGroupLogic, Tuple1<Integer>, QueryConditionConfig, RepositorySqlQueryRelation, SqlSelectBasicBuilder>
implements RepositoryQueryValueConditionsGroup,
RepositoryQueryValueConditionsGroupLogic,
RepositoryQueryValueSortExpression,
RepositoryQueryValueSortedExpression {
    private SqlSortBuilder sortBuilder;
    private Limit limit;
    protected SqlPageFactory sqlPageFactory;
    protected final Jdbc jdbc;

    protected AbstractMulitiRepositorySqlQueryValueConditionsGroupExpression(int index, RepositorySqlQueryRelation queryRelation, SqlPageFactory sqlPageFactory) {
        this(null, index, queryRelation, sqlPageFactory);
    }

    protected AbstractMulitiRepositorySqlQueryValueConditionsGroupExpression(RepositoryQueryValueConditionsGroupLogic parent, int index, RepositorySqlQueryRelation queryRelation, SqlPageFactory sqlPageFactory) {
        super(parent, index, queryRelation);
        this.jdbc = queryRelation.getJdbc();
        this.sqlPageFactory = sqlPageFactory;
        if (parent == null) {
            this.sortBuilder = new SqlSortBuilder(this.dialect, this.repositoryAlias);
        }
    }

    public QueryValueLimitExecutor limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public long count() {
        ((RepositorySqlQueryRelation)this.repositoryRelation).getBuilder().clearColumns().addColumn(AggregateFunction.COUNT, "*");
        return ((RepositorySqlQueryRelation)this.repositoryRelation).getJdbc().queryLong(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public <E> List<E> list() {
        return this.list(Object.class);
    }

    public <E> List<E> list(Class<E> type) {
        String sql = this.getRoot().expression();
        Serializable[] params = this.getRoot().getParamsArray();
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, this.limit.getOffset(), this.limit.getLimit(), params);
            sql = pageQuery.getSql();
            params = pageQuery.getParams();
        }
        return this.jdbc.queryList(sql, type, params);
    }

    public PaginationResults<Map<String, Serializable>> pagination() {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Serializable[] params = this.getRoot().getParamsArray();
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, this.limit.getOffset(), this.limit.getLimit(), params);
            List<Map<String, Serializable>> list = this.jdbc.queryList(pageQuery.getSql(), pageQuery.getParams());
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal((long)total);
        } else {
            List<Map<String, Serializable>> list = this.jdbc.queryList(sql, params);
            pagination.setPageResults(list);
            pagination.setTotal((long)list.size());
        }
        return pagination;
    }

    public <E> PaginationResults<E> pagination(Class<E> type) {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Serializable[] params = (Serializable[])Lang.toArray(this.getRoot().getParams(), Serializable.class);
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, this.limit.getOffset(), this.limit.getLimit(), params);
            List<E> list = this.jdbc.queryList(pageQuery.getSql(), type, pageQuery.getParams());
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal((long)total);
        } else {
            List<E> list = this.jdbc.queryList(sql, type, params);
            pagination.setPageResults(list);
            pagination.setTotal((long)list.size());
        }
        return pagination;
    }

    public <E> PaginationResults<E> pagination(RowMapper<E> rowMapper) {
        String sql = this.getRoot().expression();
        String countSql = SqlUtils.convertSelectToCount((String)sql);
        Serializable[] params = (Serializable[])Lang.toArray(this.getRoot().getParams(), Serializable.class);
        SimplePaginationResults pagination = new SimplePaginationResults(this.limit);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.dialect, sql, this.limit.getOffset(), this.limit.getLimit(), params);
            List<E> list = this.jdbc.queryList(pageQuery.getSql(), rowMapper, pageQuery.getParams());
            pagination.setPageResults(list);
            int total = this.jdbc.queryInt(countSql, params);
            pagination.setTotal((long)total);
        } else {
            List<E> list = this.jdbc.queryList(sql, rowMapper, params);
            pagination.setPageResults(list);
            pagination.setTotal((long)list.size());
        }
        return pagination;
    }

    public String string() {
        return this.jdbc.queryString(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public Date date() {
        return this.jdbc.queryValue(this.getRoot().expression(), Date.class, this.getRoot().getParamsArray());
    }

    public LocalDate localDate() {
        return this.jdbc.queryValue(this.getRoot().expression(), LocalDate.class, this.getRoot().getParamsArray());
    }

    public LocalDateTime localDateTime() {
        return this.jdbc.queryValue(this.getRoot().expression(), LocalDateTime.class, this.getRoot().getParamsArray());
    }

    public LocalTime localTime() {
        return this.jdbc.queryValue(this.getRoot().expression(), LocalTime.class, this.getRoot().getParamsArray());
    }

    public Timestamp timestamp() {
        return this.jdbc.queryValue(this.getRoot().expression(), Timestamp.class, this.getRoot().getParamsArray());
    }

    public byte[] bytes() {
        return this.jdbc.queryBytes(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public Clob clob() {
        return this.jdbc.queryValue(this.getRoot().expression(), Clob.class, this.getRoot().getParamsArray());
    }

    public Blob blob() {
        return this.jdbc.queryValue(this.getRoot().expression(), Blob.class, this.getRoot().getParamsArray());
    }

    public boolean bool() {
        return this.jdbc.queryBool(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public byte byteValue() {
        return this.jdbc.queryByte(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public short shortValue() {
        return this.jdbc.queryShort(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public int intValue() {
        return this.jdbc.queryInt(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public long longValue() {
        return this.jdbc.queryLong(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public double doubleValue() {
        return this.jdbc.queryDouble(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public <T> T value(Class<T> type) {
        return this.jdbc.queryValue(this.getRoot().expression(), type, this.getRoot().getParamsArray());
    }

    public <T> T value() {
        return this.jdbc.queryValue(this.getRoot().expression(), this.getRoot().getParamsArray());
    }

    public <T> T single(Class<T> type) {
        return this.jdbc.querySingle(this.getRoot().expression(), type, this.getRoot().getParamsArray());
    }

    public <T> T single() {
        return (T)this.single(Object.class);
    }

    public <T> T unique(Class<T> type) {
        return this.jdbc.queryUnique(this.getRoot().expression(), type, this.getRoot().getParamsArray());
    }

    public <T> T unique() {
        return (T)this.unique(Object.class);
    }

    public RepositoryQueryValueSortExpression sort() {
        return this;
    }

    public RepositoryQueryValueSortedExpression asc(String ... names) {
        this.getRootSortBuilder().asc(names);
        return this;
    }

    public RepositoryQueryValueSortedExpression desc(String ... names) {
        this.getRootSortBuilder().desc(names);
        return this;
    }

    @Override
    protected Tuple1<Integer> createTuple() {
        return Tuples.of((Object)0);
    }

    protected SortBuilder getRootSortBuilder() {
        return ((AbstractMulitiRepositorySqlQueryValueConditionsGroupExpression)this.getRoot()).sortBuilder;
    }

    @Override
    public String expression() {
        return AbstractMulitiRepositorySqlQueryConditionsGroupExpression.expression(super.expression(), this.parent, (RepositorySqlQueryRelation)this.repositoryRelation, this.getRootSortBuilder(), this.dialect);
    }

    public Tuple2<String, String> expressionPage() {
        return AbstractMulitiRepositorySqlQueryConditionsGroupExpression.expressionPage(super.expression(), this.parent, (RepositorySqlQueryRelation)this.repositoryRelation, this.getRootSortBuilder(), this.dialect);
    }
}

