/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.repository.condition.field;

import cn.featherfly.common.db.builder.model.ArithmeticColumnElement;
import cn.featherfly.common.db.builder.model.ColumnElement;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.operator.Function;
import cn.featherfly.common.repository.Field;
import cn.featherfly.hammer.expression.condition.ConditionExpression;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.LogicExpression;
import cn.featherfly.hammer.expression.condition.field.FieldExpression;
import cn.featherfly.hammer.sqldb.dsl.condition.InternalMulitiCondition;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractMulitiRepositoryFieldExpression<C extends ConditionExpression, L extends LogicExpression<C, L>>
implements Expression {
    protected AtomicInteger index;
    protected String name;
    protected InternalMulitiCondition<L> expression;
    protected final ArithmeticColumnElement column;
    protected final Function function;
    protected final Object[] argus;

    protected AbstractMulitiRepositoryFieldExpression(int index, String name, InternalMulitiCondition<L> expression) {
        this(index, name, null, expression);
    }

    protected AbstractMulitiRepositoryFieldExpression(int index, String name, Function function, InternalMulitiCondition<L> expression) {
        this(index, name, function, ArrayUtils.EMPTY_OBJECT_ARRAY, expression);
    }

    protected AbstractMulitiRepositoryFieldExpression(int index, String name, Function function, Object[] argus, InternalMulitiCondition<L> expression) {
        this(new AtomicInteger(index), name, function, argus, expression);
    }

    protected AbstractMulitiRepositoryFieldExpression(AtomicInteger index, String name, InternalMulitiCondition<L> expression) {
        this(index, name, null, expression);
    }

    protected AbstractMulitiRepositoryFieldExpression(AtomicInteger index, String name, Function function, InternalMulitiCondition<L> expression) {
        this(index, name, function, ArrayUtils.EMPTY_OBJECT_ARRAY, expression);
    }

    protected AbstractMulitiRepositoryFieldExpression(AtomicInteger index, String name, Function function, Object[] argus, InternalMulitiCondition<L> expression) {
        this.index = index;
        this.name = name;
        this.expression = expression;
        this.function = function;
        this.argus = argus;
        this.column = new ArithmeticColumnElement(expression.getJdbc().getDialect(), expression.getAlias(index.get()), name);
    }

    protected Object getField() {
        if (this.function != null) {
            return new ColumnElement(this.expression.getJdbc().getDialect(), this.column.getTableAlias(), this.name, this.function, this.argus);
        }
        if (this.column.getCalculationOperator().length > 0) {
            return this.column;
        }
        return this.name;
    }

    public String name() {
        return this.getField().toString();
    }

    public String expression() {
        return new ColumnElement(this.expression.getJdbc().getDialect(), this.expression.getAlias(this.index.intValue()), this.name).toSql();
    }

    public L eq(Field field) {
        return (L)((LogicExpression)this.expression.eq(this.index, this.name, field, this.expression.getIgnoreStrategy()));
    }

    public L eq(FieldExpression fieldExpression) {
        return (L)((LogicExpression)this.expression.eq(this.index, this.name, fieldExpression, this.expression.getIgnoreStrategy()));
    }
}

