/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.repository;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlJoinOnBasicBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlJoinOnBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectJoinOnBasicBuilder;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Str;
import cn.featherfly.common.repository.AliasRepository;
import cn.featherfly.common.repository.Repository;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.tuple.MutableTuples;
import cn.featherfly.common.tuple.mutable.MutableTuple9;
import cn.featherfly.hammer.config.dsl.ConditionConfig;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.query.SqlRelation;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class RepositorySqlRelation<R extends RepositorySqlRelation<R, B>, B extends SqlBuilder>
implements SqlRelation<B> {
    protected Jdbc jdbc;
    protected AliasManager aliasManager;
    protected DatabaseMetadata metadata;
    protected ConditionConfig<?> conditionConfig;
    protected int index;
    protected MutableTuple9<RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation> repositoryFilterableTuple = MutableTuples.create9();

    protected RepositorySqlRelation(Jdbc jdbc, AliasManager aliasManager, DatabaseMetadata metadata, ConditionConfig<?> conditionConfig) {
        AssertIllegalArgument.isNotNull((Object)jdbc, (String)"jdbc");
        AssertIllegalArgument.isNotNull((Object)aliasManager, (String)"aliasManager");
        AssertIllegalArgument.isNotNull((Object)metadata, (String)"metadata");
        AssertIllegalArgument.isNotNull(conditionConfig, (String)"conditionConfig");
        this.jdbc = jdbc;
        this.aliasManager = aliasManager;
        this.metadata = metadata;
        this.conditionConfig = conditionConfig;
    }

    public R addFilterable(Repository repository) {
        return this.addFilterable(repository.name());
    }

    public R addFilterable(AliasRepository repository) {
        return this.addFilterable(repository.name(), repository.alias());
    }

    public R addFilterable(String repository) {
        return this.addFilterable(0, null, repository, null);
    }

    public R addFilterable(String repository, String alias) {
        return this.addFilterable(0, null, repository, alias, null);
    }

    public R addFilterable(int sourceIndex, String sourceField, String joinRepository, String joinField) {
        return this.addFilterable(sourceIndex, sourceField, joinRepository, null, joinField);
    }

    public R addFilterable(int sourceIndex, String sourceField, String joinRepository, String joinRepositoryAlias, String joinField) {
        this.checkIndex(this.index);
        switch (this.index) {
            case 0: {
                RepositoryRelation eqm = this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField);
                this.repositoryFilterableTuple.set0((Object)eqm);
                this.initBuilder(eqm);
                break;
            }
            case 1: {
                this.repositoryFilterableTuple.set1((Object)this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField));
                break;
            }
            case 2: {
                this.repositoryFilterableTuple.set2((Object)this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField));
                break;
            }
            case 3: {
                this.repositoryFilterableTuple.set3((Object)this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField));
                break;
            }
            case 4: {
                this.repositoryFilterableTuple.set4((Object)this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField));
                break;
            }
            case 5: {
                this.repositoryFilterableTuple.set5((Object)this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField));
                break;
            }
            case 6: {
                this.repositoryFilterableTuple.set6((Object)this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField));
                break;
            }
            case 7: {
                this.repositoryFilterableTuple.set7((Object)this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField));
                break;
            }
            case 8: {
                this.repositoryFilterableTuple.set8((Object)this.createRelationMapping(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField));
                break;
            }
        }
        ++this.index;
        return (R)this;
    }

    public R join(int sourceIndex, String sourceField, String joinRepository) {
        List pkList = this.metadata.getTable(joinRepository).getPrimaryColumns();
        if (pkList.size() == 1) {
            return this.join(sourceIndex, sourceField, joinRepository, ((Column)pkList.get(0)).getName());
        }
        throw new SqldbHammerException(Str.format((String)"only support one primary key, but more than one primary key found {0}", (Object)pkList.size()));
    }

    public R join(int sourceIndex, String sourceField, String joinRepository, String joinField) {
        return this.join(sourceIndex, sourceField, joinRepository, null, joinField);
    }

    public R join(int sourceIndex, String sourceField, String joinRepository, String joinRepositoryAlias, String joinField) {
        AssertIllegalArgument.isNotNull((Object)joinRepository, (String)"joinRepository");
        if (Lang.isEmpty((String)joinField)) {
            List pks = this.metadata.getTable(joinRepository).getPrimaryColumns();
            if (pks.size() == 1) {
                joinField = ((Column)pks.get(0)).getName();
            } else {
                AssertIllegalArgument.isNotNull((Object)joinField, (String)"joinField");
            }
        }
        RepositoryRelation erm = this.getRepositoryRelation(sourceIndex);
        if (Lang.isEmpty((String)sourceField)) {
            List pks = this.metadata.getTable(erm.getRepository()).getPrimaryColumns();
            if (pks.size() == 1) {
                sourceField = ((Column)pks.get(0)).getName();
            } else {
                AssertIllegalArgument.isNotNull((Object)sourceField, (String)"sourceField");
            }
        }
        this.addFilterable(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField);
        RepositoryRelation jerm = this.getRepositoryRelation(this.index - 1);
        return this.join((SqlJoinOnBuilder)new SqlJoinOnBasicBuilder(this.jdbc.getDialect(), jerm.getRepository(), jerm.getRepositoryAlias(), joinField, erm.getRepositoryAlias(), sourceField));
    }

    public abstract R join(String var1, Supplier<Expression> var2);

    protected abstract R join(SqlJoinOnBuilder var1);

    protected abstract void initBuilder(RepositoryRelation var1);

    @Override
    public Jdbc getJdbc() {
        return this.jdbc;
    }

    @Override
    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public DatabaseMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Predicate<Object> getIgnoreStrategy() {
        return this.conditionConfig.getIgnoreStrategy();
    }

    public MutableTuple9<RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation, RepositoryRelation> getRepositoryRelationTuple() {
        return this.repositoryFilterableTuple;
    }

    public RepositoryRelation getRepositoryRelation(int index) {
        switch (index) {
            case 0: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull0();
            }
            case 1: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull1();
            }
            case 2: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull2();
            }
            case 3: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull3();
            }
            case 4: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull4();
            }
            case 5: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull5();
            }
            case 6: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull6();
            }
            case 7: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull7();
            }
            case 8: {
                return (RepositoryRelation)this.repositoryFilterableTuple.getOrNull8();
            }
        }
        throw new SqldbHammerException("entity query mapping index must be 0-8");
    }

    public RepositoryRelation[] getFilterableRepositoryRelations() {
        return (RepositoryRelation[])this.repositoryFilterableTuple.streamOf(RepositoryRelation.class).filter(r -> r != null).toArray(RepositoryRelation[]::new);
    }

    protected void checkIndex(int index) {
        AssertIllegalArgument.isGe((Number)index, (Number)0, (String)"repository index");
        AssertIllegalArgument.isLt((Number)index, (Number)this.repositoryFilterableTuple.degree(), (String)"repository index");
    }

    protected RepositoryRelation createRelationMapping(int sourceIndex, String sourceField, String joinRepository, String joinRepositoryAlias, String joinField) {
        return new RepositoryRelation(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField, this.aliasManager);
    }

    public static class RepositoryRelation {
        SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
        String repository;
        String repositoryAlias;
        String field;
        int sourceIndex;
        String sourceField;

        public RepositoryRelation(int sourceIndex, String sourceField, String joinRepository, String joinRepositoryAlias, String joinField, AliasManager aliasManager) {
            this(sourceIndex, sourceField, joinRepository, joinRepositoryAlias, joinField, aliasManager, null);
        }

        public RepositoryRelation(int sourceIndex, String sourceField, String joinRepository, String joinRepositoryAlias, String joinField, AliasManager aliasManager, SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder) {
            if (sourceIndex > 0) {
                AssertIllegalArgument.isNotEmpty((String)joinField, (String)"joinField");
                AssertIllegalArgument.isNotEmpty((String)sourceField, (String)"sourceField");
            }
            this.sourceIndex = sourceIndex;
            this.sourceField = sourceField;
            this.repository = joinRepository;
            this.field = joinField;
            if (Lang.isEmpty((String)joinRepositoryAlias)) {
                this.repositoryAlias = aliasManager.put(joinRepository);
            } else {
                aliasManager.put(this.repository, joinRepositoryAlias);
                this.repositoryAlias = joinRepositoryAlias;
            }
            this.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getRepositoryAlias() {
            return this.repositoryAlias;
        }

        public String getField() {
            return this.field;
        }

        public int getSourceIndex() {
            return this.sourceIndex;
        }

        public String getSourceField() {
            return this.sourceField;
        }
    }
}

