/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.execute;

import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.repository.AliasRepository;
import cn.featherfly.common.repository.Repository;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.hammer.config.dsl.UpdateConfig;
import cn.featherfly.hammer.dsl.entity.execute.EntityUpdate;
import cn.featherfly.hammer.dsl.execute.Updater;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.execute.EntitySqlExecutableUpdate;
import cn.featherfly.hammer.sqldb.dsl.repository.execute.RepositorySqlExecutableUpdate;
import cn.featherfly.hammer.sqldb.dsl.repository.execute.RepositorySqlUpdate;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;

public class SqlUpdater
implements Updater {
    private Jdbc jdbc;
    private JdbcMappingFactory mappingFactory;
    private UpdateConfig updateConfig;

    public SqlUpdater(Jdbc jdbc, JdbcMappingFactory mappingFactory, UpdateConfig updateConfig) {
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.updateConfig = updateConfig;
    }

    public RepositorySqlUpdate update(Table table) {
        return this.update(table.name());
    }

    public RepositorySqlUpdate update(Repository repository) {
        AliasManager aliasManager = new AliasManager();
        if (repository instanceof AliasRepository) {
            return new RepositorySqlExecutableUpdate((AliasRepository)repository, this.jdbc, aliasManager, this.mappingFactory.getMetadata(), (UpdateConfig)this.updateConfig.clone());
        }
        return new RepositorySqlExecutableUpdate(repository, this.jdbc, aliasManager, this.mappingFactory.getMetadata(), (UpdateConfig)this.updateConfig.clone());
    }

    public RepositorySqlUpdate update(String repository) {
        AliasManager aliasManager = new AliasManager();
        return new RepositorySqlExecutableUpdate(repository, this.jdbc, aliasManager, this.mappingFactory.getMetadata(), (UpdateConfig)this.updateConfig.clone());
    }

    public <E> EntityUpdate<E> update(Class<E> entityType) {
        if (this.mappingFactory == null) {
            throw new SqldbHammerException("mappingFactory is null");
        }
        return new EntitySqlExecutableUpdate(this.jdbc, this.mappingFactory.getClassMapping(entityType), this.mappingFactory, (UpdateConfig)this.updateConfig.clone());
    }
}

