/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.execute;

import cn.featherfly.common.db.FieldValueOperator;
import cn.featherfly.common.db.builder.dml.basic.SqlUpdateSetBasicBuilder;
import cn.featherfly.common.db.builder.model.UpdateColumnElement;
import cn.featherfly.common.function.serializable.SerializableFunction;
import cn.featherfly.common.function.serializable.SerializableSupplier;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.hammer.config.dsl.UpdateConfig;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import java.util.function.Predicate;

public abstract class AbstractSqlExecutableUpdate<U extends AbstractSqlExecutableUpdate<U>> {
    protected Jdbc jdbc;
    protected SqlUpdateSetBasicBuilder builder;
    protected UpdateConfig updateConfig;
    protected AliasManager aliasManager;

    protected AbstractSqlExecutableUpdate(String tableName, Jdbc jdbc, AliasManager aliasManager, UpdateConfig updateConfig) {
        this(tableName, null, jdbc, aliasManager, updateConfig);
    }

    protected AbstractSqlExecutableUpdate(String tableName, String tableAlias, Jdbc jdbc, AliasManager aliasManager, UpdateConfig updateConfig) {
        this.jdbc = jdbc;
        this.aliasManager = aliasManager;
        this.updateConfig = updateConfig;
        if (Lang.isEmpty((String)tableAlias)) {
            tableAlias = aliasManager.put(tableName);
        }
    }

    protected AbstractSqlExecutableUpdate(String tableName, String tableAlias, Jdbc jdbc, AliasManager aliasManager, UpdateConfig updateConfig, SqlUpdateSetBasicBuilder builder) {
        this.jdbc = jdbc;
        this.aliasManager = aliasManager;
        this.updateConfig = (UpdateConfig)updateConfig.clone();
        if (Lang.isEmpty((String)tableAlias)) {
            tableAlias = aliasManager.put(tableName);
        }
        builder = new SqlUpdateSetBasicBuilder(jdbc.getDialect(), tableName, tableAlias, v -> this.updateConfig.getSetValueIgnoreStrategy().test(v));
    }

    protected <V> U set0(String name, FieldValueOperator<V> value) {
        this.builder.setValue(name, value);
        return (U)this;
    }

    protected U set0(String name, FieldValueOperator<?> value, Predicate<? extends Object> setIgnoreStrategy) {
        this.builder.setValue(name, value, setIgnoreStrategy);
        return (U)this;
    }

    protected <O> U set0(String name, O value) {
        return this.set0(name, value, this.updateConfig.getSetValueIgnoreStrategy()::test);
    }

    protected <O> U set0(String name, O value, Predicate<O> ignoreStrategy) {
        return this.set0(name, (O)FieldValueOperator.create(value), ignoreStrategy);
    }

    protected <N extends Number> U increase0(String name, FieldValueOperator<N> value) {
        this.builder.setValue(name, value, UpdateColumnElement.SetType.INCR);
        return (U)this;
    }

    protected <N extends Number> U increase0(String name, FieldValueOperator<N> value, Predicate<?> ignoreStrategy) {
        this.builder.setValue(name, value, UpdateColumnElement.SetType.INCR, ignoreStrategy);
        return (U)this;
    }

    protected <N extends Number> U increase0(String name, N value) {
        return this.increase0(name, value, this.updateConfig.getSetValueIgnoreStrategy()::test);
    }

    protected <N extends Number> U increase0(String name, N value, Predicate<N> ignoreStrategy) {
        return this.increase0(name, (N)FieldValueOperator.create(value), ignoreStrategy);
    }

    protected <T, R> String getPropertyName(SerializableFunction<T, R> name) {
        return LambdaUtils.getLambdaPropertyName(name);
    }

    protected <R> String getPropertyName(SerializableSupplier<R> name) {
        return LambdaUtils.getLambdaPropertyName(name);
    }
}

