/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity.query;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.builder.dml.SortBuilder;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.tuple.Tuple3;
import cn.featherfly.common.tuple.Tuple7;
import cn.featherfly.common.tuple.Tuple8;
import cn.featherfly.common.tuple.Tuples;
import cn.featherfly.hammer.config.HammerConfig;
import cn.featherfly.hammer.config.cache.QueryPageResult;
import cn.featherfly.hammer.dsl.entity.query.EntityQueryConditionGroup;
import cn.featherfly.hammer.dsl.entity.query.EntityQueryConditionGroupLogic;
import cn.featherfly.hammer.expression.condition.LogicExpression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.AbstractMulitiEntitySqlConditionsGroupExpressionBase;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlRelation;
import cn.featherfly.hammer.sqldb.dsl.entity.query.AbstractMulitiEntitySqlQueryConditionsGroupExpression;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.cache.Cache;
import org.apache.commons.lang3.StringUtils;

public class EntitySqlQueryExpression<T>
extends AbstractMulitiEntitySqlQueryConditionsGroupExpression<T, EntityQueryConditionGroup<T>, EntityQueryConditionGroupLogic<T>>
implements EntityQueryConditionGroup<T>,
EntityQueryConditionGroupLogic<T> {
    public EntitySqlQueryExpression(HammerConfig hammerConfig, JdbcMappingFactory factory, SqlPageFactory sqlPageFactory, EntitySqlQueryRelation queryRelation) {
        this(null, hammerConfig, factory, sqlPageFactory, queryRelation);
    }

    EntitySqlQueryExpression(EntityQueryConditionGroupLogic<T> parent, HammerConfig hammerConfig, JdbcMappingFactory factory, SqlPageFactory sqlPageFactory, EntitySqlQueryRelation queryRelation) {
        super(parent, hammerConfig, factory, sqlPageFactory, queryRelation);
    }

    @Override
    protected EntitySqlQueryExpression<T> createGroup(EntityQueryConditionGroupLogic<T> parent) {
        return new EntitySqlQueryExpression<T>(parent, this.hammerConfig, this.factory, this.sqlPageFactory, (EntitySqlQueryRelation)this.entityRelation);
    }

    @Override
    public String expression() {
        String condition = super.expression();
        return EntitySqlQueryExpression.expression(condition, this.parent, (EntitySqlQueryRelation)this.entityRelation, this.getRootSortBuilder(), this.dialect);
    }

    @Override
    public Tuple7<String, List<Serializable>, Optional<Limit>, Optional<QueryPageResult>, String, Function<Object, Serializable>, Optional<Boolean>> prepareList(Limit limit) {
        return EntitySqlQueryExpression.prepareList(this.hammerConfig, this, super.expression(), this.parent, (EntitySqlQueryRelation)this.entityRelation, this.getRootSortBuilder(), this.dialect, limit);
    }

    @Override
    public Tuple8<String, String, List<Serializable>, Optional<Limit>, Optional<QueryPageResult>, String, Function<Object, Serializable>, Optional<Boolean>> preparePagination(Limit limit) {
        return EntitySqlQueryExpression.preparePage(this.hammerConfig, this, super.expression(), this.parent, (EntitySqlQueryRelation)this.entityRelation, this.getRootSortBuilder(), this.dialect, limit);
    }

    static String expression(String condition, LogicExpression<?, ?> parent, EntitySqlQueryRelation queryRelation, SortBuilder sortBuilder, Dialect dialect) {
        if (parent == null) {
            String result = queryRelation.buildSelectSql();
            if (Lang.isEmpty((String)condition)) {
                return result + " " + sortBuilder.build();
            }
            return result + " " + dialect.getKeywords().where() + " " + condition + " " + sortBuilder.build();
        }
        return condition;
    }

    static Tuple7<String, List<Serializable>, Optional<Limit>, Optional<QueryPageResult>, String, Function<Object, Serializable>, Optional<Boolean>> prepareList(HammerConfig hammerConfig, AbstractMulitiEntitySqlConditionsGroupExpressionBase<?, ?, ?, ?, ?, ?> exp, String condition, LogicExpression<?, ?> parent, EntitySqlQueryRelation queryRelation, SortBuilder sortBuilder, Dialect dialect, Limit limit) {
        if (parent != null) {
            throw new SqldbHammerException("not root expression, only root expression can invoke this method");
        }
        String select = null;
        String sort = sortBuilder.build();
        List<Serializable> params = exp.getParams();
        if (limit == null) {
            select = EntitySqlQueryExpression.selectSql(dialect, queryRelation, condition, sort);
            return Tuples.of((Object)select, params, Optional.ofNullable(limit), Optional.ofNullable(null), (Object)select, (Object)((JdbcPropertyMapping)queryRelation.getEntityRelation(0).getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getGetter(), Optional.of(true));
        }
        String selectSql = null;
        QueryPageResult queryPageResult = null;
        Cache queryPageResultCache = hammerConfig.getCacheConfig().getQueryPageResultCache();
        if (queryPageResultCache != null) {
            ArrayList<Serializable> key = new ArrayList<Serializable>(params);
            selectSql = EntitySqlQueryExpression.expression(condition, parent, queryRelation, sortBuilder, dialect);
            key.add(0, (Serializable)((Object)selectSql));
            queryPageResult = (QueryPageResult)queryPageResultCache.get(key);
            if (queryPageResult != null && queryPageResult.getTotal() != null && queryPageResult.getTotal() / (long)limit.getLimit() < (long)((limit.getOffset() + limit.getLimit()) / limit.getLimit())) {
                return Tuples.of((Object)selectSql, params, Optional.ofNullable(limit), Optional.of(queryPageResult), (Object)selectSql, (Object)((JdbcPropertyMapping)queryRelation.getEntityRelation(0).getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getGetter(), Optional.empty());
            }
            if (queryRelation.getEntityRelation(0).getClassMapping().isPrimaryKeyOrdered() && StringUtils.isBlank((CharSequence)sort)) {
                if (queryPageResult == null) {
                    queryPageResult = new QueryPageResult();
                } else if (queryPageResult.getLimit() == null || queryPageResult.getLimit().intValue() == limit.getLimit()) {
                    Tuple3<String, Limit, Optional<Boolean>> conditionAndLimit = EntitySqlQueryExpression.processLimit(queryRelation, condition, limit, queryPageResult, dialect);
                    select = queryRelation.buildSelectSql() + " " + dialect.getKeywords().where() + " " + (String)conditionAndLimit.get0() + " " + sort;
                    return Tuples.of((Object)select, params, Optional.ofNullable(conditionAndLimit.get1()), Optional.of(queryPageResult), (Object)selectSql, (Object)((JdbcPropertyMapping)queryRelation.getEntityRelation(0).getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getGetter(), (Object)conditionAndLimit.get2());
                }
            }
        }
        select = (String)Lang.ifNull(selectSql, () -> EntitySqlQueryExpression.selectSql(dialect, queryRelation, condition, sort));
        return Tuples.of((Object)select, params, Optional.ofNullable(limit), Optional.ofNullable(queryPageResult), (Object)select, (Object)((JdbcPropertyMapping)queryRelation.getEntityRelation(0).getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getGetter(), Optional.of(true));
    }

    static Tuple8<String, String, List<Serializable>, Optional<Limit>, Optional<QueryPageResult>, String, Function<Object, Serializable>, Optional<Boolean>> preparePage(HammerConfig hammerConfig, AbstractMulitiEntitySqlConditionsGroupExpressionBase<?, ?, ?, ?, ?, ?> exp, String condition, LogicExpression<?, ?> parent, EntitySqlQueryRelation queryRelation, SortBuilder sortBuilder, Dialect dialect, Limit limit) {
        if (parent != null) {
            throw new SqldbHammerException("not root expression, only root expression can invoke this method");
        }
        String sort = sortBuilder.build();
        List<Serializable> params = exp.getParams();
        String select = null;
        if (limit == null) {
            select = EntitySqlQueryExpression.selectSql(dialect, queryRelation, condition, sort);
            return Tuples.of((Object)select, (Object)EntitySqlQueryExpression.countSql(dialect, queryRelation, condition, sort), params, Optional.ofNullable(limit), Optional.ofNullable(null), (Object)select, (Object)((JdbcPropertyMapping)queryRelation.getEntityRelation(0).getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getGetter(), Optional.of(true));
        }
        String selectCount = null;
        String selectSql = null;
        QueryPageResult queryPageResult = null;
        Cache queryPageResultCache = hammerConfig.getCacheConfig().getQueryPageResultCache();
        if (queryPageResultCache != null) {
            ArrayList<Serializable> key = new ArrayList<Serializable>(params);
            selectSql = EntitySqlQueryExpression.expression(condition, parent, queryRelation, sortBuilder, dialect);
            key.add(0, (Serializable)((Object)selectSql));
            queryPageResult = (QueryPageResult)queryPageResultCache.get(key);
            if (queryPageResult != null && queryPageResult.getTotal() != null && queryPageResult.getTotal() / (long)limit.getLimit() < (long)((limit.getOffset() + limit.getLimit()) / limit.getLimit())) {
                return Tuples.of((Object)selectSql, (Object)EntitySqlQueryExpression.countSql(dialect, queryRelation, condition, sort), params, Optional.ofNullable(limit), Optional.of(queryPageResult), (Object)selectSql, (Object)((JdbcPropertyMapping)queryRelation.getEntityRelation(0).getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getGetter(), Optional.empty());
            }
            if (queryRelation.getEntityRelation(0).getClassMapping().isPrimaryKeyOrdered() && StringUtils.isBlank((CharSequence)sort)) {
                if (queryPageResult == null) {
                    queryPageResult = new QueryPageResult();
                } else if (queryPageResult.getLimit() != null && queryPageResult.getLimit().intValue() == limit.getLimit()) {
                    Tuple3<String, Limit, Optional<Boolean>> conditionAndLimit = EntitySqlQueryExpression.processLimit(queryRelation, condition, limit, queryPageResult, dialect);
                    select = queryRelation.buildSelectSql() + " " + dialect.getKeywords().where() + " " + (String)conditionAndLimit.get0() + " " + sort;
                    selectCount = EntitySqlQueryExpression.countSql(dialect, queryRelation, condition, sort);
                    return Tuples.of((Object)select, (Object)selectCount, params, Optional.ofNullable(conditionAndLimit.get1()), Optional.of(queryPageResult), (Object)selectSql, (Object)((JdbcPropertyMapping)queryRelation.getEntityRelation(0).getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getGetter(), (Object)conditionAndLimit.get2());
                }
            }
        }
        select = (String)Lang.ifNull(selectSql, () -> EntitySqlQueryExpression.selectSql(dialect, queryRelation, condition, sort));
        selectCount = EntitySqlQueryExpression.countSql(dialect, queryRelation, condition, sort);
        return Tuples.of((Object)select, (Object)selectCount, params, Optional.ofNullable(limit), Optional.ofNullable(queryPageResult), (Object)select, (Object)((JdbcPropertyMapping)queryRelation.getEntityRelation(0).getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getGetter(), Optional.of(true));
    }

    private static Tuple3<String, Limit, Optional<Boolean>> processLimit(EntitySqlQueryRelation queryRelation, String condition, Limit limit, QueryPageResult queryPageResult, Dialect dialect) {
        String pageCondition = null;
        EntitySqlRelation.EntityRelation<?> er = queryRelation.getEntityRelation(0);
        String idField = ((JdbcPropertyMapping)er.getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getRepositoryFieldName();
        QueryPageResult.PageInfo pageInfo = queryPageResult.getNearestQueryPageResult(limit);
        if (pageInfo.getFirstId() == null) {
            return Tuples.of((Object)condition, (Object)limit, Optional.of(true));
        }
        if (limit.getOffset() > pageInfo.getOffset()) {
            pageCondition = er.getTableAlias() + "." + dialect.wrapName(idField) + " > " + pageInfo.getLastId().longValue() + " " + (String)Lang.ifNotEmpty((Object)condition, c -> " " + dialect.keywords().and() + " " + c);
            return Tuples.of((Object)pageCondition, (Object)new Limit(Integer.valueOf(limit.getOffset() - pageInfo.getOffset() - pageInfo.getLimit()), limit.getLimit()), Optional.of(true));
        }
        if (limit.getOffset() < pageInfo.getOffset()) {
            pageCondition = er.getTableAlias() + "." + ((JdbcPropertyMapping)er.getClassMapping().getPrimaryKeyPropertyMappings().get(0)).getRepositoryFieldName() + " < " + pageInfo.getFirstId().longValue() + " " + (String)Lang.ifNotEmpty((Object)condition, c -> " " + dialect.keywords().and() + " " + c);
            return Tuples.of((Object)pageCondition, (Object)new Limit(Integer.valueOf(pageInfo.getOffset() - limit.getOffset() - limit.getLimit()), limit.getLimit()), Optional.of(true));
        }
        pageCondition = er.getTableAlias() + "." + dialect.wrapName(idField) + " >= " + pageInfo.getFirstId().longValue() + (String)Lang.ifNotEmpty((Object)condition, c -> " " + dialect.keywords().and() + " " + c);
        return Tuples.of((Object)pageCondition, (Object)limit, Optional.of(true));
    }

    private static String countSql(Dialect dialect, EntitySqlQueryRelation queryRelation, String condition, String sort) {
        if (Lang.isEmpty((String)condition)) {
            return queryRelation.buildSelectCountSql() + " " + sort;
        }
        return queryRelation.buildSelectCountSql() + " " + dialect.getKeywords().where() + " " + condition + " " + sort;
    }

    private static String selectSql(Dialect dialect, EntitySqlQueryRelation queryRelation, String condition, String sort) {
        if (Lang.isEmpty((String)condition)) {
            return queryRelation.buildSelectSql() + " " + sort;
        }
        return queryRelation.buildSelectSql() + " " + dialect.getKeywords().where() + " " + condition + " " + sort;
    }
}

