/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity.condition;

import cn.featherfly.common.db.builder.model.ArithmeticColumnElement;
import cn.featherfly.common.db.builder.model.ColumnElement;
import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.exception.NotImplementedException;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Str;
import cn.featherfly.common.operator.Function;
import cn.featherfly.common.repository.Field;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.hammer.expression.condition.ConditionExpression;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.LogicExpression;
import cn.featherfly.hammer.expression.condition.field.FieldExpression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlRelation;
import cn.featherfly.hammer.sqldb.dsl.entity.condition.InternalMulitiEntityCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public abstract class AbstractMulitiEntityPropertyExpression<E, C extends ConditionExpression, L extends LogicExpression<C, L>>
implements Expression {
    protected AtomicInteger index;
    protected InternalMulitiEntityCondition<L> expression;
    protected JdbcMappingFactory factory;
    protected List<Serializable> propertyList = new ArrayList<Serializable>();
    protected EntitySqlRelation<?, ?> queryRelation;
    protected Supplier<ArithmeticColumnElement> arithmeticColumnElement = () -> null;
    protected final Function function;
    protected final Object[] argus;

    protected AbstractMulitiEntityPropertyExpression(AtomicInteger index, Serializable name, InternalMulitiEntityCondition<L> expression, JdbcMappingFactory factory, EntitySqlRelation<?, ?> queryRelation) {
        this(index, Lang.list((Object[])new Serializable[]{name}), null, ArrayUtils.EMPTY_OBJECT_ARRAY, expression, factory, queryRelation);
    }

    protected AbstractMulitiEntityPropertyExpression(AtomicInteger index, Serializable name, Function function, Object[] argus, InternalMulitiEntityCondition<L> expression, JdbcMappingFactory factory, EntitySqlRelation<?, ?> queryRelation) {
        this(index, Lang.list((Object[])new Serializable[]{name}), function, argus, expression, factory, queryRelation);
    }

    protected AbstractMulitiEntityPropertyExpression(AtomicInteger index, List<Serializable> propertyList, InternalMulitiEntityCondition<L> expression, JdbcMappingFactory factory, EntitySqlRelation<?, ?> queryRelation) {
        this(index, propertyList, null, ArrayUtils.EMPTY_OBJECT_ARRAY, expression, factory, queryRelation);
    }

    protected AbstractMulitiEntityPropertyExpression(AtomicInteger index, List<Serializable> propertyList, Function function, Object[] argus, InternalMulitiEntityCondition<L> expression, JdbcMappingFactory factory, EntitySqlRelation<?, ?> queryRelation) {
        this.index = index;
        this.expression = expression;
        this.propertyList.addAll(propertyList);
        this.function = function;
        this.argus = argus;
        this.factory = factory;
        this.queryRelation = queryRelation;
    }

    public L eq(Field field) {
        return (L)((LogicExpression)this.expression.eq(this.index, this.getPropertyMapping(field), (ColumnElement)this.arithmeticColumnElement.get(), field, this.expression.getIgnoreStrategy()));
    }

    public L eq(FieldExpression expr) {
        return (L)((LogicExpression)this.expression.eq(this.index, this.getPropertyMapping(expr), (ColumnElement)this.arithmeticColumnElement.get(), expr, this.expression.getIgnoreStrategy()));
    }

    public String expression() {
        return new ColumnElement(this.expression.getJdbc().getDialect(), this.expression.getAlias(this.index.intValue()), this.getPropertyMapping(this).getRepositoryFieldName()).toSql();
    }

    protected PropertyMapping<?> getPropertyMapping(Object value) {
        int index = this.index.get();
        if (this.propertyList.size() == 1) {
            ClassMapping classMapping = this.expression.getClassMapping(index);
            return classMapping.getPropertyMapping(LambdaUtils.getLambdaPropertyName((Serializable)this.propertyList.get(0)));
        }
        if (this.propertyList.size() == 2) {
            ClassMapping classMapping = this.expression.getClassMapping(index);
            JdbcPropertyMapping pm = (JdbcPropertyMapping)classMapping.getPropertyMapping(LambdaUtils.getLambdaPropertyName((Serializable)this.propertyList.get(0)));
            if (value == null) {
                return pm;
            }
            LambdaUtils.SerializedLambdaInfo propertyInfo = LambdaUtils.getLambdaInfo((Serializable)this.propertyList.get(1));
            String pn = propertyInfo.getPropertyName();
            if (pm.getMode() == PropertyMapping.Mode.EMBEDDED) {
                JdbcPropertyMapping spm = (JdbcPropertyMapping)pm.getPropertyMapping(pn);
                if (spm == null) {
                    throw new SqldbHammerException(Str.format((String)"no property mapping found for {0}.{1}.{2}", (Object[])new Object[]{classMapping.getType().getSimpleName(), pm.getPropertyFullName(), pn}));
                }
                return spm;
            }
            if (PropertyMapping.Mode.MANY_TO_ONE == pm.getMode()) {
                JdbcPropertyMapping spm = (JdbcPropertyMapping)pm.getPropertyMapping(pn);
                if (spm != null) {
                    return spm;
                }
                JdbcClassMapping cm = this.factory.getClassMapping(pm.getPropertyType());
                spm = (JdbcPropertyMapping)cm.getPropertyMapping(pn);
                if (spm != null) {
                    this.queryRelation.join(Join.LEFT_JOIN, index, pm.getPropertyName(), cm, false);
                    this.index.incrementAndGet();
                    return spm;
                }
                throw new SqldbHammerException(Str.format((String)"no property mapping found for {0}.{1}", (Object[])new Object[]{cm.getType().getSimpleName(), pn}));
            }
            if (pm.getMode() == PropertyMapping.Mode.ONE_TO_MANY) {
                throw new NotImplementedException();
            }
            if (pm.getMode() == PropertyMapping.Mode.SINGLE) {
                throw new NotImplementedException();
            }
            throw new UnsupportedException();
        }
        throw new NotImplementedException();
    }

    protected ColumnElement getColumnElement(PropertyMapping<?> propertyMapping) {
        if (this.arithmeticColumnElement.get() != null) {
            return (ColumnElement)this.arithmeticColumnElement.get();
        }
        if (this.function != null) {
            return new ColumnElement(this.expression.getJdbc().getDialect(), this.expression.getAlias(this.index.get()), propertyMapping.getRepositoryFieldName(), this.function, this.argus);
        }
        return null;
    }

    public String name() {
        return this.getPropertyMapping(null).getRepositoryFieldName();
    }
}

