/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity;

import cn.featherfly.common.bean.PropertyAccessor;
import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectJoinOnBasicBuilder;
import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Str;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.tuple.MutableTuples;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.common.tuple.Tuples;
import cn.featherfly.common.tuple.mutable.MutableTuple9;
import cn.featherfly.hammer.config.dsl.ConditionConfig;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.query.SqlRelation;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.mapper.EntityRowMapper;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;

public abstract class EntitySqlRelation<R extends EntitySqlRelation<R, B>, B extends SqlBuilder>
implements SqlRelation<B> {
    protected Jdbc jdbc;
    protected AliasManager aliasManager;
    protected ConditionConfig<?> conditionConfig;
    protected int index;
    protected MutableTuple9<EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>> entityFilterableMappingTuple = MutableTuples.create9();
    protected final Set<String> joinedRelations = new HashSet<String>();

    protected EntitySqlRelation(Jdbc jdbc, AliasManager aliasManager, ConditionConfig<?> conditionConfig) {
        AssertIllegalArgument.isNotNull((Object)jdbc, (String)"jdbc");
        AssertIllegalArgument.isNotNull((Object)aliasManager, (String)"aliasManager");
        AssertIllegalArgument.isNotNull(conditionConfig, (String)"conditionConfig");
        this.jdbc = jdbc;
        this.aliasManager = aliasManager;
        this.conditionConfig = conditionConfig;
    }

    public R addFilterable(JdbcClassMapping<?> classMapping) {
        return this.addFilterable(0, null, classMapping, null);
    }

    public R addFilterable(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName) {
        return this.addFilterable(sourceIndex, propertyName, joinClassMapping, joinPropertyName, false);
    }

    public R addFilterable(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName, boolean fetchToProperty) {
        AssertIllegalArgument.isGe((Number)this.index, (Number)0, (String)"entity index");
        AssertIllegalArgument.isLt((Number)this.index, (Number)this.entityFilterableMappingTuple.degree(), (String)"entity index");
        switch (this.index) {
            case 0: {
                EntityRelation<?> eqm = this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty);
                this.entityFilterableMappingTuple.set0(eqm);
                this.initBuilder(eqm);
                break;
            }
            case 1: {
                this.entityFilterableMappingTuple.set1(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty));
                break;
            }
            case 2: {
                this.entityFilterableMappingTuple.set2(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty));
                break;
            }
            case 3: {
                this.entityFilterableMappingTuple.set3(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty));
                break;
            }
            case 4: {
                this.entityFilterableMappingTuple.set4(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty));
                break;
            }
            case 5: {
                this.entityFilterableMappingTuple.set5(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty));
                break;
            }
            case 6: {
                this.entityFilterableMappingTuple.set6(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty));
                break;
            }
            case 7: {
                this.entityFilterableMappingTuple.set7(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty));
                break;
            }
            case 8: {
                this.entityFilterableMappingTuple.set8(this.createEntityRelationMapping(sourceIndex, propertyName, joinClassMapping, joinPropertyName, fetchToProperty));
                break;
            }
        }
        ++this.index;
        return (R)this;
    }

    public R join(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping) {
        return this.join(Join.INNER_JOIN, sourceIndex, propertyName, joinClassMapping);
    }

    public R join(Join join, int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping) {
        return this.join(join, sourceIndex, propertyName, joinClassMapping, false);
    }

    public R join(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, boolean returnType) {
        return this.join(Join.INNER_JOIN, sourceIndex, propertyName, joinClassMapping, returnType);
    }

    public R join(Join join, int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, boolean returnType) {
        if (joinClassMapping.getPrimaryKeyPropertyMappings().size() == 1) {
            return this.join(join, sourceIndex, propertyName, joinClassMapping, ((JdbcPropertyMapping)joinClassMapping.getPrimaryKeyPropertyMappings().get(0)).getRepositoryFieldName(), returnType);
        }
        throw new SqldbHammerException(Str.format((String)"only support one privary key, but more than one privary key found {0}", (Object)joinClassMapping.getPrimaryKeyPropertyMappings().size()));
    }

    public R join(int sourceIndex, JdbcClassMapping<?> joinClassMapping, String joinPropertyName, boolean returnType) {
        return this.join(Join.INNER_JOIN, sourceIndex, joinClassMapping, joinPropertyName, returnType);
    }

    public R join(Join join, int sourceIndex, JdbcClassMapping<?> joinClassMapping, String joinPropertyName, boolean returnType) {
        EntityRelation<?> erm = this.getEntityRelation(sourceIndex);
        return this.join(join, sourceIndex, erm.getIdName(), joinClassMapping, joinPropertyName, returnType);
    }

    public R join(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName) {
        return this.join(Join.INNER_JOIN, sourceIndex, propertyName, joinClassMapping, joinPropertyName);
    }

    public R join(Join join, int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName) {
        return this.join(join, sourceIndex, propertyName, joinClassMapping, joinPropertyName, true);
    }

    public R join(int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName, boolean returnType) {
        return this.join(Join.INNER_JOIN, sourceIndex, propertyName, joinClassMapping, joinPropertyName, returnType);
    }

    public abstract R join(Join var1, int var2, String var3, JdbcClassMapping<?> var4, String var5, boolean var6);

    public <T> EntitySqlRelation<?, ?> join(JdbcClassMapping<T> joinClassMapping, Supplier<Expression> onExpression) {
        return this.join(Join.INNER_JOIN, joinClassMapping, onExpression);
    }

    public abstract <T> EntitySqlRelation<?, ?> join(Join var1, JdbcClassMapping<T> var2, Supplier<Expression> var3);

    protected abstract void initBuilder(EntityRelation<?> var1);

    @Override
    public Jdbc getJdbc() {
        return this.jdbc;
    }

    @Override
    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    @Override
    public Predicate<Object> getIgnoreStrategy() {
        return this.conditionConfig.getIgnoreStrategy();
    }

    public MutableTuple9<EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>, EntityRelation<?>> getEntityRelationTuple() {
        return this.entityFilterableMappingTuple;
    }

    public EntityRelation<?> getEntityRelation(int index) {
        switch (index) {
            case 0: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull0();
            }
            case 1: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull1();
            }
            case 2: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull2();
            }
            case 3: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull3();
            }
            case 4: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull4();
            }
            case 5: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull5();
            }
            case 6: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull6();
            }
            case 7: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull7();
            }
            case 8: {
                return (EntityRelation)this.entityFilterableMappingTuple.getOrNull8();
            }
        }
        throw new SqldbHammerException("entity query mapping index must be 0-8");
    }

    public EntityRelation<?>[] getFilterableEntityRelations() {
        return (EntityRelation[])this.entityFilterableMappingTuple.streamOf(EntityRelation.class).filter(r -> r != null).toArray(n -> new EntityRelation[this.index]);
    }

    protected <E> EntityRelation<E> createEntityRelationMapping(int sourceIndex, String propertyName, JdbcClassMapping<E> joinClassMapping, String joinPropertyName, boolean fetchToProperty) {
        int[] joinFromPropertyIndexes;
        EntityRelation<?> ser = this.getEntityRelation(sourceIndex);
        if (ser != null && fetchToProperty) {
            JdbcClassMapping<?> cm = ser.getClassMapping();
            JdbcPropertyMapping pm = (JdbcPropertyMapping)cm.getPropertyMapping(propertyName);
            joinFromPropertyIndexes = ArrayUtils.addAll((int[])ser.getJoinFromPropertyIndexes(), (int[])pm.getPropertyIndexes());
        } else {
            joinFromPropertyIndexes = ArrayUtils.EMPTY_INT_ARRAY;
        }
        return new EntityRelation<E>(this.jdbc, joinClassMapping, joinPropertyName, ser, propertyName, joinFromPropertyIndexes, fetchToProperty, this.aliasManager);
    }

    public static class EntityRelation<E> {
        private final Jdbc jdbc;
        private final PropertyAccessor<E> propertyAccessor;
        private Set<Tuple2<int[], JdbcPropertyMapping>> fetchPropertyMappings = new LinkedHashSet<Tuple2<int[], JdbcPropertyMapping>>();
        SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
        JdbcClassMapping<E> classMapping;
        private final EntityRelation<?> joinFrom;
        private final boolean fetchToProperty;
        String joinPropertyName;
        String joinFromFullPropertyName;
        String tableAlias;
        String idName;
        private final String joinFromPropertyName;
        private final String fullJoinFromPropertyName;
        int[] joinFromPropertyIndexes;

        public EntityRelation(Jdbc jdbc, JdbcClassMapping<E> classMapping, String joinPropertyName, EntityRelation<?> joinFrom, String joinFromPropertyName, int[] joinFromPropertyIndexes, boolean fetchToProperty, AliasManager aliasManager) {
            this(jdbc, classMapping, joinPropertyName, joinFrom, joinFromPropertyName, joinFromPropertyIndexes, fetchToProperty, aliasManager, null);
        }

        public EntityRelation(Jdbc jdbc, JdbcClassMapping<E> classMapping, String joinPropertyName, EntityRelation<?> joinFrom, String joinFromPropertyName, int[] joinFromPropertyIndexes, boolean fetchToProperty, AliasManager aliasManager, SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder) {
            this.classMapping = classMapping;
            this.joinPropertyName = joinPropertyName;
            this.joinFromPropertyName = joinFromPropertyName;
            this.joinFromPropertyIndexes = joinFromPropertyIndexes;
            this.joinFrom = joinFrom;
            this.fetchToProperty = fetchToProperty;
            this.tableAlias = aliasManager.put(classMapping.getRepositoryName());
            if (classMapping.getPrimaryKeyPropertyMappings().size() == 1) {
                this.idName = ((JdbcPropertyMapping)classMapping.getPrimaryKeyPropertyMappings().get(0)).getRepositoryFieldName();
            }
            if (Lang.isEmpty((String)joinPropertyName)) {
                if (Lang.isEmpty((String)this.idName)) {
                    if (Lang.isNotEmpty(joinFrom)) {
                        throw new SqldbHammerException("joinPropertyName and idName are all empty");
                    }
                } else {
                    this.joinPropertyName = this.idName;
                }
            }
            this.fullJoinFromPropertyName = fetchToProperty ? (joinFrom.getFullJoinPropertyName() == null ? joinFromPropertyName : joinFrom.getFullJoinPropertyName() + "." + joinFromPropertyName) : null;
            this.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder;
            this.propertyAccessor = jdbc.getPropertyAccessorFactory().create(classMapping.getType());
            this.jdbc = jdbc;
        }

        public JdbcClassMapping<E> getClassMapping() {
            return this.classMapping;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public String getIdName() {
            return this.idName;
        }

        public void setIdName(String idName) {
            this.idName = idName;
        }

        public String getJoinPropertyName() {
            return this.joinPropertyName;
        }

        public String getJoinFromPropertyName() {
            return this.joinFromPropertyName;
        }

        public EntityRelation<?> getJoinFrom() {
            return this.joinFrom;
        }

        public boolean isFetchToProperty() {
            return this.fetchToProperty;
        }

        public void addFetchPropertyMapping(int[] indexes, JdbcPropertyMapping propertyMapping) {
            if (this.joinFrom != null && this.fetchToProperty) {
                this.joinFrom.addFetchPropertyMapping(indexes, propertyMapping);
            } else {
                this.fetchPropertyMappings.add((Tuple2<int[], JdbcPropertyMapping>)Tuples.of((Object)indexes, (Object)propertyMapping));
            }
        }

        public Set<Tuple2<int[], JdbcPropertyMapping>> getFetchPropertyMappings() {
            return this.fetchPropertyMappings;
        }

        public int[] getJoinFromPropertyIndexes() {
            return this.joinFromPropertyIndexes;
        }

        public String getFullJoinPropertyName() {
            return this.fullJoinFromPropertyName;
        }

        public String getFullJoinPropertyName(boolean prefixTableAlias) {
            if (prefixTableAlias) {
                return this.getRootObject().getTableAlias() + "." + this.fullJoinFromPropertyName;
            }
            return this.fullJoinFromPropertyName;
        }

        private EntityRelation<?> getRootObject() {
            if (this.joinFrom != null && this.fetchToProperty) {
                return super.getRootObject();
            }
            return this;
        }

        public EntityRowMapper<E> getMapper() {
            if (Lang.isEmpty(this.fetchPropertyMappings)) {
                return new EntityRowMapper<E>(this.propertyAccessor, this.jdbc.getDialect(), this.classMapping);
            }
            return new EntityRowMapper<E>(this.propertyAccessor, this.jdbc.getDialect(), this.classMapping, this.fetchPropertyMappings);
        }
    }
}

