/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity;

import cn.featherfly.common.db.builder.dml.basic.SqlSelectBasicBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectJoinOnBasicBuilder;
import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.operator.AggregateFunction;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.common.tuple.Tuple3;
import cn.featherfly.common.tuple.Tuple4;
import cn.featherfly.common.tuple.Tuple5;
import cn.featherfly.common.tuple.Tuple6;
import cn.featherfly.common.tuple.Tuple7;
import cn.featherfly.common.tuple.Tuple8;
import cn.featherfly.common.tuple.Tuple9;
import cn.featherfly.hammer.config.dsl.ConditionConfig;
import cn.featherfly.hammer.config.dsl.DslQueryConfig;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlRelation;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.mapper.TupleEntityRowMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;

public class EntitySqlQueryRelation
extends EntitySqlRelation<EntitySqlQueryRelation, SqlSelectBasicBuilder> {
    private SqlSelectBasicBuilder selectBuilder;
    private Map<Integer, EntitySqlRelation.EntityRelation<?>> entityQueryFetchMapping = new HashMap();
    private Set<String> queryFetchAlias = new HashSet<String>();

    public EntitySqlQueryRelation(Jdbc jdbc, AliasManager aliasManager, DslQueryConfig queryConfig) {
        super(jdbc, aliasManager, (ConditionConfig<?>)queryConfig);
    }

    public EntitySqlQueryRelation query(JdbcClassMapping<?> classMapping) {
        return (EntitySqlQueryRelation)this.addFilterable(classMapping);
    }

    public <T> EntitySqlQueryRelation join(Join join, JdbcClassMapping<T> joinClassMapping, Supplier<Expression> onExpression) {
        SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
        AssertIllegalArgument.isNotNull(joinClassMapping, (String)"joinClassMapping");
        this.addFilterable(joinClassMapping);
        EntitySqlRelation.EntityRelation<?> jerm = this.getEntityRelation(this.index - 1);
        jerm.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder = this.getBuilder().join2(join, joinClassMapping, jerm.getTableAlias(), onExpression.get().expression());
        return this;
    }

    @Override
    public EntitySqlQueryRelation join(Join join, int sourceIndex, String propertyName, JdbcClassMapping<?> joinClassMapping, String joinPropertyName, boolean returnType) {
        EntitySqlRelation.EntityRelation<?> first;
        AssertIllegalArgument.isNotNull((Object)join, (String)"join");
        AssertIllegalArgument.isNotNull((Object)propertyName, (String)"propertyName");
        AssertIllegalArgument.isNotNull(joinClassMapping, (String)"joinClassMapping");
        AssertIllegalArgument.isNotNull((Object)joinPropertyName, (String)"joinPropertyName");
        EntitySqlRelation.EntityRelation<?> erm = this.getEntityRelation(sourceIndex);
        if (returnType) {
            this.addFilterable(sourceIndex, propertyName, joinClassMapping, joinPropertyName);
        } else {
            this.addFilterable(sourceIndex, propertyName, joinClassMapping, joinPropertyName, true);
        }
        EntitySqlRelation.EntityRelation<?> jerm = this.getEntityRelation(this.index - 1);
        String joinRelation = erm.getClassMapping().getType().getSimpleName() + "[" + erm.getTableAlias() + "]." + jerm.getJoinFromPropertyName();
        if (returnType || !this.joinedRelations.contains(joinRelation)) {
            SqlSelectJoinOnBasicBuilder selectJoinOnBasicBuilder;
            this.joinedRelations.add(joinRelation);
            jerm.selectJoinOnBasicBuilder = selectJoinOnBasicBuilder = this.join0(join, erm.getTableAlias(), ((JdbcPropertyMapping)erm.getClassMapping().getPropertyMapping(propertyName)).getRepositoryFieldName(), joinClassMapping, jerm.getTableAlias(), ((JdbcPropertyMapping)joinClassMapping.getPropertyMapping(joinPropertyName)).getRepositoryFieldName());
        }
        if ((first = this.getEntityRelation(0)).getFetchPropertyMappings().isEmpty()) {
            for (JdbcPropertyMapping pm : first.getClassMapping().getPropertyMappingLeafNodes()) {
                first.addFetchPropertyMapping(pm.getPropertyIndexes(), pm);
            }
        }
        return this;
    }

    private SqlSelectJoinOnBasicBuilder join0(Join join, String tableAlias, String columnName, JdbcClassMapping<?> joinClassMapping, String joinTableAlias, String joinTableColumnName) {
        return this.getBuilder().join(join, tableAlias, columnName, joinClassMapping, joinTableAlias, joinTableColumnName);
    }

    private void fetch(EntitySqlRelation.EntityRelation<?> erm) {
        for (JdbcPropertyMapping pm : erm.getClassMapping().getPropertyMappingLeafNodes()) {
            erm.addFetchPropertyMapping(ArrayUtils.addAll((int[])erm.getJoinFromPropertyIndexes(), (int[])pm.getPropertyIndexes()), pm);
        }
    }

    public EntitySqlQueryRelation fetch(int index) {
        AssertIllegalArgument.isGe((Number)index, (Number)0, (String)"fetch entity index");
        AssertIllegalArgument.isLt((Number)index, (Number)this.entityFilterableMappingTuple.degree(), (String)"fetch entity index");
        EntitySqlRelation.EntityRelation<?> erm = this.getEntityRelation(index);
        this.entityQueryFetchMapping.put(this.entityQueryFetchMapping.size(), erm);
        this.queryFetchAlias.add(erm.getTableAlias());
        if (index > 0) {
            erm.selectJoinOnBasicBuilder.fetch();
            this.fetch(erm);
        }
        return this;
    }

    public EntitySqlQueryRelation fetchProperty(int index) {
        AssertIllegalArgument.isGe((Number)index, (Number)0, (String)"fetch entity index");
        AssertIllegalArgument.isLt((Number)index, (Number)this.entityFilterableMappingTuple.degree(), (String)"fetch entity index");
        EntitySqlRelation.EntityRelation<?> erm = this.getEntityRelation(index);
        this.queryFetchAlias.add(erm.getTableAlias());
        if (index > 0) {
            this.fetch(erm);
            erm.selectJoinOnBasicBuilder.fetch((prefixTableAlias, alias) -> {
                if (prefixTableAlias.booleanValue()) {
                    return erm.getFullJoinPropertyName((boolean)prefixTableAlias);
                }
                return erm.getFullJoinPropertyName();
            });
        }
        return this;
    }

    public EntitySqlQueryRelation fetchProperty(int index, String propertyName) {
        return this.fetchProperty(index, false, propertyName);
    }

    public EntitySqlQueryRelation fetchProperty(int index, boolean distinct, String propertyName) {
        AssertIllegalArgument.isGe((Number)index, (Number)0, (String)"fetch entity index");
        AssertIllegalArgument.isLt((Number)index, (Number)this.entityFilterableMappingTuple.degree(), (String)"fetch entity index");
        EntitySqlRelation.EntityRelation<?> erm = this.getEntityRelation(index);
        this.queryFetchAlias.add(erm.getTableAlias());
        if (index == 0) {
            Tuple2 columnAndProperty = ClassMappingUtils.getColumnAndPropertyName((String)propertyName, erm.getClassMapping());
            this.getBuilder().addColumn(distinct, (String)columnAndProperty.get0(), (String)columnAndProperty.get1());
            JdbcPropertyMapping pm = (JdbcPropertyMapping)erm.classMapping.getPropertyMapping(propertyName);
            erm.addFetchPropertyMapping(pm.getPropertyIndexes(), pm);
        } else if (index > 0) {
            Tuple2 columnAndProperty = ClassMappingUtils.getColumnAndPropertyName((String)propertyName, erm.getClassMapping());
            erm.selectJoinOnBasicBuilder.fetch(distinct, (String)columnAndProperty.get0(), (String)columnAndProperty.get1());
            EntitySqlRelation.EntityRelation<?> ser = erm.getJoinFrom();
            for (JdbcPropertyMapping pm : erm.getClassMapping().getPropertyMappingLeafNodes()) {
                ser.addFetchPropertyMapping(ArrayUtils.addAll((int[])ser.getJoinFromPropertyIndexes(), (int[])pm.getPropertyIndexes()), pm);
            }
        }
        return this;
    }

    public EntitySqlQueryRelation fetchProperty(int index, AggregateFunction aggregateFunction, String propertyName) {
        return this.fetchProperty(index, aggregateFunction, false, propertyName, null);
    }

    public EntitySqlQueryRelation fetchProperty(int index, AggregateFunction aggregateFunction, String propertyName, String alias) {
        return this.fetchProperty(index, aggregateFunction, false, propertyName, alias);
    }

    public EntitySqlQueryRelation fetchProperty(int index, AggregateFunction aggregateFunction, boolean distinct, String propertyName) {
        return this.fetchProperty(index, aggregateFunction, distinct, propertyName, null);
    }

    public EntitySqlQueryRelation fetchProperty(int index, AggregateFunction aggregateFunction, boolean distinct, String propertyName, String alias) {
        AssertIllegalArgument.isGe((Number)index, (Number)0, (String)"fetch entity index");
        AssertIllegalArgument.isLt((Number)index, (Number)this.entityFilterableMappingTuple.degree(), (String)"fetch entity index");
        EntitySqlRelation.EntityRelation<?> erm = this.getEntityRelation(index);
        this.queryFetchAlias.add(erm.getTableAlias());
        if (index == 0) {
            Tuple2 columnAndProperty = ClassMappingUtils.getColumnAndPropertyName((String)propertyName, erm.getClassMapping());
            alias = (String)Lang.ifEmpty((Object)alias, (Object)columnAndProperty.get1());
            this.getBuilder().addColumn(aggregateFunction, distinct, (String)columnAndProperty.get0(), (String)columnAndProperty.get1());
            JdbcPropertyMapping pm = (JdbcPropertyMapping)erm.classMapping.getPropertyMapping(propertyName);
            erm.addFetchPropertyMapping(pm.getPropertyIndexes(), pm);
        } else if (index > 0) {
            Tuple2 columnAndProperty = ClassMappingUtils.getColumnAndPropertyName((String)propertyName, erm.getClassMapping());
            erm.selectJoinOnBasicBuilder.fetch(aggregateFunction, distinct, (String)columnAndProperty.get0(), (String)columnAndProperty.get1());
            EntitySqlRelation.EntityRelation<?> ser = erm.getJoinFrom();
            for (JdbcPropertyMapping pm : erm.getClassMapping().getPropertyMappingLeafNodes()) {
                ser.addFetchPropertyMapping(ArrayUtils.addAll((int[])ser.getJoinFromPropertyIndexes(), (int[])pm.getPropertyIndexes()), pm);
            }
        }
        return this;
    }

    public boolean isReturnTuple() {
        return this.entityQueryFetchMapping.size() > 1;
    }

    public Class<?> getResultType() {
        switch (this.entityQueryFetchMapping.size()) {
            case 1: {
                return ((EntitySqlRelation.EntityRelation)this.entityFilterableMappingTuple.getOrNull0()).getClassMapping().getType();
            }
            case 2: {
                return Tuple2.class;
            }
            case 3: {
                return Tuple3.class;
            }
            case 4: {
                return Tuple4.class;
            }
            case 5: {
                return Tuple5.class;
            }
            case 6: {
                return Tuple6.class;
            }
            case 7: {
                return Tuple7.class;
            }
            case 8: {
                return Tuple8.class;
            }
            case 9: {
                return Tuple9.class;
            }
        }
        throw new SqldbHammerException("entity query fetch times must be 1-9");
    }

    public String buildSelectCountSql() {
        return this.jdbc.getDialect().getKeywords().select() + " " + this.jdbc.getDialect().getKeywords().count() + "(*) " + this.jdbc.getDialect().getKeywords().from() + " " + this.getEntityRelation(0).getClassMapping().getRepositoryName() + " " + this.getEntityRelation(0).getTableAlias();
    }

    public String buildSelectSql() {
        return this.buildSelectSql(true);
    }

    public String buildSelectSql(boolean withFrom) {
        return this.selectBuilder.setColumnAliasPrefixTableAlias(this.isReturnTuple()).build((tableName, tableAlias) -> this.queryFetchAlias.contains(tableAlias), withFrom);
    }

    public <R> R single(String sql, Serializable[] params) {
        switch (this.entityQueryFetchMapping.size()) {
            case 1: {
                return (R)this.jdbc.querySingle(sql, this.entityQueryFetchMapping.get(0).getMapper(), params);
            }
            case 2: {
                return (R)this.jdbc.querySingle(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper()), params);
            }
            case 3: {
                return (R)this.jdbc.querySingle(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper()), params);
            }
            case 4: {
                return (R)this.jdbc.querySingle(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper()), params);
            }
            case 5: {
                return (R)this.jdbc.querySingle(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper(), this.entityQueryFetchMapping.get(4).getMapper()), params);
            }
            case 6: {
                return (R)this.jdbc.querySingle(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper(), this.entityQueryFetchMapping.get(4).getMapper(), this.entityQueryFetchMapping.get(5).getMapper()), params);
            }
        }
        throw new SqldbHammerException("entity query fetch times must be 2-6");
    }

    public <R> R unique(String sql, Serializable[] params) {
        switch (this.entityQueryFetchMapping.size()) {
            case 1: {
                return (R)this.jdbc.queryUnique(sql, this.entityQueryFetchMapping.get(0).getMapper(), params);
            }
            case 2: {
                return (R)this.jdbc.queryUnique(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper()), params);
            }
            case 3: {
                return (R)this.jdbc.queryUnique(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper()), params);
            }
            case 4: {
                return (R)this.jdbc.queryUnique(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper()), params);
            }
            case 5: {
                return (R)this.jdbc.queryUnique(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper(), this.entityQueryFetchMapping.get(4).getMapper()), params);
            }
            case 6: {
                return (R)this.jdbc.queryUnique(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper(), this.entityQueryFetchMapping.get(4).getMapper(), this.entityQueryFetchMapping.get(5).getMapper()), params);
            }
        }
        throw new SqldbHammerException("entity query fetch times must be 2-6");
    }

    public <R> List<R> list(String sql, Serializable[] params) {
        switch (this.entityQueryFetchMapping.size()) {
            case 1: {
                return this.jdbc.queryList(sql, this.entityQueryFetchMapping.get(0).getMapper(), params);
            }
            case 2: {
                return this.jdbc.queryList(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper()), params);
            }
            case 3: {
                return this.jdbc.queryList(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper()), params);
            }
            case 4: {
                return this.jdbc.queryList(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper()), params);
            }
            case 5: {
                return this.jdbc.queryList(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper(), this.entityQueryFetchMapping.get(4).getMapper()), params);
            }
            case 6: {
                return this.jdbc.queryList(sql, new TupleEntityRowMapper(this.entityQueryFetchMapping.get(0).getMapper(), this.entityQueryFetchMapping.get(1).getMapper(), this.entityQueryFetchMapping.get(2).getMapper(), this.entityQueryFetchMapping.get(3).getMapper(), this.entityQueryFetchMapping.get(4).getMapper(), this.entityQueryFetchMapping.get(5).getMapper()), params);
            }
        }
        throw new SqldbHammerException("entity query fetch times must be 2-6");
    }

    @Override
    protected void initBuilder(EntitySqlRelation.EntityRelation<?> erm) {
        this.selectBuilder = new SqlSelectBasicBuilder(this.jdbc.getDialect(), erm.classMapping, erm.tableAlias);
    }

    @Override
    public SqlSelectBasicBuilder getBuilder() {
        return this.selectBuilder;
    }

    @Override
    public DslQueryConfig getConfig() {
        return (DslQueryConfig)this.conditionConfig;
    }
}

