/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.entity;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.common.tuple.Tuple7;
import cn.featherfly.common.tuple.Tuple8;
import cn.featherfly.hammer.config.cache.QueryPageResult;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.entity.AbstractMulitiEntitySqlConditionsGroupExpressionBase;
import cn.featherfly.hammer.sqldb.dsl.entity.EntitySqlQueryRelation;
import cn.featherfly.hammer.sqldb.dsl.entity.query.AbstractMulitiEntitySqlQueryConditionsGroupExpression;
import cn.featherfly.hammer.sqldb.dsl.entity.query.AbstractMulitiEntitySqlQueryConditionsGroupExpression2;
import cn.featherfly.hammer.sqldb.dsl.entity.query.AbstractMulitiEntitySqlQueryConditionsGroupExpression3;
import cn.featherfly.hammer.sqldb.dsl.entity.query.AbstractMulitiEntitySqlQueryConditionsGroupExpression4;
import cn.featherfly.hammer.sqldb.dsl.entity.query.AbstractMulitiEntitySqlQueryConditionsGroupExpression5;
import cn.featherfly.hammer.sqldb.dsl.entity.query.AbstractMulitiEntitySqlQueryConditionsGroupExpression6;
import cn.featherfly.hammer.sqldb.dsl.entity.query.AbstractMulitiEntitySqlQueryValueConditionsGroupExpression;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySqlQueryConditionGroupQuery<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitySqlQueryConditionGroupQuery.class);
    private AbstractMulitiEntitySqlConditionsGroupExpressionBase<?, ?, ?, ?, ?, ?> exp;
    private Limit limit;
    private EntitySqlQueryRelation queryRelation;
    private SqlPageFactory sqlPageFactory;
    private Function<Limit, Tuple8<String, String, List<Serializable>, Optional<Limit>, Optional<QueryPageResult>, String, Function<Object, Serializable>, Optional<Boolean>>> preparePagination;
    private Function<Limit, Tuple7<String, List<Serializable>, Optional<Limit>, Optional<QueryPageResult>, String, Function<Object, Serializable>, Optional<Boolean>>> prepareList;
    private final Cache<Object, QueryPageResult> queryPageResultCache;

    public EntitySqlQueryConditionGroupQuery(AbstractMulitiEntitySqlConditionsGroupExpressionBase<?, ?, ?, ?, ?, ?> entitySqlConditionGroupExpression, SqlPageFactory sqlPageFactory, EntitySqlQueryRelation queryRelation, Cache<Object, QueryPageResult> countResultCache) {
        this(entitySqlConditionGroupExpression, sqlPageFactory, queryRelation, countResultCache, null);
    }

    public EntitySqlQueryConditionGroupQuery(AbstractMulitiEntitySqlConditionsGroupExpressionBase<?, ?, ?, ?, ?, ?> entitySqlConditionGroupExpression, SqlPageFactory sqlPageFactory, EntitySqlQueryRelation queryRelation, Cache<Object, QueryPageResult> countResultCache, Limit limit) {
        this.limit = limit;
        this.queryRelation = queryRelation;
        this.sqlPageFactory = sqlPageFactory;
        this.queryPageResultCache = countResultCache;
        this.exp = entitySqlConditionGroupExpression;
        if (this.exp instanceof AbstractMulitiEntitySqlQueryConditionsGroupExpression) {
            this.preparePagination = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression)this.exp.getRoot())::preparePagination;
            this.prepareList = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression)this.exp.getRoot())::prepareList;
        } else if (this.exp instanceof AbstractMulitiEntitySqlQueryValueConditionsGroupExpression) {
            this.preparePagination = ((AbstractMulitiEntitySqlQueryValueConditionsGroupExpression)this.exp.getRoot())::preparePagination;
            this.prepareList = ((AbstractMulitiEntitySqlQueryValueConditionsGroupExpression)this.exp.getRoot())::prepareList;
        } else if (this.exp instanceof AbstractMulitiEntitySqlQueryConditionsGroupExpression2) {
            this.preparePagination = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression2)this.exp.getRoot())::preparePagination;
            this.prepareList = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression2)this.exp.getRoot())::prepareList;
        } else if (this.exp instanceof AbstractMulitiEntitySqlQueryConditionsGroupExpression3) {
            this.preparePagination = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression3)this.exp.getRoot())::preparePagination;
            this.prepareList = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression3)this.exp.getRoot())::prepareList;
        } else if (this.exp instanceof AbstractMulitiEntitySqlQueryConditionsGroupExpression4) {
            this.preparePagination = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression4)this.exp.getRoot())::preparePagination;
            this.prepareList = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression4)this.exp.getRoot())::prepareList;
        } else if (this.exp instanceof AbstractMulitiEntitySqlQueryConditionsGroupExpression5) {
            this.preparePagination = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression5)this.exp.getRoot())::preparePagination;
            this.prepareList = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression5)this.exp.getRoot())::prepareList;
        } else if (this.exp instanceof AbstractMulitiEntitySqlQueryConditionsGroupExpression6) {
            this.preparePagination = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression6)this.exp.getRoot())::preparePagination;
            this.prepareList = ((AbstractMulitiEntitySqlQueryConditionsGroupExpression6)this.exp.getRoot())::prepareList;
        } else {
            throw new SqldbHammerException("unknow expression type " + this.exp.getClass().getName());
        }
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public R single() {
        String sql = this.exp.getRoot().expression();
        Serializable[] params = (Serializable[])Lang.toArray(this.exp.getRoot().getParams(), Serializable.class);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.exp.getDialect(), sql, this.limit.getOffset(), this.limit.getLimit(), params);
            sql = pageQuery.getSql();
            params = pageQuery.getParams();
        }
        return this.queryRelation.single(sql, params);
    }

    public R unique() {
        String sql = this.exp.getRoot().expression();
        Serializable[] params = (Serializable[])Lang.toArray(this.exp.getRoot().getParams(), Serializable.class);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.exp.getDialect(), sql, this.limit.getOffset(), this.limit.getLimit(), params);
            sql = pageQuery.getSql();
            params = pageQuery.getParams();
        }
        return this.queryRelation.unique(sql, params);
    }

    public List<R> list() {
        return this.list(null);
    }

    public PaginationResults<R> pagination() {
        return this.pagination0(null);
    }

    public <V> V value(Class<V> type) {
        String sql = this.exp.getRoot().expression();
        Serializable[] params = (Serializable[])Lang.toArray(this.exp.getRoot().getParams(), Serializable.class);
        if (this.limit != null) {
            SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.exp.getDialect(), sql, this.limit.getOffset(), this.limit.getLimit(), params);
            sql = pageQuery.getSql();
            params = pageQuery.getParams();
        }
        return this.queryRelation.getJdbc().querySingle(sql, type, params);
    }

    public <V> List<V> list(Class<V> type) {
        return this.list0(type);
    }

    public <V> PaginationResults<V> pagination(Class<V> type) {
        return this.pagination0(type);
    }

    private <E> List<E> list0(Class<E> type) {
        Tuple7<String, List<Serializable>, Optional<Limit>, Optional<QueryPageResult>, String, Function<Object, Serializable>, Optional<Boolean>> tupleResult = this.prepareList.apply(this.limit);
        String sql = (String)tupleResult.get0();
        Limit newLimit = ((Optional)tupleResult.get2()).orElse(null);
        List paramList = (List)tupleResult.get1();
        Serializable[] params = paramList.toArray(new Serializable[paramList.size()]);
        paramList.add(0, tupleResult.get4());
        QueryPageResult queryPageResult = ((Optional)tupleResult.get3()).orElse(null);
        List<Object> list = null;
        if (newLimit != null) {
            list = this.getCacheList(queryPageResult = this.queryPageResults(queryPageResult, paramList), this.limit);
            if (list != null) {
                return list;
            }
            SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.exp.getDialect(), sql, newLimit.getOffset(), newLimit.getLimit(), params);
            sql = pageQuery.getSql();
            params = pageQuery.getParams();
        }
        list = !((Optional)tupleResult.get6()).isPresent() ? Collections.emptyList() : (type == null ? this.queryRelation.list(sql, params) : this.queryRelation.getJdbc().queryList(sql, type, params));
        if (this.queryPageResultCache != null && this.limit != null) {
            queryPageResult = this.setCacheList(list, queryPageResult, this.limit, (Function)tupleResult.get5(), type == null);
            this.queryPageResultCache.put((Object)paramList, (Object)queryPageResult);
        }
        return list;
    }

    private <E> SimplePaginationResults<E> pagination0(Class<E> type) {
        Serializable[] oraginalParams;
        Tuple8<String, String, List<Serializable>, Optional<Limit>, Optional<QueryPageResult>, String, Function<Object, Serializable>, Optional<Boolean>> tupleResult = this.preparePagination.apply(this.limit);
        String sql = (String)tupleResult.get0();
        Limit newLimit = ((Optional)tupleResult.get3()).orElse(null);
        List paramList = (List)tupleResult.get2();
        Serializable[] params = oraginalParams = paramList.toArray(new Serializable[paramList.size()]);
        paramList.add(0, tupleResult.get5());
        QueryPageResult queryPageResult = ((Optional)tupleResult.get4()).orElse(null);
        SimplePaginationResults pagination = new SimplePaginationResults(newLimit);
        List<Object> list = null;
        if (newLimit != null) {
            list = this.getCacheList(queryPageResult = this.queryPageResults(queryPageResult, paramList), this.limit);
            if (list == null) {
                SqlPageFactory.SqlPageQuery<Serializable[]> pageQuery = this.sqlPageFactory.toPage(this.exp.getDialect(), sql, newLimit.getOffset(), newLimit.getLimit(), params);
                sql = pageQuery.getSql();
                params = pageQuery.getParams();
                list = !((Optional)tupleResult.get7()).isPresent() ? Collections.emptyList() : (type == null ? this.queryRelation.list(sql, params) : this.queryRelation.getJdbc().queryList(sql, type, params));
            }
            pagination.setPageResults(list);
        } else {
            list = !((Optional)tupleResult.get7()).isPresent() ? Collections.emptyList() : this.queryRelation.list(sql, params);
            pagination.setPageResults(list);
        }
        queryPageResult = this.setCacheList(list, queryPageResult, this.limit, (Function)tupleResult.get6(), type == null);
        if (newLimit != null) {
            Long total = this.getTotal(queryPageResult, paramList);
            if (total == null) {
                total = this.queryRelation.getJdbc().queryLong((String)tupleResult.get1(), oraginalParams);
            } else {
                LOGGER.debug("pagination count result [{}] found in cache", (Object)total);
            }
            pagination.setTotal(total.longValue());
            this.setTotal(queryPageResult, paramList, pagination);
        } else {
            pagination.setTotal((long)list.size());
        }
        return pagination;
    }

    private <E> List<E> getCacheList(QueryPageResult queryPageResult, Limit limit) {
        if (this.queryRelation.getConfig().isCachePageResults() && queryPageResult != null) {
            return queryPageResult.getPageList(limit.getOffset());
        }
        return null;
    }

    private <E> QueryPageResult setCacheList(List<E> list, QueryPageResult queryPageResult, Limit limit, Function<Object, Serializable> getId, boolean entityList) {
        if (this.queryPageResultCache != null && limit != null) {
            queryPageResult = (QueryPageResult)Lang.ifNull((Object)queryPageResult, (Object)new QueryPageResult());
            QueryPageResult.PageInfo pageInfo = new QueryPageResult.PageInfo(limit);
            if (this.queryRelation.getConfig().isPagingOptimization() && !list.isEmpty() && entityList) {
                pageInfo.setFirstId((Number)getId.apply(list.get(0)));
                pageInfo.setLastId((Number)getId.apply(list.get(list.size() - 1)));
            }
            queryPageResult.addQueryPageResult(pageInfo);
            if (this.queryRelation.getConfig().isCachePageResults()) {
                queryPageResult = (QueryPageResult)Lang.ifNull((Object)queryPageResult, (Object)new QueryPageResult());
                queryPageResult.addPageList(limit.getOffset(), list);
            }
        }
        return queryPageResult;
    }

    private Long getTotal(QueryPageResult queryPageResult, List<Serializable> sqlAndParamsList) {
        if (this.queryRelation.getConfig().isCachePageCount() && (queryPageResult = this.queryPageResults(queryPageResult, sqlAndParamsList)) != null) {
            return queryPageResult.getTotal();
        }
        return null;
    }

    private <E> void setTotal(QueryPageResult queryPageResult, List<Serializable> sqlAndParamsList, SimplePaginationResults<E> pagination) {
        if (this.queryRelation.getConfig().isCachePageCount() && this.queryPageResultCache != null) {
            if (queryPageResult == null) {
                queryPageResult = new QueryPageResult(Long.valueOf(pagination.getTotal()));
            } else {
                queryPageResult.setTotal(Long.valueOf(pagination.getTotal()));
            }
            this.queryPageResultCache.put(sqlAndParamsList, (Object)queryPageResult);
        }
    }

    private QueryPageResult queryPageResults(QueryPageResult queryPageResults, List<Serializable> sqlAndParamsList) {
        if (queryPageResults == null && this.queryPageResultCache != null) {
            return (QueryPageResult)this.queryPageResultCache.get(sqlAndParamsList);
        }
        return queryPageResults;
    }
}

