/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.dsl.condition;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.FieldValueOperator;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.builder.model.SqlElement;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Str;
import cn.featherfly.common.repository.Field;
import cn.featherfly.common.repository.Params;
import cn.featherfly.common.repository.builder.BuilderException;
import cn.featherfly.common.repository.builder.BuilderExceptionCode;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.common.tuple.Tuple2;
import cn.featherfly.common.tuple.Tuples;
import cn.featherfly.hammer.config.dsl.ConditionConfig;
import cn.featherfly.hammer.expression.condition.AbstractConditionExpression;
import cn.featherfly.hammer.expression.condition.ConditionExpression;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.LogicExpression;
import cn.featherfly.hammer.expression.condition.LogicOperatorExpression;
import cn.featherfly.hammer.expression.condition.MulitiExpression;
import cn.featherfly.hammer.expression.condition.ParamedExpression;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public abstract class AbstractSqlConditionExpression<C extends ConditionExpression, L extends LogicExpression<C, L>, C2 extends ConditionConfig<C2>>
extends AbstractConditionExpression<C2>
implements ParamedExpression {
    protected L parent;
    private List<Expression> conditions = new ArrayList<Expression>();
    private Expression previousCondition;
    protected Dialect dialect;

    protected AbstractSqlConditionExpression(L parent, Dialect dialect, C2 conditionConfig) {
        super(conditionConfig);
        this.parent = parent;
        this.dialect = dialect;
    }

    public String expression() {
        Expression last;
        StringBuilder result = new StringBuilder();
        if (this.conditions.size() > 0 && (last = this.conditions.get(this.conditions.size() - 1)) instanceof LogicOperatorExpression) {
            throw new BuilderException(BuilderExceptionCode.createNoConditionBehindCode((String)((LogicOperatorExpression)last).getLogicOperator().name()));
        }
        ArrayList<String> availableConditions = new ArrayList<String>();
        ArrayList<Expression> availableExpressions = new ArrayList<Expression>();
        for (Expression expression : this.conditions) {
            Expression pre;
            String condition = expression.expression();
            if (Str.isNotBlank((String)condition)) {
                availableConditions.add(condition);
                availableExpressions.add(expression);
                continue;
            }
            if (availableExpressions.size() <= 0 || !((pre = (Expression)availableExpressions.get(availableExpressions.size() - 1)) instanceof LogicOperatorExpression)) continue;
            availableExpressions.remove(availableExpressions.size() - 1);
            availableConditions.remove(availableConditions.size() - 1);
        }
        if (availableExpressions.size() > 0) {
            if (availableExpressions.get(0) instanceof LogicOperatorExpression) {
                availableExpressions.remove(0);
                availableConditions.remove(0);
            }
            if (availableExpressions.get(availableExpressions.size() - 1) instanceof LogicOperatorExpression) {
                availableExpressions.remove(availableExpressions.size() - 1);
                availableConditions.remove(availableConditions.size() - 1);
            }
        }
        for (String condition : availableConditions) {
            BuilderUtils.link((StringBuilder)result, (String)condition);
        }
        if (result.length() > 0 && this.parent != null) {
            return " ( " + result.toString() + " ) ";
        }
        return result.toString();
    }

    public Object getParam() {
        return this.getParams();
    }

    public List<Serializable> getParams() {
        ArrayList<Serializable> params = new ArrayList<Serializable>();
        for (Expression condition : this.conditions) {
            Object param;
            if (!(condition instanceof ParamedExpression) || (param = ((ParamedExpression)condition).getParam()) == Params.ParamType.NONE) continue;
            if (param == null) {
                params.add(null);
                continue;
            }
            if (param instanceof Collection) {
                params.addAll((Collection)param);
                continue;
            }
            if (param.getClass().isArray()) {
                int length = Array.getLength(param);
                for (int i = 0; i < length; ++i) {
                    params.add((Serializable)Array.get(param, i));
                }
                continue;
            }
            params.add((Serializable)param);
        }
        return params;
    }

    public Serializable[] getParamsArray() {
        return (Serializable[])Lang.toArray(this.getParams(), Serializable.class);
    }

    public List<Expression> getExpressions() {
        return this.conditions;
    }

    public String toString() {
        return this.expression();
    }

    public Expression addCondition(Expression condition) {
        if (this.previousCondition != null && this.previousCondition.getClass().isInstance(condition)) {
            throw new BuilderException(BuilderExceptionCode.createNextToSameConditionCode((String)condition.getClass().getName()));
        }
        if (condition instanceof MulitiExpression) {
            for (Expression expression : ((MulitiExpression)condition).getExpressions()) {
                this.addCondition(expression);
            }
        } else {
            this.previousCondition = condition;
            this.conditions.add(condition);
        }
        return this;
    }

    protected <R> List<Tuple2<String, Optional<R>>> supplier(LambdaUtils.SerializedLambdaInfo info, R value, JdbcClassMapping<?> classMapping) {
        ArrayList<Tuple2<String, Optional<R>>> list = new ArrayList<Tuple2<String, Optional<R>>>();
        if (value != null) {
            JdbcPropertyMapping propertyMapping;
            String propertyName = info.getPropertyName();
            if (classMapping != null && Lang.isNotEmpty((Collection)(propertyMapping = (JdbcPropertyMapping)classMapping.getPropertyMapping(propertyName)).getPropertyMappings()) && propertyMapping.getPropertyType() == value.getClass()) {
                for (JdbcPropertyMapping pm : propertyMapping.getPropertyMappings()) {
                    Object obj = BeanUtils.getProperty(value, (String)pm.getPropertyName());
                    Optional<Object> optional = Optional.empty();
                    if (obj != null) {
                        optional = Optional.of(obj);
                    }
                    list.add(Tuples.of((Object)pm.getRepositoryFieldName(), optional));
                }
                return list;
            }
            list.add(Tuples.of((Object)propertyName, Optional.of(value)));
        }
        return list;
    }

    protected <R> List<Tuple2<String, Optional<R>>> supplier(LambdaUtils.SerializableSupplierLambdaInfo<R> info, JdbcClassMapping<?> classMapping) {
        return this.supplier(info.getSerializedLambdaInfo(), info.get(), classMapping);
    }

    protected Object getInParam(Object paramsForField, PropertyMapping<?> pm, Object value) {
        return Lang.isEmpty((Object)paramsForField) ? this.getInParam(pm, value) : SqlUtils.flatParams((Object[])new Object[]{SqlUtils.flatParamToFieldValueOperator((Object)paramsForField), this.getInParam(pm, value)});
    }

    protected Object getInParam(PropertyMapping<?> pm, Object value) {
        if (pm == null) {
            return SqlUtils.flatParamToFieldValueOperator((Object)value);
        }
        return SqlUtils.flatParamToFieldValueOperator((Object)value, (JdbcPropertyMapping)((JdbcPropertyMapping)pm));
    }

    protected Object getInParam(Object value) {
        return this.getInParam(null, value);
    }

    protected Object getInParam(Object paramsForField, Object value) {
        return Lang.isEmpty((Object)paramsForField) ? this.getInParam(null, value) : SqlUtils.flatParams((Object[])new Object[]{SqlUtils.flatParamToFieldValueOperator((Object)paramsForField), this.getInParam(null, value)});
    }

    protected <R> FieldValueOperator<R> getFieldValueOperator(PropertyMapping<?> pm, R value) {
        if (pm == null) {
            return this.getFieldValueOperator(value);
        }
        return FieldValueOperator.create((JdbcPropertyMapping)((JdbcPropertyMapping)pm), value);
    }

    protected <R> Object getFieldValueOperator(Object paramsForField, PropertyMapping<?> pm, R value) {
        return Lang.isEmpty((Object)paramsForField) ? this.getFieldValueOperator(pm, value) : SqlUtils.flatParams((Object[])new Object[]{SqlUtils.flatParamToFieldValueOperator((Object)paramsForField, (JdbcPropertyMapping)((JdbcPropertyMapping)pm)), this.getFieldValueOperator(pm, value)});
    }

    protected <R> FieldValueOperator<R> getFieldValueOperator(R value) {
        return FieldValueOperator.create(value);
    }

    protected Object getFieldValueOperator(Object paramsForField, Object value) {
        return Lang.isEmpty((Object)paramsForField) ? this.getFieldValueOperator((Serializable)value) : SqlUtils.flatParams((Object[])new Object[]{SqlUtils.flatParamToFieldValueOperator((Object)paramsForField), this.getFieldValueOperator((Serializable)value)});
    }

    protected Object prepareFieldValue(Object paramsForField, Object value) {
        return Lang.isEmpty((Object)paramsForField) ? this.prepareFieldValue(value) : SqlUtils.flatParams((Object[])new Object[]{SqlUtils.flatParamToFieldValueOperator((Object)paramsForField), this.prepareFieldValue(value)});
    }

    protected Object prepareFieldValue(Object value) {
        if (value instanceof Field || value instanceof SqlElement || value instanceof Expression) {
            return value;
        }
        return this.getFieldValueOperator((Serializable)value);
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

