/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.PropertyAccessorFactory;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.function.serializable.SerializableFunction;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.ExecutionExecutorEx;
import cn.featherfly.common.repository.IgnoreStrategy;
import cn.featherfly.common.repository.ParamedExecutionExecutorEx;
import cn.featherfly.common.repository.Repository;
import cn.featherfly.hammer.config.HammerConfig;
import cn.featherfly.hammer.dsl.entity.execute.EntityDelete;
import cn.featherfly.hammer.dsl.entity.execute.EntityUpdate;
import cn.featherfly.hammer.dsl.entity.query.EntityQueryFetch;
import cn.featherfly.hammer.dsl.repository.execute.RepositoryDelete;
import cn.featherfly.hammer.dsl.repository.execute.RepositoryUpdate;
import cn.featherfly.hammer.dsl.repository.query.RepositoryQueryFetch;
import cn.featherfly.hammer.sqldb.SqldbHammer;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.dsl.execute.SqlDeleter;
import cn.featherfly.hammer.sqldb.dsl.execute.SqlUpdater;
import cn.featherfly.hammer.sqldb.dsl.query.SqlQuery;
import cn.featherfly.hammer.sqldb.dsl.repository.query.RepositorySqlQueryFetch;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.JdbcExecutor;
import cn.featherfly.hammer.sqldb.jdbc.SimpleSqlPageFactory;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import cn.featherfly.hammer.sqldb.jdbc.operate.DeleteOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.GetOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.InsertOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.MergeOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.UpdateFetchOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.UpdateOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.UpsertOperate;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.SqlTplExecutor;
import cn.featherfly.hammer.sqldb.tpl.freemarker.SqldbFreemarkerTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.freemarker.SqldbFreemarkerTemplateProcessEnv;
import cn.featherfly.hammer.sqldb.tpl.transverter.FuzzyQueryTransverter;
import cn.featherfly.hammer.tpl.ArrayParamedExecutionExecutorEx;
import cn.featherfly.hammer.tpl.AutoRegistTransverter;
import cn.featherfly.hammer.tpl.MapParamedExecutionExecutorEx;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplExecuteId;
import cn.featherfly.hammer.tpl.TplExecuteIdBuilder;
import cn.featherfly.hammer.tpl.TplExecuteIdBuilderImpl;
import cn.featherfly.hammer.tpl.TplExecutor;
import cn.featherfly.hammer.tpl.TransverterManager;
import cn.featherfly.hammer.tpl.directive.TemplateDirective;
import cn.featherfly.hammer.tpl.method.TemplateMethod;
import cn.featherfly.validation.metadata.ConstraintViolation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public class SqldbHammerImpl
implements SqldbHammer {
    private final Jdbc jdbc;
    private final JdbcExecutor jdbcExecutor;
    private final JdbcMappingFactory mappingFactory;
    private final HammerConfig hammerConfig;
    private final SqlTplExecutor sqlTplExecutor;
    private final Map<Class<?>, InsertOperate<?>> insertOperates = new HashMap();
    private final Map<Class<?>, UpdateOperate<?>> updateOperates = new HashMap();
    private final Map<Class<?>, UpdateFetchOperate<?>> updateFetchOperates = new HashMap();
    private final Map<Class<?>, UpsertOperate<?>> upsertOperates = new HashMap();
    private final Map<Class<?>, GetOperate<?>> getOperates = new HashMap();
    private final Map<Class<?>, DeleteOperate<?>> deleteOperates = new HashMap();
    private final Map<Class<?>, MergeOperate<?>> mergeOperates = new HashMap();
    private final SqlQuery query;
    private final SqlUpdater updater;
    private final SqlDeleter deleter;
    private final PropertyAccessorFactory propertyAccessorFactory;

    private SqldbHammerImpl(Builder builder) {
        this.jdbc = builder.jdbc;
        this.mappingFactory = builder.mappingFactory;
        this.hammerConfig = builder.hammerConfig;
        this.propertyAccessorFactory = builder.propertyAccessorFactory;
        this.jdbcExecutor = new JdbcExecutor(this.jdbc, this.propertyAccessorFactory, builder.sqlPageFacotry);
        this.sqlTplExecutor = new SqlTplExecutor(this.hammerConfig, builder.configFactory, builder.templateEngine, this.jdbc, this.mappingFactory, builder.sqlPageFacotry, builder.transverterManager);
        this.query = new SqlQuery(this.jdbc, this.mappingFactory, this.sqlTplExecutor.getSqlPageFactory(), this.hammerConfig);
        this.updater = new SqlUpdater(this.jdbc, this.mappingFactory, this.hammerConfig.getDslConfig().getUpdateConfig());
        this.deleter = new SqlDeleter(this.jdbc, this.mappingFactory, this.hammerConfig.getDslConfig().getDeleteConfig());
    }

    public <E> int save(E entity) {
        if (entity == null) {
            return 0;
        }
        InsertOperate<E> insert = this.insertOperate(entity);
        this.validate(entity);
        return insert.execute(entity);
    }

    public <E> int[] save(List<E> entities) {
        return this.save(entities, this.hammerConfig.getEntityConfig().getInsert().getBatchSize());
    }

    public <E> int[] save(List<E> entities, int batchSize) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        InsertOperate<E> insert = null;
        for (E entity : entities) {
            if (insert == null) {
                insert = this.insertOperate(entity);
            }
            this.validate(entity);
        }
        if (insert == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return insert.executeBatch(entities, batchSize);
    }

    public <E> int saveOrUpdate(E entity) {
        return this.saveOrUpdate(entity, e -> {
            GetOperate<?> get = this.getOperate(e.getClass());
            List<Serializable> ids = get.getIds(e);
            if (ids.size() == 1) {
                Serializable id = ids.get(0);
                return id != null;
            }
            if (ids.size() > 1) {
                boolean insertable = false;
                for (Serializable id : ids) {
                    if (id != null) continue;
                    insertable = true;
                }
                return !insertable;
            }
            throw new SqldbHammerException("no pk mapping");
        });
    }

    public <E> int saveOrUpdate(E entity, Predicate<E> updatable) {
        if (entity == null) {
            return 0;
        }
        if (this.jdbc.getDialect().supportUpsert()) {
            UpsertOperate<E> upsert = this.upsertOperate(entity);
            return upsert.execute(entity);
        }
        if (updatable.test(entity)) {
            return this.update(entity);
        }
        return this.save(entity);
    }

    public <E> int update(E entity) {
        if (entity == null) {
            return 0;
        }
        UpdateOperate<E> update = this.updateOperate(entity);
        this.validate(entity);
        return update.execute(entity);
    }

    public <E> int update(E entity, IgnoreStrategy ignoreStrategy) {
        switch (ignoreStrategy) {
            case EMPTY: {
                return this.merge(entity);
            }
            case NULL: {
                return this.merge(entity, true);
            }
        }
        return this.update(entity);
    }

    public <E> int[] update(E ... entities) {
        return this.update(entities, this.hammerConfig.getEntityConfig().getUpdate().getBatchSize());
    }

    public <E> int[] update(E[] entities, int batchSize) {
        if (Lang.isEmpty((Object[])entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return this.update(Lang.list((Object[])entities), batchSize);
    }

    public <E> int[] update(List<E> entities) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return this.update(entities, this.hammerConfig.getEntityConfig().getUpdate().getBatchSize());
    }

    public <E> int[] update(List<E> entities, int batchSize) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        Class<?> type = entities.get(0).getClass();
        UpdateOperate<?> update = this.updateOperate(type);
        for (E entity : entities) {
            this.validate(entity);
        }
        return update.executeBatch(entities, batchSize);
    }

    public <E> int[] update(List<E> entities, IgnoreStrategy ignoreStrategy) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int[] results = new int[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            results[i] = this.update(entities.get(i), ignoreStrategy);
        }
        return results;
    }

    private <E> int merge(E entity, boolean onlyNull) {
        if (entity == null) {
            return 0;
        }
        MergeOperate<E> merge = this.mergeOperate(entity);
        this.validate(entity);
        return merge.execute(entity, onlyNull);
    }

    public <E> int merge(E entity) {
        return this.merge(entity, false);
    }

    public <E> int[] merge(E ... entities) {
        int[] results = new int[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            results[i] = this.merge(entities[i]);
        }
        return results;
    }

    public <E> int[] merge(List<E> entities) {
        int[] results = new int[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            results[i] = this.merge(entities.get(i));
        }
        return results;
    }

    public <E> int delete(Serializable id, @Nonnull Class<E> entityType) {
        if (id == null || entityType == null) {
            return 0;
        }
        DeleteOperate<E> delete = this.deleteOperate(entityType);
        return delete.delete(id);
    }

    public <E> int[] delete(Serializable[] ids, @Nonnull Class<E> entityType) {
        if (Lang.isEmpty((Object[])ids)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        DeleteOperate<E> delete = this.deleteOperate(entityType);
        return delete.deleteBatch(ids);
    }

    public <E, ID extends Serializable> int[] delete(List<ID> ids, @Nonnull Class<E> entityType) {
        if (Lang.isEmpty(ids)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        DeleteOperate<E> delete = this.deleteOperate(entityType);
        return delete.deleteBatch(ids);
    }

    public <E> int delete(E entity) {
        if (entity == null) {
            return 0;
        }
        DeleteOperate<E> delete = this.deleteOperate(entity);
        return delete.execute(entity);
    }

    public <E> int[] delete(List<E> entities) {
        if (Lang.isEmpty(entities)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        DeleteOperate<List<E>> delete = this.deleteOperate((E)entities);
        if (delete == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return delete.executeBatch(entities);
    }

    public <E> E get(Serializable id, Class<E> type) {
        if (id == null || type == null) {
            return null;
        }
        GetOperate<E> get = this.getOperate(type);
        return get.execute(id);
    }

    public <E> List<E> get(Class<E> type, Serializable ... ids) {
        ArrayList<E> list = new ArrayList<E>();
        if (Lang.isEmpty((Object[])ids)) {
            return list;
        }
        for (Serializable id : ids) {
            list.add(this.get(id, type));
        }
        return list;
    }

    public <E> List<E> get(Class<E> type, List<Serializable> ids) {
        ArrayList<E> list = new ArrayList<E>();
        if (Lang.isEmpty(ids)) {
            return list;
        }
        for (Serializable id : ids) {
            list.add(this.get(id, type));
        }
        return list;
    }

    public <E, R> E get(Serializable id, Class<E> type, SerializableFunction<E, R> fetchProperty) {
        E entity = this.get(id, type);
        if (entity == null) {
            return null;
        }
        BeanProperty bp = BeanDescriptor.getBeanDescriptor(type).getBeanProperty(fetchProperty);
        Object fetchObj = this.get(bp.getValue(entity));
        bp.setValue(entity, fetchObj);
        return entity;
    }

    public <E> E get(E entity) {
        if (entity == null) {
            return null;
        }
        GetOperate<?> get = this.getOperate(entity.getClass());
        return (E)get.get(entity);
    }

    public <E> E updateFetch(Serializable id, Class<E> type, UnaryOperator<E> updateOperator) {
        if (Lang.isEmpty((Object)id)) {
            return null;
        }
        return (E)this.updateFetchOperate(type).execute((E)id, updateOperator);
    }

    public <E> E updateFetch(E entity, UnaryOperator<E> updateOperator) {
        if (entity == null) {
            return null;
        }
        return this.updateFetchOperate(entity).execute(entity, updateOperator);
    }

    public RepositoryQueryFetch query(String repository) {
        return this.query.find(repository);
    }

    public RepositoryQueryFetch query(Repository repository) {
        return this.query.find(repository);
    }

    @Override
    public RepositorySqlQueryFetch query(Table table) {
        return this.query.find((Repository)table);
    }

    public <E> EntityQueryFetch<E> query(Class<E> entityType) {
        return this.query.find(entityType);
    }

    public <E> EntityUpdate<E> update(Class<E> entityType) {
        return this.updater.update(entityType);
    }

    public RepositoryUpdate update(String repository) {
        return this.updater.update(repository);
    }

    public RepositoryUpdate update(Repository repository) {
        return this.updater.update(repository);
    }

    @Override
    public RepositoryUpdate update(Table table) {
        return this.updater.update(table);
    }

    public RepositoryDelete delete(String repository) {
        return this.deleter.delete(repository);
    }

    public RepositoryDelete delete(Repository repository) {
        return this.deleter.delete(repository);
    }

    @Override
    public RepositoryDelete delete(Table table) {
        return this.deleter.delete(table);
    }

    public <E> EntityDelete<E> delete(Class<E> entityType) {
        return this.deleter.delete(entityType);
    }

    private <E> void validate(E entity) {
        Set cons;
        if (this.hammerConfig.getValidator() != null && Lang.isNotEmpty((Collection)(cons = this.hammerConfig.getValidator().validate(entity, new Class[0])))) {
            StringBuilder errorMessage = new StringBuilder();
            for (ConstraintViolation constraintViolation : cons) {
                errorMessage.append(constraintViolation.getMessage()).append(",");
            }
            throw new SqldbHammerException(errorMessage.toString());
        }
    }

    @Override
    public Jdbc getJdbc() {
        return this.jdbc;
    }

    @Override
    public JdbcMappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    private <E> MergeOperate<E> mergeOperate(E entity) {
        return this.mergeOperate(entity.getClass());
    }

    private <E> MergeOperate<E> mergeOperate(Class<E> entityType) {
        return this.mergeOperates.computeIfAbsent(entityType, type -> new MergeOperate(this.jdbc, this.mappingFactory.getClassMapping(entityType), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata(), this.propertyAccessorFactory.create(entityType)));
    }

    private <E> UpdateOperate<E> updateOperate(E entity) {
        return this.updateOperate(entity.getClass());
    }

    private <E> UpdateOperate<E> updateOperate(Class<E> entityType) {
        return this.updateOperates.computeIfAbsent(entityType, type -> new UpdateOperate(this.jdbc, this.mappingFactory.getClassMapping(entityType), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }

    private <E> UpdateFetchOperate<E> updateFetchOperate(E entity) {
        return this.updateFetchOperate(entity.getClass());
    }

    private <E> UpdateFetchOperate<E> updateFetchOperate(Class<E> entityType) {
        return this.updateFetchOperates.computeIfAbsent(entityType, type -> new UpdateFetchOperate(this.jdbc, this.mappingFactory.getClassMapping(entityType), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata(), this.getOperate(entityType), this.updateOperate(entityType), key -> {}, key -> {}));
    }

    private <E> InsertOperate<E> insertOperate(E entity) {
        return this.insertOperate(entity.getClass());
    }

    private <E> InsertOperate<E> insertOperate(Class<E> entityType) {
        return this.insertOperates.computeIfAbsent(entityType, type -> new InsertOperate(this.jdbc, this.mappingFactory.getClassMapping(entityType), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }

    private <E> UpsertOperate<E> upsertOperate(E entity) {
        return this.upsertOperate(entity.getClass());
    }

    private <E> UpsertOperate<E> upsertOperate(Class<E> entityType) {
        return this.upsertOperates.computeIfAbsent(entityType, type -> new UpsertOperate(this.jdbc, this.mappingFactory.getClassMapping(entityType), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }

    private <E> DeleteOperate<E> deleteOperate(Collection<E> entities) {
        Object e = Lang.ifNotNullFirst(entities);
        if (e == null) {
            return null;
        }
        return this.deleteOperate(e);
    }

    private <E> DeleteOperate<E> deleteOperate(E entity) {
        return this.deleteOperate(entity.getClass());
    }

    private <E> DeleteOperate<E> deleteOperate(Class<E> entityType) {
        return this.deleteOperates.computeIfAbsent(entityType, type -> new DeleteOperate(this.jdbc, this.mappingFactory.getClassMapping(entityType), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata()));
    }

    private <E> GetOperate<E> getOperate(Class<E> entityType) {
        return this.getOperates.computeIfAbsent(entityType, type -> new GetOperate(this.jdbc, this.mappingFactory.getClassMapping(entityType), this.mappingFactory.getSqlTypeMappingManager(), this.mappingFactory.getMetadata(), this.propertyAccessorFactory.create(entityType)));
    }

    public ParamedExecutionExecutorEx dml(String execution, Map<String, Serializable> params) {
        return new MapParamedExecutionExecutorEx((ExecutionExecutorEx)this.jdbcExecutor, (Object)execution, params);
    }

    public ParamedExecutionExecutorEx dml(String execution, Serializable ... params) {
        return new ArrayParamedExecutionExecutorEx((ExecutionExecutorEx)this.jdbcExecutor, (Object)execution, params);
    }

    public TplExecutor template() {
        return this.sqlTplExecutor;
    }

    public ParamedExecutionExecutorEx template(String templateId, Map<String, Serializable> params) {
        return this.template(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(templateId), params);
    }

    public ParamedExecutionExecutorEx template(String templateId, Serializable ... params) {
        return this.template(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser().parse(templateId), params);
    }

    public ParamedExecutionExecutorEx template(Function<TplExecuteIdBuilder, TplExecuteId> tplExecuteIdBuilder, Map<String, Serializable> params) {
        return this.template(tplExecuteIdBuilder.apply((TplExecuteIdBuilder)new TplExecuteIdBuilderImpl(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser())), params);
    }

    public ParamedExecutionExecutorEx template(Function<TplExecuteIdBuilder, TplExecuteId> tplExecuteIdBuilder, Serializable ... params) {
        return this.template(tplExecuteIdBuilder.apply((TplExecuteIdBuilder)new TplExecuteIdBuilderImpl(this.hammerConfig.getTemplateConfig().getTplExecuteIdParser())), params);
    }

    public ParamedExecutionExecutorEx template(TplExecuteId tplExecuteId, Map<String, Serializable> params) {
        return new MapParamedExecutionExecutorEx((ExecutionExecutorEx)this.sqlTplExecutor, (Object)tplExecuteId, params);
    }

    public ParamedExecutionExecutorEx template(TplExecuteId tplExecuteId, Serializable ... params) {
        return new ArrayParamedExecutionExecutorEx((ExecutionExecutorEx)this.sqlTplExecutor, (Object)tplExecuteId, params);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, PropertyAccessorFactory propertyAccessorFactory, HammerConfig hammerConfig) {
        return new Builder(jdbc, mappingFactory, configFactory, propertyAccessorFactory, hammerConfig);
    }

    public static final class Builder {
        private Jdbc jdbc;
        private JdbcMappingFactory mappingFactory;
        private TplConfigFactory configFactory;
        private SqlDbTemplateEngine<? extends TemplateDirective, ? extends TemplateMethod> templateEngine;
        private SqlPageFactory sqlPageFacotry;
        private TransverterManager transverterManager;
        private PropertyAccessorFactory propertyAccessorFactory;
        private HammerConfig hammerConfig;

        private Builder() {
        }

        private Builder(Jdbc jdbc, JdbcMappingFactory mappingFactory, TplConfigFactory configFactory, PropertyAccessorFactory propertyAccessorFactory, HammerConfig hammerConfig) {
            this.jdbc = jdbc;
            this.mappingFactory = mappingFactory;
            this.configFactory = configFactory;
            this.propertyAccessorFactory = propertyAccessorFactory;
            this.hammerConfig = hammerConfig;
        }

        public Builder setJdbc(Jdbc jdbc) {
            this.jdbc = jdbc;
            return this;
        }

        public Builder setMappingFactory(JdbcMappingFactory mappingFactory) {
            this.mappingFactory = mappingFactory;
            return this;
        }

        public Builder setHammerConfig(HammerConfig hammerConfig) {
            this.hammerConfig = hammerConfig;
            return this;
        }

        public Builder setPropertyAccessorFactory(PropertyAccessorFactory propertyAccessorFactory) {
            this.propertyAccessorFactory = propertyAccessorFactory;
            return this;
        }

        public Builder setConfigFactory(TplConfigFactory configFactory) {
            this.configFactory = configFactory;
            return this;
        }

        public Builder setTemplateEngine(SqlDbTemplateEngine<? extends TemplateDirective, ? extends TemplateMethod> templateEngine) {
            this.templateEngine = templateEngine;
            return this;
        }

        public Builder setSqlPageFacotry(SqlPageFactory sqlPageFacotry) {
            this.sqlPageFacotry = sqlPageFacotry;
            return this;
        }

        public Builder setTransverterManager(TransverterManager transverterManager) {
            this.transverterManager = transverterManager;
            return this;
        }

        public SqldbHammerImpl build() {
            if (this.templateEngine == null) {
                SqldbFreemarkerTemplateProcessEnv sharedTemplateProcessEnv = new SqldbFreemarkerTemplateProcessEnv(true);
                sharedTemplateProcessEnv.setConfigFactory(this.configFactory);
                sharedTemplateProcessEnv.setMappingFactory(this.mappingFactory);
                sharedTemplateProcessEnv.setTemplateConfig(this.hammerConfig.getTemplateConfig());
                this.templateEngine = new SqldbFreemarkerTemplateEngine(this.configFactory, this.hammerConfig.getTemplateConfig(), sharedTemplateProcessEnv.createDirectives(), sharedTemplateProcessEnv.createMethods());
            }
            if (this.sqlPageFacotry == null) {
                this.sqlPageFacotry = new SimpleSqlPageFactory();
            }
            if (this.transverterManager == null) {
                this.transverterManager = new TransverterManager(new AutoRegistTransverter[]{new FuzzyQueryTransverter()});
            }
            return new SqldbHammerImpl(this);
        }
    }
}

