/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl.transverter;

import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.operator.ComparisonOperator;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.tpl.AutoRegistTransverter;
import java.util.HashSet;
import java.util.Set;

public class FuzzyQueryTransverter
implements AutoRegistTransverter {
    private boolean upperCase;
    private final Set<String> supports = new HashSet<String>();

    public FuzzyQueryTransverter() {
        this(true);
    }

    public FuzzyQueryTransverter(boolean upperCase) {
        this.upperCase = upperCase;
        if (upperCase) {
            CollectionUtils.addAll(this.supports, (Object[])new String[]{ComparisonOperator.CO.name(), ComparisonOperator.SW.name(), ComparisonOperator.EW.name()});
        } else {
            CollectionUtils.addAll(this.supports, (Object[])new String[]{ComparisonOperator.CO.name().toLowerCase(), ComparisonOperator.SW.name().toLowerCase(), ComparisonOperator.EW.name().toLowerCase()});
        }
    }

    public Set<String> supportOperators() {
        return this.supports;
    }

    public Object transvert(String operator, Object value) {
        if (ComparisonOperator.CO.name().equals(operator)) {
            return "%" + value + "%";
        }
        if (ComparisonOperator.SW.name().equals(operator)) {
            return value + "%";
        }
        if (ComparisonOperator.EW.name().equals(operator)) {
            return "%" + value;
        }
        throw new SqldbHammerException(Strings.format((String)"{0} can not transvert value with operator {1}", (Object[])new Object[]{this.getClass().getName(), operator}));
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }
}

