/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.tpl;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.common.structure.page.SimplePaginationResults;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.SqlPageFactory;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateEngine;
import cn.featherfly.hammer.sqldb.tpl.SqlDbTemplateProcessEnv;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplExecuteConfig;
import cn.featherfly.hammer.tpl.TplExecuteId;
import cn.featherfly.hammer.tpl.TplExecuteIdFileImpl;
import cn.featherfly.hammer.tpl.TplExecutor;
import cn.featherfly.hammer.tpl.Transverter;
import cn.featherfly.hammer.tpl.TransverterManager;
import cn.featherfly.hammer.tpl.directive.TemplateDirective;
import cn.featherfly.hammer.tpl.method.TemplateMethod;
import cn.featherfly.hammer.tpl.supports.ConditionParamsManager;
import cn.featherfly.hammer.tpl.supports.PropertiesMappingManager;
import com.speedment.common.tuple.Tuple;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuple3;
import com.speedment.common.tuple.Tuple4;
import com.speedment.common.tuple.Tuple5;
import com.speedment.common.tuple.Tuple6;
import com.speedment.common.tuple.Tuples;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTplExecutor
implements TplExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TplConfigFactory configFactory;
    private Jdbc jdbc;
    private JdbcMappingFactory mappingFactory;
    private SqlDbTemplateEngine<TemplateDirective, TemplateMethod> templateEngine;
    private SqlPageFactory sqlPageFactory;
    private TransverterManager transverterManager;

    public SqlTplExecutor(@Nonnull TplConfigFactory configFactory, @Nonnull SqlDbTemplateEngine templateEngine, @Nonnull Jdbc jdbc, @Nonnull JdbcMappingFactory mappingFactory, SqlPageFactory sqlPageFactory, TransverterManager transverterManager) {
        this.configFactory = configFactory;
        this.jdbc = jdbc;
        this.mappingFactory = mappingFactory;
        this.templateEngine = templateEngine;
        this.sqlPageFactory = sqlPageFactory;
        this.transverterManager = transverterManager;
    }

    public int execute(String tplExecuteId, Map<String, Object> params) {
        return this.execute((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public int execute(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> queryExecution = this.getQueryExecution(tplExecuteId, params, Integer.class);
        String sql = (String)queryExecution.get0();
        ConditionParamsManager manager = (ConditionParamsManager)queryExecution.get2();
        return this.jdbc.update(sql, this.getEffectiveParamMap(params, manager));
    }

    public Map<String, Object> single(String tplExecuteId, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public Map<String, Object> single(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        return this.jdbc.querySingle(sql, this.getEffectiveParamMap(params, manager));
    }

    public <E> E single(String tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params);
    }

    public <E> E single(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType);
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        return this.jdbc.querySingle(sql, entityType, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> Tuple2<R1, R2> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, params);
    }

    public <R1, R2> Tuple2<R1, R2> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.querySingle(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> Tuple2<R1, R2> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, prefixes, params);
    }

    public <R1, R2> Tuple2<R1, R2> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.querySingle(sql, entityType1, entityType2, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> Tuple3<R1, R2, R3> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> Tuple4<R1, R2, R3, R4> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params);
    }

    public <R1, R2, R3, R4, R5> Tuple5<R1, R2, R3, R4, R5> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + "."), (Object)(propManager.getValue(5).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.single((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> Tuple6<R1, R2, R3, R4, R5, R6> single(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.querySingle(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.query(sql, this.getEffectiveParamMap(params, manager));
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.query(sql, entityType, this.getEffectiveParamMap(params, manager));
    }

    public List<Map<String, Object>> list(String tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params, offset, limit);
    }

    public List<Map<String, Object>> list(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, params, offset, limit).get0();
    }

    public <E> List<E> list(String tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params, offset, limit);
    }

    public <E> List<E> list(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType, params, offset, limit).get0();
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, params);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.query(sql, entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, null, params, offset, limit).get0();
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, prefixes, params);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.query(sql, entityType1, entityType2, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2> List<Tuple2<R1, R2>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, params);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.query(sql, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, params, offset, limit);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, null, params, offset, limit).get0();
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.query(sql, entityType1, entityType2, entityType3, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> List<Tuple3<R1, R2, R3>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.query(sql, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.query(sql, entityType1, entityType2, entityType3, entityType4, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> List<Tuple4<R1, R2, R3, R4>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.query(sql, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.query(sql, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> List<Tuple5<R1, R2, R3, R4, R5>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        PropertiesMappingManager propManager = (PropertiesMappingManager)tuple4.get3();
        return this.jdbc.query(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0) + "."), (Object)(propManager.getValue(1) + "."), (Object)(propManager.getValue(2) + "."), (Object)(propManager.getValue(3) + "."), (Object)(propManager.getValue(4) + "."), (Object)(propManager.getValue(5) + ".")), this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, null, params, offset, limit).get0();
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.list((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.query(sql, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, this.getEffectiveParamMap(params, manager));
    }

    public <R1, R2, R3, R4, R5, R6> List<Tuple6<R1, R2, R3, R4, R5, R6>> list(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return (List)this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit).get0();
    }

    public PaginationResults<Map<String, Object>> pagination(String tplExecuteId, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params, offset, limit);
    }

    public PaginationResults<Map<String, Object>> pagination(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Map<String, Object>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> listTuple = this.findList(tplExecuteId, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(Integer.valueOf(this.count(tplExecuteId, (String)listTuple.get1(), params, (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2())));
        return pagination;
    }

    public <E> PaginationResults<E> pagination(String tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType, params, offset, limit);
    }

    public <E> PaginationResults<E> pagination(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<E>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> listTuple = this.findList(tplExecuteId, entityType, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(Integer.valueOf(this.count(tplExecuteId, (String)listTuple.get1(), params, (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2())));
        return pagination;
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Map<String, Object> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, (Tuple2<String, String>)((Tuple2)null), params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, prefixes, params, offset, limit);
    }

    public <R1, R2> PaginationResults<Tuple2<R1, R2>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple2<R1, R2>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(Integer.valueOf(this.count(tplExecuteId, (String)listTuple.get1(), params, (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2())));
        return pagination;
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Map<String, Object> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, entityType3, (Tuple3<String, String, String>)((Tuple3)null), params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, prefixes, params, offset, limit);
    }

    public <R1, R2, R3> PaginationResults<Tuple3<R1, R2, R3>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple3<R1, R2, R3>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, entityType3, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(Integer.valueOf(this.count(tplExecuteId, (String)listTuple.get1(), params, (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2())));
        return pagination;
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Map<String, Object> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)((Tuple4)null), params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4> PaginationResults<Tuple4<R1, R2, R3, R4>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple4<R1, R2, R3, R4>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(Integer.valueOf(this.count(tplExecuteId, (String)listTuple.get1(), params, (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2())));
        return pagination;
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Map<String, Object> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)((Tuple5)null), params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5> PaginationResults<Tuple5<R1, R2, R3, R4, R5>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple5<R1, R2, R3, R4, R5>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(Integer.valueOf(this.count(tplExecuteId, (String)listTuple.get1(), params, (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2())));
        return pagination;
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Map<String, Object> params, int offset, int limit) {
        return this.pagination(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)((Tuple6)null), params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(String tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        return this.pagination((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
    }

    public <R1, R2, R3, R4, R5, R6> PaginationResults<Tuple6<R1, R2, R3, R4, R5, R6>> pagination(TplExecuteId tplExecuteId, Class<R1> entityType1, Class<R2> entityType2, Class<R3> entityType3, Class<R4> entityType4, Class<R5> entityType5, Class<R6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        SimplePaginationResults pagination = new SimplePaginationResults(offset, limit);
        Tuple5<List<Tuple6<R1, R2, R3, R4, R5, R6>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> listTuple = this.findList(tplExecuteId, entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, params, offset, limit);
        pagination.setPageResults((List)listTuple.get0());
        pagination.setTotal(Integer.valueOf(this.count(tplExecuteId, (String)listTuple.get1(), params, (Map)listTuple.get4(), (ConditionParamsManager)listTuple.get3(), (TplExecuteConfig)listTuple.get2())));
        return pagination;
    }

    public <E> E value(String tplExecuteId, Class<E> valueType, Map<String, Object> params) {
        return this.value((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), valueType, params);
    }

    public <E> E value(TplExecuteId tplExecuteId, Class<E> valueType, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, valueType);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryValue(sql, valueType, this.getEffectiveParamMap(params, manager));
    }

    public int intValue(String tplExecuteId, Map<String, Object> params) {
        return this.intValue((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public int intValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, Integer.TYPE);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryInt(sql, this.getEffectiveParamMap(params, manager));
    }

    public long longValue(String tplExecuteId, Map<String, Object> params) {
        return this.longValue((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public long longValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, Long.TYPE);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryLong(sql, this.getEffectiveParamMap(params, manager));
    }

    public double doubleValue(String tplExecuteId, Map<String, Object> params) {
        return this.doubleValue((TplExecuteId)new TplExecuteIdFileImpl(tplExecuteId), params);
    }

    public double doubleValue(TplExecuteId tplExecuteId, Map<String, Object> params) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, Double.TYPE);
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        return this.jdbc.queryDouble(sql, this.getEffectiveParamMap(params, manager));
    }

    public <N extends Number> N number(String tplExecuteId, Class<N> numberType, Map<String, Object> params) {
        return (N)((Number)this.value(tplExecuteId, numberType, params));
    }

    public <N extends Number> N number(TplExecuteId tplExecuteId, Class<N> numberType, Map<String, Object> params) {
        return (N)((Number)this.value(tplExecuteId, numberType, params));
    }

    public Integer numberInt(String tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Integer.class, params);
    }

    public Integer numberInt(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Integer.class, params);
    }

    public Long numberLong(String tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Long.class, params);
    }

    public Long numberLong(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Long.class, params);
    }

    public Double numberDouble(String tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Double.class, params);
    }

    public Double numberDouble(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, Double.class, params);
    }

    public BigDecimal numberBigDecimal(String tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, BigDecimal.class, params);
    }

    public BigDecimal numberBigDecimal(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.number(tplExecuteId, BigDecimal.class, params);
    }

    public String string(String tplExecuteId, Map<String, Object> params) {
        return this.value(tplExecuteId, String.class, params);
    }

    public String string(TplExecuteId tplExecuteId, Map<String, Object> params) {
        return this.value(tplExecuteId, String.class, params);
    }

    private Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> getQueryExecution(TplExecuteId tplExecuteId, Map<String, Object> params, Class<?> ... resultTypes) {
        TplExecuteConfig config = this.configFactory.getConfig(tplExecuteId);
        Tuple3<String, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getExecution(tplExecuteId.getId(), config.getContent(), params, resultTypes);
        this.logger.debug("tplExecuteId -> {} \nexecuteQuerySql -> {} \nqueryTemplate -> {}", new Object[]{tplExecuteId, tuple3.get0(), config.getContent()});
        return Tuples.of((Object)tuple3.get0(), (Object)config, (Object)tuple3.get1(), (Object)tuple3.get2());
    }

    private Tuple2<String, ConditionParamsManager> getCountExecution(TplExecuteId tplExecuteId, Map<String, Object> params, TplExecuteConfig config) {
        String templateName = tplExecuteId.getId() + ".count";
        Tuple3<String, ConditionParamsManager, PropertiesMappingManager> result = this.getExecution(templateName, config.getCount(), params, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.logger.debug("tplExecuteId -> {}  \nexecuteCountSql -> {}  \ncountTemplate -> {}", new Object[]{tplExecuteId, result.get0(), config.getCount()});
        return Tuples.of((Object)result.get0(), (Object)result.get1());
    }

    private Tuple3<String, ConditionParamsManager, PropertiesMappingManager> getExecution(String templateName, String sql, Map<String, Object> params, Class<?> ... resultTypes) {
        this.logger.debug("execute template name : {}", (Object)templateName);
        ConditionParamsManager conditionParamsManager = new ConditionParamsManager();
        PropertiesMappingManager propertiesMappingManager = new PropertiesMappingManager();
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.putAll(params);
        SqlDbTemplateProcessEnv<TemplateDirective, TemplateMethod> templateProcessEnv = this.createTemplateProcessEnv(conditionParamsManager, propertiesMappingManager, resultTypes);
        String result = this.templateEngine.process(templateName, sql, params, templateProcessEnv);
        return Tuples.of((Object)result, (Object)conditionParamsManager, (Object)propertiesMappingManager);
    }

    private SqlDbTemplateProcessEnv<TemplateDirective, TemplateMethod> createTemplateProcessEnv(ConditionParamsManager conditionParamsManager, PropertiesMappingManager propertiesMappingManager, Class<?> ... resultTypes) {
        SqlDbTemplateProcessEnv env = (SqlDbTemplateProcessEnv)this.templateEngine.createTemplateProcessEnv();
        env.setConfigFactory(this.configFactory);
        env.setDialect(this.jdbc.getDialect());
        env.setConditionParamsManager(conditionParamsManager);
        env.setPropertiesMappingManager(propertiesMappingManager);
        env.setMappingFactory(this.mappingFactory);
        env.setResultTypes(resultTypes);
        return env;
    }

    private Tuple5<List<Map<String, Object>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> findList(TplExecuteId tplExecuteId, Map<String, Object> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple4 = this.getQueryExecution(tplExecuteId, params, ArrayUtils.EMPTY_CLASS_ARRAY);
        List<Map<String, Object>> list = null;
        String sql = (String)tuple4.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple4.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Object>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        list = this.jdbc.query(sqlPageQuery.getSql(), sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple4.get1(), (Object)manager, params);
    }

    private <E> Tuple5<List<E>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> findList(TplExecuteId tplExecuteId, Class<E> entityType, Map<String, Object> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType);
        List<E> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Object>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        list = this.jdbc.query(sqlPageQuery.getSql(), entityType, sqlPageQuery.getParams());
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, params);
    }

    private <E1, E2> Tuple5<List<Tuple2<E1, E2>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Tuple2<String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple2<E1, E2>> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Object>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple3.get3();
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, (Tuple2<String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + ".")), sqlPageQuery.getParams());
        } else {
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, prefixes, sqlPageQuery.getParams());
        }
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, params);
    }

    private <E1, E2, E3> Tuple5<List<Tuple3<E1, E2, E3>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Tuple3<String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple3<E1, E2, E3>> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Object>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple3.get3();
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, (Tuple3<String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + ".")), sqlPageQuery.getParams());
        } else {
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, prefixes, sqlPageQuery.getParams());
        }
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, params);
    }

    private <E1, E2, E3, E4> Tuple5<List<Tuple4<E1, E2, E3, E4>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Tuple4<String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple4<E1, E2, E3, E4>> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Object>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple3.get3();
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, (Tuple4<String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + ".")), sqlPageQuery.getParams());
        } else {
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, prefixes, sqlPageQuery.getParams());
        }
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, params);
    }

    private <E1, E2, E3, E4, E5> Tuple5<List<Tuple5<E1, E2, E3, E4, E5>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Class<E5> entityType5, Tuple5<String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple5<E1, E2, E3, E4, E5>> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Object>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple3.get3();
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, (Tuple5<String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + ".")), sqlPageQuery.getParams());
        } else {
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, prefixes, sqlPageQuery.getParams());
        }
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, params);
    }

    private <E1, E2, E3, E4, E5, E6> Tuple5<List<Tuple6<E1, E2, E3, E4, E5, E6>>, String, TplExecuteConfig, ConditionParamsManager, Map<String, Object>> findList(TplExecuteId tplExecuteId, Class<E1> entityType1, Class<E2> entityType2, Class<E3> entityType3, Class<E4> entityType4, Class<E5> entityType5, Class<E6> entityType6, Tuple6<String, String, String, String, String, String> prefixes, Map<String, Object> params, int offset, int limit) {
        Tuple4<String, TplExecuteConfig, ConditionParamsManager, PropertiesMappingManager> tuple3 = this.getQueryExecution(tplExecuteId, params, entityType1, entityType2);
        List<Tuple6<E1, E2, E3, E4, E5, E6>> list = null;
        String sql = (String)tuple3.get0();
        ConditionParamsManager manager = (ConditionParamsManager)tuple3.get2();
        SqlPageFactory.SqlPageQuery<Map<String, Object>> sqlPageQuery = this.sqlPageFactory.toPage(this.jdbc.getDialect(), sql, offset, limit, this.getEffectiveParamMap(params, manager));
        if (prefixes == null) {
            PropertiesMappingManager propManager = (PropertiesMappingManager)tuple3.get3();
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, (Tuple6<String, String, String, String, String, String>)Tuples.of((Object)(propManager.getValue(0).getAlias() + "."), (Object)(propManager.getValue(1).getAlias() + "."), (Object)(propManager.getValue(2).getAlias() + "."), (Object)(propManager.getValue(3).getAlias() + "."), (Object)(propManager.getValue(4).getAlias() + "."), (Object)(propManager.getValue(5).getAlias() + ".")), sqlPageQuery.getParams());
        } else {
            list = this.jdbc.query(sqlPageQuery.getSql(), entityType1, entityType2, entityType3, entityType4, entityType5, entityType6, prefixes, sqlPageQuery.getParams());
        }
        return Tuples.of(list, (Object)sql, (Object)tuple3.get1(), (Object)manager, params);
    }

    private <T extends Tuple> int count(TplExecuteId tplExecuteId, String sql, Map<String, Object> params, Map<String, Object> paramsWithLimit, ConditionParamsManager conditionParamsManager, TplExecuteConfig config) {
        String countSql = null;
        ConditionParamsManager manager = null;
        if (Lang.isEmpty((String)config.getCount())) {
            countSql = SqlUtils.convertSelectToCount((String)sql);
            manager = conditionParamsManager;
        } else {
            Tuple2<String, ConditionParamsManager> countTuple = this.getCountExecution(tplExecuteId, params, config);
            countSql = (String)countTuple.get0();
            manager = (ConditionParamsManager)countTuple.get1();
        }
        return this.jdbc.queryInt(countSql, this.getEffectiveParamMap(paramsWithLimit, manager));
    }

    private Map<String, Object> getEffectiveParamMap(Map<String, Object> params, ConditionParamsManager manager) {
        return params.entrySet().stream().filter(t -> !manager.filterParamName((String)t.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.transvert((String)e.getKey(), e.getValue(), manager)));
    }

    private Object transvert(String name, Object value, ConditionParamsManager manager) {
        ConditionParamsManager.Param p = manager.getParam(name);
        if (p != null && Lang.isNotEmpty((String)p.getTransverter())) {
            Transverter transverter = this.transverterManager.getExist(p.getTransverter());
            return transverter.transvert(p.getTransverter(), value);
        }
        return value;
    }

    public SqlPageFactory getSqlPageFactory() {
        return this.sqlPageFactory;
    }
}

