/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.sql.dml;

import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.model.ColumnElement;
import cn.featherfly.common.db.builder.model.ConditionColumnElement;
import cn.featherfly.common.db.builder.model.SqlElement;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.operator.ComparisonOperator;
import cn.featherfly.common.repository.AliasRepository;
import cn.featherfly.common.repository.Field;
import cn.featherfly.common.repository.RepositoryAwareField;
import cn.featherfly.common.repository.builder.BuilderException;
import cn.featherfly.common.repository.builder.BuilderExceptionCode;
import cn.featherfly.hammer.expression.condition.Expression;
import cn.featherfly.hammer.expression.condition.ParamedExpression;
import java.util.function.Predicate;

public class SqlConditionExpressionBuilder
implements ParamedExpression,
SqlBuilder {
    private ConditionColumnElement conditionColumnElement;

    public SqlConditionExpressionBuilder(Dialect dialect, String name, Object value, ComparisonOperator comparisonOperator, Predicate<?> ignoreStrategy) {
        this(dialect, name, value, comparisonOperator, null, ignoreStrategy);
    }

    public SqlConditionExpressionBuilder(Dialect dialect, String name, Object value, ComparisonOperator comparisonOperator, String queryAlias, Predicate<?> ignoreStrategy) {
        this(dialect, name, value, comparisonOperator, ComparisonOperator.MatchStrategy.AUTO, queryAlias, ignoreStrategy);
    }

    public SqlConditionExpressionBuilder(Dialect dialect, String name, Object value, ComparisonOperator comparisonOperator, ComparisonOperator.MatchStrategy matchStrategy, String queryAlias, Predicate<?> ignoreStrategy) {
        this.init(dialect, name, value, comparisonOperator, matchStrategy, queryAlias, ignoreStrategy);
    }

    private void init(Dialect dialect, String name, Object value, ComparisonOperator comparisonOperator, ComparisonOperator.MatchStrategy matchStrategy, String queryAlias, Predicate<?> ignoreStrategy) {
        if (comparisonOperator == null) {
            throw new BuilderException(BuilderExceptionCode.createQueryOperatorNullCode());
        }
        if (value instanceof RepositoryAwareField) {
            RepositoryAwareField f = (RepositoryAwareField)value;
            AliasRepository r = (AliasRepository)f.repository();
            ColumnElement se = new ColumnElement(dialect, f.name(), r.alias());
            this.conditionColumnElement = new ConditionColumnElement(dialect, name, (Object)se, comparisonOperator, matchStrategy, queryAlias, ignoreStrategy);
        } else if (value instanceof Field) {
            Field f = (Field)value;
            ColumnElement se = new ColumnElement(dialect, f.name());
            this.conditionColumnElement = new ConditionColumnElement(dialect, name, (Object)se, comparisonOperator, matchStrategy, queryAlias, ignoreStrategy);
        } else if (value instanceof Expression) {
            SqlElement se = () -> ((Expression)value).expression();
            this.conditionColumnElement = new ConditionColumnElement(dialect, name, (Object)se, comparisonOperator, matchStrategy, queryAlias, ignoreStrategy);
        } else {
            this.conditionColumnElement = new ConditionColumnElement(dialect, name, value, comparisonOperator, matchStrategy, queryAlias, ignoreStrategy);
        }
    }

    public ConditionColumnElement getConditionColumnElement() {
        return this.conditionColumnElement;
    }

    public Object getParam() {
        return this.conditionColumnElement.getParam();
    }

    public String build() {
        return this.conditionColumnElement.toSql();
    }

    public String toString() {
        return this.build();
    }

    public String expression() {
        return this.build();
    }
}

