/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeyHolder;
import cn.featherfly.hammer.sqldb.jdbc.GeneratedKeysHolder;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractBatchExecuteOperate;
import com.speedment.common.tuple.Tuple2;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class InsertOperate<T>
extends AbstractBatchExecuteOperate<T> {
    public InsertOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    @Override
    protected int doExecuteBatch(List<T> entities) {
        List pks = this.classMapping.getPrivaryKeyPropertyMappings();
        Tuple2 tuple = ClassMappingUtils.getInsertBatchSqlAndParamPositions((int)entities.size(), (JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        String sql = (String)tuple.get0();
        if (pks.size() == 1) {
            return this.jdbc.updateBatch(sql, entities.size(), this.createGeneratedKeysHolder(entities, pks), this.getBatchParameters(entities, (Map)tuple.get1()));
        }
        return this.jdbc.updateBatch(sql, entities.size(), this.getBatchParameters(entities, (Map)tuple.get1()));
    }

    @Override
    public int execute(final T entity) {
        final List pks = this.classMapping.getPrivaryKeyPropertyMappings();
        if (pks.size() == 1) {
            return this.jdbc.update(this.sql, new GeneratedKeyHolder<Serializable>(){

                @Override
                public void acceptKey(Serializable key) {
                    if (BeanUtils.getProperty((Object)entity, (String)((JdbcPropertyMapping)pks.get(0)).getPropertyName()) == null) {
                        BeanUtils.setProperty((Object)entity, (String)((JdbcPropertyMapping)pks.get(0)).getPropertyName(), (Object)key);
                    }
                }

                @Override
                public Type<Serializable> getType() {
                    return BeanDescriptor.getBeanDescriptor((Class)InsertOperate.this.classMapping.getType()).getBeanProperty(((JdbcPropertyMapping)pks.get(0)).getPropertyName());
                }
            }, this.getParameters(entity));
        }
        return this.jdbc.update(this.sql, this.getParameters(entity));
    }

    @Override
    protected int[] doExecute(List<T> entities) {
        List pks = this.classMapping.getPrivaryKeyPropertyMappings();
        Object[][] argsList = new Object[entities.size()][];
        Lang.each(entities, (e, i) -> {
            argsList[i] = this.getParameters(e);
        });
        int[] results = pks.size() == 1 ? this.jdbc.updateBatch(this.sql, this.createGeneratedKeysHolder(entities, pks), argsList) : this.jdbc.updateBatch(this.sql, argsList);
        return results;
    }

    @Override
    protected boolean supportBatch() {
        return this.jdbc.getDialect().supportInsertBatch();
    }

    @Override
    protected void initSql() {
        Tuple2 tuple = ClassMappingUtils.getInsertSqlAndParamPositions((JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.propertyPositions.putAll((Map)tuple.get1());
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    private GeneratedKeysHolder<Serializable> createGeneratedKeysHolder(final List<T> entities, final List<JdbcPropertyMapping> pks) {
        return new GeneratedKeysHolder<Serializable>(){

            public void acceptKey(Serializable key, int row) {
                if (BeanUtils.getProperty(entities.get(row), (String)((JdbcPropertyMapping)pks.get(0)).getPropertyName()) == null) {
                    BeanUtils.setProperty(entities.get(row), (String)((JdbcPropertyMapping)pks.get(0)).getPropertyName(), (Object)key);
                }
            }

            @Override
            public Type<Serializable> getType() {
                return BeanDescriptor.getBeanDescriptor((Class)InsertOperate.this.classMapping.getType()).getBeanProperty(((JdbcPropertyMapping)pks.get(0)).getPropertyName());
            }

            @Override
            public void acceptKey(List<Serializable> keys) {
                for (int i = 0; i < keys.size(); ++i) {
                    this.acceptKey(keys.get(i), i);
                }
            }
        };
    }
}

