/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.hammer.sqldb.SqldbHammerException;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractQueryOperate;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GetOperate<T>
extends AbstractQueryOperate<T> {
    private List<JdbcPropertyMapping> pkPms;

    public GetOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    public Serializable getId(T entity) {
        if (entity == null) {
            return null;
        }
        if (this.pkPms.size() == 1) {
            return (Serializable)BeanUtils.getProperty(entity, (String)this.pkPms.get(0).getPropertyName());
        }
        if (this.pkPms.size() > 1) {
            throw new SqldbHammerException("multy id defined in entity [" + entity.getClass().getName() + "], you can invoke getIds(entity) method instead");
        }
        this.logger.debug("no id defined in entity {}", (Object)entity.getClass().getName());
        return null;
    }

    public List<Serializable> getIds(T entity) {
        if (entity == null) {
            return Collections.emptyList();
        }
        return this.pkPms.stream().map(p -> (Serializable)BeanUtils.getProperty((Object)entity, (String)ClassMappingUtils.getPropertyAliasName((JdbcPropertyMapping)p))).collect(Collectors.toList());
    }

    @Override
    public T execute(Serializable id) {
        return (T)this.get((T)id);
    }

    public T get(Serializable id) {
        return (T)this.get((T)id, false);
    }

    public T get(Serializable id, boolean forUpdate) {
        this.assertId(id);
        if (forUpdate) {
            if (this.meta.getFeatures().supportsSelectForUpdate()) {
                return this.jdbc.querySingle(this.sql + " for update", (res, rowNum) -> this.mapRow(res, rowNum), new Object[]{id});
            }
            throw new SqldbHammerException(Strings.format((String)"unsupport [select...for update] with database {} - {}", (Object[])new Object[]{this.meta.getProductName(), this.meta.getProductVersion()}));
        }
        return this.jdbc.querySingle(this.sql, (res, rowNum) -> this.mapRow(res, rowNum), new Object[]{id});
    }

    public T get(T entity) {
        return this.get(entity, false);
    }

    public T get(T entity, boolean forUpdate) {
        if (forUpdate) {
            return this.jdbc.querySingle(this.sql + " for update", (res, rowNum) -> this.mapRow(res, rowNum), this.assertAndGetIds(entity));
        }
        return this.jdbc.querySingle(this.sql, (res, rowNum) -> this.mapRow(res, rowNum), this.assertAndGetIds(entity));
    }

    @Override
    protected void initSql() {
        this.sql = ClassMappingUtils.getSelectByPkSql((JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.pkPms = this.classMapping.getPrivaryKeyPropertyMappings();
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    protected void assertId(Object id) {
        if (Lang.isEmpty((Object)id)) {
            throw new SqldbHammerException("#get.id.null");
        }
    }

    protected Object[] assertAndGetIds(T entity) {
        this.assertId(entity);
        List<Serializable> ids = this.getIds(entity);
        this.assertId(ids);
        return ids.toArray();
    }
}

