/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractBatchExecuteOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.BatchExecuteOperate;
import com.speedment.common.tuple.Tuple2;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DeleteOperate<T>
extends AbstractBatchExecuteOperate<T>
implements BatchExecuteOperate<T> {
    public DeleteOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    public int delete(Serializable id) {
        return this.jdbc.update(this.sql, id);
    }

    public int[] deleteBatch(Serializable ... ids) {
        return this.deleteBatch(ArrayUtils.toList((Object[])ids));
    }

    public <ID extends Serializable> int[] deleteBatch(List<ID> ids) {
        if (Lang.isEmpty(ids)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((int)ids.size(), (JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        return new int[]{this.jdbc.update((String)tuple.get0(), ids.toArray())};
    }

    @Override
    protected void initSql() {
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        this.sql = (String)tuple.get0();
        this.propertyPositions.putAll((Map)tuple.get1());
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    @Override
    protected Object[] getBatchParameters(List<T> entities, Map<Integer, JdbcPropertyMapping> propertyPositions) {
        Object[] params = new Object[propertyPositions.size()];
        int pkNum = propertyPositions.size() / entities.size();
        int i = 0;
        Object entity = null;
        for (Map.Entry<Integer, JdbcPropertyMapping> propertyPosition : propertyPositions.entrySet()) {
            if (i % pkNum == 0) {
                entity = entities.get(i / pkNum);
            }
            params[i] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue().getPropertyFullName());
            ++i;
        }
        return params;
    }

    @Override
    protected boolean supportBatch() {
        return true;
    }

    @Override
    protected int doExecuteBatch(List<T> entities) {
        int bs = entities.size();
        Tuple2 tuple = ClassMappingUtils.getDeleteSqlAndParamPositions((int)bs, (JdbcClassMapping)this.classMapping, (Dialect)this.jdbc.getDialect());
        return this.jdbc.updateBatch((String)tuple.get0(), bs, this.getBatchParameters(entities, (Map)tuple.get1()));
    }

    @Override
    protected int[] doExecute(List<T> entities) {
        Object[][] argsList = new Object[entities.size()][];
        Lang.each(entities, (e, i) -> {
            argsList[i] = this.getParameters(e);
        });
        return this.jdbc.updateBatch(this.sql, argsList);
    }
}

