/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.sqldb.jdbc.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcClassMapping;
import cn.featherfly.common.db.mapping.JdbcPropertyMapping;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.hammer.sqldb.jdbc.Jdbc;
import cn.featherfly.hammer.sqldb.jdbc.debug.MappingDebugMessage;
import cn.featherfly.hammer.sqldb.jdbc.operate.AbstractOperate;
import cn.featherfly.hammer.sqldb.jdbc.operate.QueryOperate;
import java.sql.ResultSet;

public abstract class AbstractQueryOperate<T>
extends AbstractOperate<T>
implements QueryOperate<T> {
    public AbstractQueryOperate(Jdbc jdbc, JdbcClassMapping<T> classMapping, SqlTypeMappingManager sqlTypeMappingManager, DatabaseMetadata databaseMetadata) {
        super(jdbc, classMapping, sqlTypeMappingManager, databaseMetadata);
    }

    protected T mapRow(cn.featherfly.common.repository.mapping.ResultSet rs, int rowNumber) {
        if (rs instanceof SqlResultSet) {
            SqlResultSet sqlrs = (SqlResultSet)rs;
            return this.mapRow(sqlrs.getResultSet(), rowNumber);
        }
        return (T)BeanUtils.instantiateClass((Class)this.classMapping.getType());
    }

    protected T mapRow(ResultSet resultSet, int rowNumber) {
        int index = 1;
        Object mappedObject = BeanUtils.instantiateClass((Class)this.classMapping.getType());
        MappingDebugMessage mappingDebugMessage = new MappingDebugMessage(this.isDebug());
        for (JdbcPropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().isEmpty()) {
                Object value = propertyMapping.getJavaTypeSqlTypeOperator().get(resultSet, index);
                index = this.setProperty(rowNumber, mappedObject, index, propertyMapping, value, mappingDebugMessage);
                continue;
            }
            for (JdbcPropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                Object value = subPropertyMapping.getJavaTypeSqlTypeOperator().get(resultSet, index);
                index = this.setProperty(rowNumber, mappedObject, index, subPropertyMapping, value, mappingDebugMessage);
            }
        }
        if (rowNumber == 0 && this.logger.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append("\n---------- Mapping " + this.classMapping.getType().getName() + " Start ----------\n").append(mappingDebugMessage.toString()).append("---------- Mapping " + this.classMapping.getType().getName() + " End ----------\n");
            this.logger.debug(debugMessage.toString());
        }
        return (T)mappedObject;
    }

    private int setProperty(int rowNumber, T mappedObject, int index, JdbcPropertyMapping propertyMapping, Object value, MappingDebugMessage mappingDebugMessage) {
        String propertyName = ClassMappingUtils.getPropertyAliasName((JdbcPropertyMapping)propertyMapping);
        if (this.logger.isDebugEnabled() && rowNumber == 0) {
            mappingDebugMessage.debug(m -> m.addMapping(propertyMapping.getRepositoryFieldName(), propertyName, propertyName, propertyMapping.getPropertyType().getName()));
        }
        BeanUtils.setProperty(mappedObject, (String)propertyName, (Object)value);
        return ++index;
    }
}

